﻿class PageInfo extends MovieClip {
	private static var holder_mc:MovieClip;
	private static var noImage_mc:MovieClip;
	private static var title_txt:TextField;
	private static var name_txt:TextField;
	private static var path_txt:TextField;
	private static var size_txt:TextField;
	private static var date_txt:TextField;
	private static var charset_txt:TextField;
	private static var http_status_txt:TextField;
	private static var parentPath_str:String = "thumb/";
	private static var loader_mcl:MovieClipLoader = new MovieClipLoader();
	private static var my_mc:MovieClip;
	private static var myDepth:Number;
	private static var currentDepth:Number;
	private function PageInfo() {
		my_mc = this;
		myDepth = this.getDepth();
		trace([my_mc, myDepth]);
		holder_mc = this["holder_mc"];
		noImage_mc = this["noImage_mc"];
		title_txt = this["title_txt"];
		title_txt.autoSize = "left";
		name_txt = this["name_txt"];
		name_txt.autoSize = "left";
		path_txt = this["path_txt"];
		path_txt.autoSize = "left";
		size_txt = this["size_txt"];
		size_txt.autoSize = "left";
		date_txt = this["date_txt"];
		date_txt.autoSize = "left";
		charset_txt = this["charset_txt"];
		charset_txt.autoSize = "left";
		http_status_txt = this["http_status_txt"];
		http_status_txt.autoSize = "left";
		noImage_mc._visible = false;
		clearText();
	}
	static function showPageInfo(data:Object):Void {
		var thumbnail:String = data.thumbnail;
		showImage(thumbnail);
		setText(data);
	}
	static function clearPageInfo() {
		hideImage();
		clearText();
	}
	static function showImage(file_str:String):Void {
		if (file_str) {
			loadImage(parentPath_str+file_str+".jpg");
		} else {
			showNoImage();
		}
	}
	static function hideImage():Void {
		noImage_mc._visible = false;
		holder_mc.unloadMovie();
	}
	static function loadImage(path_str:String):Void {
		noImage_mc._visible = false;
		loader_mcl.loadClip(path_str, holder_mc);
	}
	static function showNoImage():Void {
		noImage_mc._visible = true;
	}
	static function setText(data:Object):Void {
		title_txt.text = data.title;
		name_txt.text = data.name;
		path_txt.text = data.path;
		size_txt.text = data.size;
		date_txt.text = data.date;
		charset_txt.text = data.charset;
		http_status_txt.text = data.status;
	}
	static function clearText():Void {
		title_txt.text = "--";
		name_txt.text = "--";
		path_txt.text = "--";
		size_txt.text = "--";
		date_txt.text = "--";
		charset_txt.text = "--";
		http_status_txt.text = "--";
	}
	static function setDepth(nDepth:Number):Void {
		my_mc.swapDepths(nDepth);
		currentDepth = my_mc.getDepth();
	}
	static function resetDepth():Void {
		my_mc.swapDepths(myDepth);
		currentDepth = my_mc.getDepth();
	}
	static function reset():Void {
		clearPageInfo();
		resetDepth();
	}
}
