/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JToggleButton;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZToggleButtonAction;
import jp.co.iti.fagot.ui.UIFactory;

public class ZGroupToggleButton {
    protected IZApp mApp = null;
    protected Hashtable mActions = null;
    protected String mDefault = null;
    protected String mState = null;
    protected boolean mLock = false;
    protected Vector mListener = new Vector();

    public ZGroupToggleButton(IZApp iZApp, UIFactory uIFactory, String[] stringArray) {
        this.mApp = iZApp;
        this.mActions = new Hashtable();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            JToggleButton jToggleButton = (JToggleButton)uIFactory.getToolItem(string);
            if (jToggleButton != null) {
                this.mActions.put(string, new ZGroupToggleButtonAction(iZApp, jToggleButton, string));
                continue;
            }
            System.out.println("Button not found:" + string);
        }
        this.mDefault = stringArray[0];
        this.setDefault();
    }

    public void setDefault() {
        Enumeration enumeration = this.mActions.elements();
        while (enumeration.hasMoreElements()) {
            ZToggleButtonAction zToggleButtonAction = (ZToggleButtonAction)enumeration.nextElement();
            zToggleButtonAction.off();
        }
        this.setState(this.mDefault);
    }

    public void setState(String string) {
        Serializable serializable;
        String string2 = this.mState;
        if (this.mState != null && (serializable = this.getAction(this.mState)) != null) {
            serializable.off();
        }
        this.mState = string;
        if (this.mState != null && (serializable = this.getAction(this.mState)) != null) {
            serializable.on();
        }
        serializable = new PropertyChangeEvent(this, "groupbar", string2, this.mState);
        this.firePropertyChanged((PropertyChangeEvent)serializable);
    }

    public String getState() {
        return this.mState;
    }

    protected ZToggleButtonAction getAction(String string) {
        return (ZToggleButtonAction)this.mActions.get(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mListener.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mListener.remove(propertyChangeListener);
    }

    public void firePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.mLock) {
            return;
        }
        this.mLock = true;
        Enumeration enumeration = this.mListener.elements();
        while (enumeration.hasMoreElements()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
        this.mLock = false;
    }

    public class ZGroupToggleButtonAction
    extends ZToggleButtonAction {
        public ZGroupToggleButtonAction(IZApp iZApp, JToggleButton jToggleButton, String string) {
            super(iZApp, jToggleButton, string);
        }

        public void doAction(ActionEvent actionEvent) {
            ZGroupToggleButton.this.setState(this.getActionName());
        }
    }
}

