/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.action;

import java.awt.event.ActionEvent;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;
import jp.co.iti.fagot.ui.UFrame;

public class ZUIAction
extends ZAction {
    protected UFrame mFrame = null;
    public static final String ENV_LF = "app.lookandfeel";
    public static final String LF_METAL = "lf_metal";
    public static final String LF_MOTIF = "lf_motif";
    public static final String LF_WINDOWS = "lf_windows";
    public static final String CL_METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String CL_MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String CL_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String CL_MAC = "com.apple.mrj.swing.MacLookAndFeel";

    public ZUIAction(IZApp iZApp, UFrame uFrame, String string) {
        super(iZApp, string);
        this.mFrame = uFrame;
    }

    public void doAction(ActionEvent actionEvent) {
        String string = null;
        if (this.getActionName().equals(LF_METAL)) {
            string = CL_METAL;
        } else if (this.getActionName().equals(LF_MOTIF)) {
            string = CL_MOTIF;
        } else if (this.getActionName().equals(LF_WINDOWS)) {
            string = System.getProperty("os.arch").equals("ppc") ? CL_MAC : CL_WINDOWS;
        }
        this.getApp().getResource().putString(ENV_LF, string);
        this.mFrame.setLookAndFeel();
    }

    public void update() {
        boolean bl = true;
        String string = this.getApp().getResource().getString(ENV_LF);
        if (this.getActionName().equals(LF_METAL)) {
            if (!string.equals(CL_METAL)) {
                bl = false;
            }
        } else if (this.getActionName().equals(LF_MOTIF)) {
            if (!string.equals(CL_MOTIF)) {
                bl = false;
            }
        } else if (this.getActionName().equals(LF_WINDOWS)) {
            if (System.getProperty("os.arch").equals("ppc")) {
                if (!string.equals(CL_MAC)) {
                    bl = false;
                }
            } else if (!string.equals(CL_WINDOWS)) {
                bl = false;
            }
        }
        this.firePropertyChange("checked", null, new Boolean(bl));
    }
}

