/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Vector;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.fob.xml.XDocument;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.gob.PTransform;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class DocDocument
extends XDocument {
    protected String mDocumentId = "default";
    protected boolean mIndenting = true;

    public DocDocument() {
    }

    public DocDocument(String string) {
        this();
        this.setDocumentId(string);
    }

    public void setDocumentId(String string) {
        this.mDocumentId = string;
        ZProperties zProperties = DocManager.loadProperty("document");
        this.setEncoding(zProperties.getProperty(this.mDocumentId + ".encoding"));
        this.mIndenting = zProperties.getBoolean(this.mDocumentId + ".indenting", true);
    }

    public String getDocumentId() {
        return this.mDocumentId;
    }

    public boolean getIndenting() {
        return this.mIndenting;
    }

    public Color getBackground(String string) {
        return new Color(0xFFFFFF);
    }

    public Dimension getPreferredSize(String string) {
        DocElement docElement = (DocElement)((Object)this.getRootElement(string));
        if (docElement == null) {
            return this.getLogicalSize();
        }
        double d = docElement.getDisplayScale(string);
        PTransform pTransform = new PTransform(d, 0.0, 0.0, d, 0.0, 0.0);
        Dimension dimension = this.getLogicalSize();
        ZPoint zPoint = pTransform.transform(new ZPoint(dimension.getWidth(), dimension.getHeight()));
        dimension = new Dimension((int)zPoint.getX(), (int)zPoint.getY());
        return dimension;
    }

    public Dimension getLogicalSize() {
        return new Dimension(800, 600);
    }

    public void initDocument() {
        ZProperties zProperties = DocManager.loadProperty("document");
        String string = zProperties.getProperty(this.mDocumentId + ".doctype.root");
        String string2 = zProperties.getProperty(this.mDocumentId + ".doctype.public");
        String string3 = zProperties.getProperty(this.mDocumentId + ".doctype.ststem");
        if (string2 != null || string3 != null) {
            DocumentType documentType = this.createDocumentType(string, string2, string3);
            this.appendChild(documentType);
        }
        for (int i = 1; i < 100; ++i) {
            String string4 = zProperties.getProperty(this.mDocumentId + ".processinginstruction.target." + i);
            String string5 = zProperties.getProperty(this.mDocumentId + ".processinginstruction.data." + i);
            if (string4 == null || string5 == null) break;
            ProcessingInstruction processingInstruction = this.createProcessingInstruction(string4, string5);
            this.appendChild(processingInstruction);
        }
        Element element = this.createElementNS(null, string);
        this.appendChild(element);
    }

    public Element getRootElement(String string) {
        return this.getDocumentElement();
    }

    public Element createElement(String string) throws DOMException {
        return this.createElementNS(null, string);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        Object object = (Element)((Object)DocManager.createElement(this, string, string2));
        if (object == null) {
            String[] stringArray = ZString.tokenize(string2, "@");
            if (stringArray.length == 2) {
                object = (Element)((Object)DocManager.createElement(this, string, stringArray[0]));
                if (object instanceof DocElement) {
                    ((DocElement)object).setSubTag(stringArray[1]);
                }
            } else {
                object = new DocElement();
                ((DocElement)object).constructElement(this, string, string2);
            }
        }
        return object;
    }

    public Vector createGobs(String string) {
        DocElement docElement = (DocElement)((Object)this.getRootElement(string));
        if (docElement != null) {
            return docElement.createGobs(string, true);
        }
        return new Vector();
    }

    public Vector createSkeltonGobs(String string) {
        DocElement docElement = (DocElement)((Object)this.getRootElement(string));
        if (docElement != null) {
            return docElement.createSkeltonGobs(string, true);
        }
        return new Vector();
    }
}

