/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.util.Vector;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.fob.xml.XElementNS;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.IGobContainer;
import jp.co.iti.fagot.gob.PTransform;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class DocElement
extends XElementNS
implements IGobContainer {
    protected boolean mSelect = false;

    protected DocElement() throws DOMException {
    }

    public boolean hasRect(String string) {
        XElementNS xElementNS = this.findChildElement(".ViewInfo." + string, null);
        if (xElementNS != null) {
            return xElementNS.hasAttribute("X") && xElementNS.hasAttribute("Y") && xElementNS.hasAttribute("Width") && xElementNS.hasAttribute("Height");
        }
        return false;
    }

    public void setRect(String string, ZRectangle zRectangle) {
        XElementNS xElementNS = this.getChildElement(".ViewInfo." + string, null);
        xElementNS.setDoubleAttr("X", zRectangle.getX());
        xElementNS.setDoubleAttr("Y", zRectangle.getY());
        xElementNS.setDoubleAttr("Width", zRectangle.getWidth());
        xElementNS.setDoubleAttr("Height", zRectangle.getHeight());
    }

    public ZRectangle getRect(String string) {
        XElementNS xElementNS = this.findChildElement(".ViewInfo." + string, null);
        if (xElementNS == null) {
            return new ZRectangle();
        }
        double d = xElementNS.getDoubleAttr("X", 0.0);
        double d2 = xElementNS.getDoubleAttr("Y", 0.0);
        double d3 = xElementNS.getDoubleAttr("Width", 0.0);
        double d4 = xElementNS.getDoubleAttr("Height", 0.0);
        return new ZRectangle(d, d2, d3, d4);
    }

    public void setDisplayScale(String string, double d) {
        XElementNS xElementNS = this.getChildElement(".ViewInfo." + string, null);
        xElementNS.setDoubleAttr("DisplayScale", d);
    }

    public double getDisplayScale(String string) {
        XElementNS xElementNS = this.findChildElement(".ViewInfo." + string, null);
        if (xElementNS == null) {
            return 1.0;
        }
        return xElementNS.getDoubleAttr("DisplayScale", 1.0);
    }

    public PTransform getDisplayScaledTransform(String string) {
        XElementNS xElementNS = this.getChildElement(".ViewInfo." + string, null);
        if (xElementNS == null) {
            return new PTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        }
        double d = xElementNS.getDoubleAttr("DisplayOffsetX", 0.0);
        double d2 = xElementNS.getDoubleAttr("DisplayOffsetY", 0.0);
        double d3 = this.getDisplayScale(string);
        return new PTransform(d3, 0.0, 0.0, d3, d, d2);
    }

    public void removeGob(GElement gElement) {
        this.removeFromDocTree();
    }

    public void removeFromDocTree() {
        DocElement docElement = (DocElement)((Object)this.getParentNode());
        if (docElement != null) {
            docElement.removeChild((Node)((Object)this));
        }
        this.setStatus("remove");
    }

    public void setStatus(String string) {
        this.setAttribute("DocElementStatus", string);
        for (int i = 0; i < this.getLength(); ++i) {
            Node node = this.item(i);
            if (!(node instanceof DocElement)) continue;
            ((DocElement)((Object)node)).setStatus(string);
        }
    }

    public String getStatus() {
        return this.getAttribute("DocElementStatus");
    }

    public Vector createGobs(String string, boolean bl) {
        Vector vector = new Vector();
        return vector;
    }

    public void preCreateGobs(String string) {
        for (int i = 0; i < this.getLength(); ++i) {
            Node node = this.item(i);
            if (!(node instanceof DocElement)) continue;
            ((DocElement)((Object)node)).preCreateGobs(string);
        }
    }

    public Vector createSkeltonGobs(String string, boolean bl) {
        return this.createGobs(string, bl);
    }

    public Vector createChildGobs(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.getLength(); ++i) {
            Node node = this.item(i);
            if (!(node instanceof DocElement)) continue;
            vector.addAll(((DocElement)((Object)node)).createGobs(string, false));
        }
        return vector;
    }

    public String getContextKey(String string) {
        return this.getTagName() + "." + string;
    }

    public byte getHitMode(GElement gElement, ZPoint zPoint) {
        return gElement.getHitModeGob(zPoint);
    }

    public byte getPreMoveMode(GElement gElement, ZPoint zPoint) {
        return gElement.getPreMoveModeGob(zPoint);
    }

    public byte getConnectMode(GElement gElement, ZPoint zPoint, Object object) {
        return gElement.getConnectModeGob(zPoint, object);
    }

    public void verbDblClick(GElement gElement, ZPoint zPoint) {
        gElement.verbDblClickGob(zPoint);
    }

    public void moveStart(GElement gElement, DocGridControler docGridControler) {
        gElement.moveStartGob(docGridControler);
    }

    public ZPath getMovingPath(GElement gElement, DocGridControler docGridControler) {
        return gElement.getMovingPathGob(docGridControler);
    }

    public void moveEnd(GElement gElement, DocGridControler docGridControler) {
        gElement.moveEnd(docGridControler);
    }

    public boolean isSelect() {
        return this.mSelect;
    }

    public boolean setSelect(GElement gElement, boolean bl) {
        this.mSelect = bl;
        return this.mSelect;
    }

    public void setText(String string) {
    }

    public String getText() {
        return null;
    }

    public void setSubTag(String string) {
    }
}

