/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Enumeration;
import java.util.Stack;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.gob.PTransform;
import jp.co.iti.fagot.util.ZReverseEnumeration;

public class DocGridControler {
    protected double mX = 10.0;
    protected double mY = 10.0;
    protected boolean mState = true;
    protected ZPoint mStartPoint = new ZPoint(0.0, 0.0);
    protected ZPoint mMovePoint = new ZPoint(0.0, 0.0);
    protected byte mMoveMode = 0;
    protected int mMoveMask = 0;
    protected static final byte HORZ = 0;
    protected static final byte VERT = 1;
    protected Stack mTrans = new Stack();
    protected DocPane mEditor = null;
    protected PTransform mHashTrans = null;
    protected PTransform mHashTransLP = null;
    protected PTransform mHashInverse = null;
    protected PTransform mHashInverseZone = null;

    public DocGridControler() {
    }

    public DocGridControler(boolean bl) {
        this.setEnable(bl);
    }

    public void setEnable(boolean bl) {
        this.mState = bl;
    }

    public void setGrid(double d, double d2) {
        this.mX = d;
        this.mY = d2;
    }

    public void setMoveStart(ZPoint zPoint, byte by) {
        this.mStartPoint = zPoint;
        this.mMoveMode = by;
    }

    public void setMoving(ZPoint zPoint, int n) {
        this.mMovePoint = zPoint;
        this.mMoveMask = n;
    }

    public void pushTransform(PTransform pTransform) {
        this.mTrans.push(pTransform);
        this.createHashTransform();
    }

    public void popTransform() {
        this.mTrans.pop();
        this.createHashTransform();
    }

    protected void createHashTransform() {
        PTransform pTransform;
        PTransform pTransform2;
        this.mHashTrans = null;
        Enumeration enumeration = new ZReverseEnumeration(this.mTrans);
        while (enumeration.hasMoreElements()) {
            pTransform2 = (PTransform)enumeration.nextElement();
            if (this.mHashTrans == null) {
                this.mHashTrans = new PTransform(pTransform2);
                continue;
            }
            this.mHashTrans.add(pTransform2);
        }
        this.mHashTransLP = null;
        enumeration = new ZReverseEnumeration(this.mTrans);
        pTransform2 = (PTransform)enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            pTransform = (PTransform)enumeration.nextElement();
            if (this.mHashTransLP == null) {
                this.mHashTransLP = new PTransform(pTransform2);
            } else {
                this.mHashTransLP.add(pTransform2);
            }
            pTransform2 = pTransform;
        }
        this.mHashInverse = null;
        this.mHashInverseZone = null;
        enumeration = this.mTrans.elements();
        while (enumeration.hasMoreElements()) {
            pTransform = (PTransform)enumeration.nextElement();
            if (this.mHashInverse == null) {
                this.mHashInverse = new PTransform(pTransform);
                this.mHashInverseZone = new PTransform(pTransform);
                continue;
            }
            this.mHashInverse.add(pTransform);
        }
    }

    public ZPoint transform(ZPoint zPoint) {
        ZPoint zPoint2 = new ZPoint(zPoint);
        if (this.mHashTrans != null) {
            zPoint2 = this.mHashTrans.transform(zPoint2);
        }
        return zPoint2;
    }

    public ZPoint transformToLP(ZPoint zPoint) {
        ZPoint zPoint2 = new ZPoint(zPoint);
        if (this.mHashTransLP != null) {
            zPoint2 = this.mHashTransLP.transform(zPoint2);
        }
        return zPoint2;
    }

    public Shape transform(Shape shape) {
        Shape shape2 = shape;
        if (this.mHashTrans != null) {
            shape2 = this.mHashTrans.getTransform().createTransformedShape(shape);
        }
        return shape2;
    }

    public double transformY(double d) {
        double d2 = d;
        if (this.mHashTrans != null) {
            d2 *= this.mHashTrans.getTransform().getScaleY();
        }
        return d2;
    }

    public ZPoint inverseTransform(ZPoint zPoint) {
        ZPoint zPoint2 = new ZPoint(zPoint);
        if (this.mHashInverse != null) {
            zPoint2 = this.mHashInverse.inverseTransform(zPoint2);
        }
        return zPoint2;
    }

    public AffineTransform getTransform() {
        if (this.mHashInverse != null) {
            return this.mHashInverse.getTransform();
        }
        return null;
    }

    public AffineTransform getScaleTransform() {
        if (this.mHashInverse != null) {
            return this.mHashInverse.getScaleTransform();
        }
        return null;
    }

    public ZPoint getStartPoint() {
        return this.inverseTransform(this.mStartPoint);
    }

    public ZPoint getMovePoint() {
        return this.inverseTransform(this.mMovePoint);
    }

    public ZPoint getOffset() {
        return this.getMovePoint().minus(this.getStartPoint());
    }

    public ZPoint getPhigicalOffset() {
        return this.mMovePoint.minus(this.mStartPoint);
    }

    public void setMoveMode(byte by) {
        this.mMoveMode = by;
    }

    public byte getMoveMode() {
        return this.mMoveMode;
    }

    public int getMoveMask() {
        return this.mMoveMask;
    }

    public ZPoint getStartGrid() {
        return this.getGrid(this.getStartPoint());
    }

    public ZPoint getMoveGrid() {
        return this.getGrid(this.getMovePoint());
    }

    public ZPoint getMoveGridZone() {
        ZPoint zPoint = new ZPoint(this.mMovePoint);
        Enumeration enumeration = this.mTrans.elements();
        while (enumeration.hasMoreElements()) {
            PTransform pTransform = (PTransform)enumeration.nextElement();
            zPoint = pTransform.inverseTransform(zPoint);
        }
        return this.getGrid(zPoint);
    }

    public ZPoint getOffsetGrid() {
        return this.getGrid(this.getOffset());
    }

    public ZPoint getGrid(ZPoint zPoint) {
        return new ZPoint(this.getGrid((byte)0, zPoint.getX()), this.getGrid((byte)1, zPoint.getY()));
    }

    public double getGrid(byte by, double d) {
        if (this.mState) {
            double d2 = by == 0 ? this.mX : this.mY;
            double d3 = (double)((int)(d / d2)) * (double)((int)(d2 * 10.0)) / 10.0;
            double d4 = (double)((int)(d / d2) + 1) * (double)((int)(d2 * 10.0)) / 10.0;
            return d4 - d > d - d3 ? d3 : d4;
        }
        return d;
    }

    public double getOverGrid(byte by, double d, int n) {
        if (this.mState) {
            double d2;
            double d3 = d2 = by == 0 ? this.mX : this.mY;
            if (n == -1) {
                double d4 = (double)((int)(d / d2)) * (double)((int)(d2 * 10.0)) / 10.0;
                return d4;
            }
            double d5 = (double)((int)(d / d2) + 1) * (double)((int)(d2 * 10.0)) / 10.0;
            return d5;
        }
        return d;
    }

    public void setEditor(DocPane docPane) {
        this.mEditor = docPane;
    }

    public DocPane getEditor() {
        return this.mEditor;
    }
}

