/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.action.ZAction;
import jp.co.iti.fagot.doc.DocComponent;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocUIAdapter;
import jp.co.iti.fagot.fob.xml.XElementNS;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.util.ZKeyMap;

public class DocPane
extends DocComponent {
    protected boolean mUpdateGobs = true;
    protected boolean mPainted = false;
    protected boolean mCanPaint = true;
    protected DocElement mEditElement = null;
    protected ZRectangle mEditRect = null;
    protected JTextComponent mEditComponent = null;

    public DocPane() {
    }

    public DocPane(String string) {
        super(string);
    }

    public Color getBackground() {
        Color color = null;
        if (this.getDocument() != null) {
            color = this.getDocument().getBackground(this.getPanelId());
        }
        if (color == null) {
            color = super.getBackground();
        }
        return color;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = null;
        if (this.getDocument() != null) {
            dimension = this.getDocument().getPreferredSize(this.getPanelId());
        }
        if (dimension == null) {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    public ZPoint getCenter() {
        DocElement docElement = (DocElement)((Object)this.getDocument().getRootElement(this.getPanelId()));
        if (this.getParent() == null || !(this.getParent() instanceof JViewport)) {
            return null;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Point point = jViewport.getViewPosition();
        ZPoint zPoint = new ZPoint(point.x + jViewport.getWidth() / 2, point.y + jViewport.getHeight() / 2);
        if (docElement == null) {
            return zPoint;
        }
        ZPoint zPoint2 = docElement.getDisplayScaledTransform(this.getPanelId()).inverseTransform(zPoint);
        return zPoint2;
    }

    public void setCenter(ZPoint zPoint) {
        DocElement docElement = (DocElement)((Object)this.getDocument().getRootElement(this.getPanelId()));
        ZPoint zPoint2 = null;
        zPoint2 = docElement != null ? docElement.getDisplayScaledTransform(this.getPanelId()).transform(zPoint) : zPoint;
        this.setPaintMode(false);
        if (this.getParent() == null || !(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Dimension dimension = jViewport.getSize();
        Dimension dimension2 = this.getSize();
        Point point = new Point((int)(zPoint2.getX() - (double)(dimension.width / 2)), (int)(zPoint2.getY() - (double)(dimension.height / 2)));
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x > dimension2.width - dimension.width) {
            point.x = dimension2.width - dimension.width;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y > dimension2.height - dimension.height) {
            point.y = dimension2.height - dimension.height;
        }
        jViewport.setViewPosition(point);
        this.updateCenter(zPoint);
        this.setPaintMode(true);
    }

    public void updateCenter() {
        if (this.mPainted && this.canPaint()) {
            ZPoint zPoint = this.getCenter();
            this.updateCenter(zPoint);
        }
    }

    public void updateCenter(ZPoint zPoint) {
        DocElement docElement = (DocElement)((Object)this.getDocument().getRootElement(this.getPanelId()));
        if (docElement != null) {
            XElementNS xElementNS = docElement.getChildElement(".ViewInfo." + this.getPanelId(), null);
            xElementNS.setDoubleAttr("DisplayX", zPoint.getX());
            xElementNS.setDoubleAttr("DisplayY", zPoint.getY());
        }
    }

    public void updateRect(ZRectangle zRectangle) {
        double d = 100.0;
        JViewport jViewport = (JViewport)this.getParent();
        Dimension dimension = jViewport.getSize();
        double d2 = (double)dimension.width / Math.max((double)dimension.width, zRectangle.getWidth() + d * 2.0);
        double d3 = (double)dimension.height / Math.max((double)dimension.height, zRectangle.getHeight() + d * 2.0);
        double d4 = Math.min(d2, d3);
        String string = this.getPanelId();
        DocDocument docDocument = this.getDocument();
        DocElement docElement = (DocElement)((Object)docDocument.getRootElement(string));
        docElement.setDisplayScale(string, d4);
        jViewport.doLayout();
        this.setCenter(zRectangle.getCenter());
        this.mPainted = true;
    }

    public void setDocument(DocDocument docDocument) {
        super.setDocument(docDocument);
        this.mPainted = false;
        this.updateGobs();
    }

    public void editRestart() {
        this.mPainted = false;
    }

    public void updateGobs() {
        this.mUpdateGobs = true;
    }

    public boolean isUpdateGobs() {
        return this.mUpdateGobs;
    }

    public void updateLayout() {
        ZRectangle zRectangle = this.getGobRect();
        if (zRectangle != null) {
            this.updateRect(zRectangle);
        }
        this.repaint();
    }

    private ZRectangle getGobRect() {
        ZRectangle zRectangle = null;
        Vector vector = this.getDocument().createGobs(this.getPanelId());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            ZRectangle zRectangle2 = gElement.getTransformedBounds();
            if (zRectangle == null) {
                zRectangle = zRectangle2;
                continue;
            }
            zRectangle.union(zRectangle2);
        }
        return zRectangle;
    }

    public void createGobs() {
        DocDocument docDocument = this.getDocument();
        boolean bl = docDocument.isTransaction();
        if (!bl) {
            docDocument.beginTransaction();
        }
        Vector vector = GobManager.getElement(this.getPanelId());
        vector.removeAllElements();
        vector.addAll(docDocument.createGobs(this.getPanelId()));
        this.mUpdateGobs = false;
        if (!bl) {
            docDocument.commitPlus();
        }
        if (!this.mPainted) {
            this.mPainted = true;
            Dimension dimension = docDocument.getLogicalSize();
            ZPoint zPoint = new ZPoint(dimension.getWidth() / 2.0, dimension.getHeight() / 2.0);
            DocElement docElement = (DocElement)((Object)docDocument.getRootElement(this.getPanelId()));
            if (docElement != null) {
                XElementNS xElementNS = docElement.findChildElement(".ViewInfo." + this.getPanelId(), null);
                String string = xElementNS.getAttribute("DisplayX");
                if (string == null || string.length() <= 0) {
                    this.updateLayout();
                    return;
                }
                zPoint.setX(xElementNS.getDoubleAttr("DisplayX", zPoint.getX()));
                zPoint.setY(xElementNS.getDoubleAttr("DisplayY", zPoint.getY()));
            }
            this.setCenter(zPoint);
        }
    }

    public void setPaintMode(boolean bl) {
        this.mCanPaint = bl;
    }

    public boolean canPaint() {
        return this.mCanPaint;
    }

    public DocUIAdapter createUIAdapter() {
        return new DocUIAdapter(this);
    }

    public DocGridControler createGridControler() {
        DocGridControler docGridControler = new DocGridControler();
        docGridControler.setEditor(this);
        return docGridControler;
    }

    public Vector createDefaultKeyMap(IZApp iZApp) {
        Vector vector = new Vector();
        return vector;
    }

    public void setKeyMap(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ZKeyMap zKeyMap = (ZKeyMap)enumeration.nextElement();
            ZAction zAction = (ZAction)zKeyMap.getAction();
            this.getInputMap(2).put(zKeyMap.getKeyStroke(), zAction.getActionName());
            this.getActionMap().put(zAction.getActionName(), zAction);
        }
    }

    public void removeKeyMap(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ZKeyMap zKeyMap = (ZKeyMap)enumeration.nextElement();
            ZAction zAction = (ZAction)zKeyMap.getAction();
            this.getInputMap(2).remove(zKeyMap.getKeyStroke());
            this.getActionMap().remove(zAction.getActionName());
        }
    }

    public void setEditElement(DocElement docElement, ZRectangle zRectangle, boolean bl) {
        DocElement docElement2 = (DocElement)((Object)this.getDocument().getRootElement(this.getPanelId()));
        ZRectangle zRectangle2 = new ZRectangle(docElement2.getDisplayScaledTransform(this.getPanelId()).transform(zRectangle).getBounds2D());
        this.removeKeyMap(this.createDefaultKeyMap(ZApp.getTheApp()));
        this.mEditElement = docElement;
        this.mEditRect = zRectangle;
        this.mEditComponent = null;
        if (bl) {
            this.mEditComponent = new JTextArea();
        } else {
            this.mEditComponent = new JTextField();
            ((JTextField)this.mEditComponent).addActionListener(new DocEditActionListener());
        }
        String string = "Doc " + zRectangle2.getX() + " " + zRectangle2.getY() + " " + zRectangle2.getWidth() + " " + zRectangle2.getHeight();
        this.mEditComponent.setText(docElement.getText());
        this.add(string, this.mEditComponent);
        this.validate();
    }

    public boolean editEnd() {
        if (this.mEditComponent != null) {
            String string = this.mEditElement.getText();
            this.getDocument().beginTransaction();
            this.mEditElement.setText(this.mEditComponent.getText());
            this.remove(this.mEditComponent);
            this.mEditComponent = null;
            this.mEditElement = null;
            this.mEditRect = null;
            if (string.length() > 0) {
                this.getDocument().commit();
            } else {
                this.getDocument().commitPlus();
            }
            this.updateGobs();
            this.validate();
            this.repaint();
            this.setKeyMap(this.createDefaultKeyMap(ZApp.getTheApp()));
            this.requestFocus();
            return true;
        }
        return false;
    }

    protected class DocEditActionListener
    implements ActionListener {
        protected DocEditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DocPane.this.editEnd();
        }
    }
}

