/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.fob.xml;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.IFUndoElement;
import jp.co.iti.fagot.fob.xml.XDocument;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZString;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XElementNS
extends ElementNSImpl {
    protected boolean mLock = false;
    protected Vector mListener = new Vector();
    protected Hashtable mHash = new Hashtable();

    public XElementNS(DocumentImpl documentImpl, String string, String string2) throws DOMException {
        super((CoreDocumentImpl)documentImpl, string, string2);
    }

    public XElementNS() throws DOMException {
        super(null, null);
    }

    public void constructElement(DocumentImpl documentImpl, String string, String string2) {
        this.setDocument(documentImpl);
        this.namespaceURI = string;
        this.name = string2;
        this.flags = (short)(this.flags | 2);
    }

    public void setDocument(DocumentImpl documentImpl) {
        this.ownerNode = documentImpl;
        this.ownerDocument = documentImpl;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        FobManager fobManager = ((XDocument)((Object)this.getOwnerDocument())).getFobManager();
        fobManager.push(new XUndoInsertElement(this, node, node2));
        return this.insertBeforeNoUndo(node, node2);
    }

    public Node insertBeforeNoUndo(Node node, Node node2) throws DOMException {
        return super.insertBefore(node, node2);
    }

    public Node removeChild(Node node) throws DOMException {
        FobManager fobManager = ((XDocument)((Object)this.getOwnerDocument())).getFobManager();
        Node node2 = node.getNextSibling();
        fobManager.push(new XUndoRemoveElement(this, node, node2));
        return this.removeChildNoUndo(node);
    }

    public Node removeChildNoUndo(Node node) throws DOMException {
        Node node2 = super.removeChild(node);
        if (node instanceof XElementNS) {
            ((XElementNS)((Object)node)).firePropertyChanged("removed", null, null);
        }
        return node2;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        ZDebug.trace("replace:" + node2.toString());
        return super.removeChild(node2);
    }

    public void setAttribute(String string, String string2) {
        FobManager fobManager = ((XDocument)((Object)this.getOwnerDocument())).getFobManager();
        String string3 = this.getAttribute(string);
        if (!string3.equals(string2)) {
            fobManager.push(new XUndoSetAttribute(this, string, string2, string3));
            this.setAttributeNoUndo(string, string2);
        }
    }

    public void setAttributeNoUndo(String string, String string2) {
        String string3 = this.getAttribute(string);
        super.setAttribute(string, string2);
        this.firePropertyChanged(string, string3, string2);
    }

    public void removeAttribute(String string) {
        FobManager fobManager = ((XDocument)((Object)this.getOwnerDocument())).getFobManager();
        String string2 = this.getAttribute(string);
        if (string2.length() != 0) {
            fobManager.push(new XUndoSetAttribute(this, string, "", string2));
            this.removeAttributeNoUndo(string);
        }
    }

    public void removeAttributeNoUndo(String string) {
        String string2 = this.getAttribute(string);
        super.removeAttribute(string);
        this.firePropertyChanged(string, string2, "");
    }

    public void setBooleanAttr(String string, boolean bl) {
        this.setAttribute(string, bl ? "true" : "false");
    }

    public boolean getBooleanAttr(String string, boolean bl) {
        String string2 = this.getAttribute(string);
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        return bl;
    }

    public void setByteAttr(String string, byte by) {
        this.setAttribute(string, Byte.toString(by));
    }

    public byte getByteAttr(String string, byte by) {
        return ZString.parseByte(this.getAttribute(string), by);
    }

    public void setIntAttr(String string, int n) {
        this.setAttribute(string, Integer.toString(n));
    }

    public int getIntAttr(String string, int n) {
        return ZString.parseInt(this.getAttribute(string), n);
    }

    public void setDoubleAttr(String string, double d) {
        this.setAttribute(string, Double.toString(d));
    }

    public double getDoubleAttr(String string, double d) {
        return ZString.parseDouble(this.getAttribute(string), d);
    }

    public Color getColorAttr(String string) {
        return ZGraphicUtil.stringToColor(this.getAttribute(string));
    }

    public String getChildElementAttribute(String string, String string2, String string3) {
        XElementNS xElementNS = this.findChildElement(string, string2);
        if (xElementNS != null) {
            return xElementNS.getAttribute(string3);
        }
        return "";
    }

    protected XElementNS findElement(String string, String string2) {
        int n;
        String[] stringArray = ZString.tokenize(string);
        for (int i = 0; i < stringArray.length; ++i) {
            n = 0;
            if (stringArray[i].startsWith(".")) {
                stringArray[i] = stringArray[i].substring(1);
                n = 1;
            }
            if (stringArray[i].equals(this.getTagName()) && this.isMatch(string2)) {
                return this;
            }
            if (stringArray[i].startsWith(this.getTagName())) {
                stringArray[i] = stringArray[i].substring(this.getTagName().length());
                continue;
            }
            if (n == 0) continue;
            stringArray[i] = null;
        }
        String string3 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            string3 = string3 == null ? stringArray[n] : string3 + " " + stringArray[n];
        }
        if (string3 != null) {
            return this.findChildElement(string3, string2);
        }
        return null;
    }

    public XElementNS findChildElement(String string, String string2) {
        Object object;
        if (string2 == null && (object = (XElementNS)((Object)this.mHash.get(string))) != null) {
            return object;
        }
        object = this.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            XElementNS xElementNS;
            Node node = object.item(i);
            if (!(node instanceof XElementNS) || (xElementNS = ((XElementNS)((Object)node)).findElement(string, string2)) == null) continue;
            if (string2 == null) {
                this.mHash.put(string, xElementNS);
            }
            return xElementNS;
        }
        return null;
    }

    protected Vector findElements(String string) {
        int n;
        Vector<XElementNS> vector = new Vector<XElementNS>();
        String[] stringArray = ZString.tokenize(string);
        for (int i = 0; i < stringArray.length; ++i) {
            n = 0;
            if (stringArray[i].startsWith(".")) {
                stringArray[i] = stringArray[i].substring(1);
                n = 1;
            }
            if (stringArray[i].equals(this.getTagName())) {
                vector.add(this);
                continue;
            }
            if (stringArray[i].startsWith(this.getTagName())) {
                stringArray[i] = stringArray[i].substring(this.getTagName().length());
                continue;
            }
            if (n == 0) continue;
            stringArray[i] = null;
        }
        String string2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            string2 = string2 == null ? stringArray[n] : string2 + " " + stringArray[n];
        }
        if (string2 != null) {
            vector.addAll(this.findChildElements(string2));
        }
        return vector;
    }

    public Vector findChildElements(String string) {
        Vector vector = new Vector();
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof XElementNS)) continue;
            vector.addAll(((XElementNS)((Object)node)).findElements(string));
        }
        return vector;
    }

    protected boolean isMatch(String string) {
        String string2;
        if (string == null) {
            return true;
        }
        boolean bl = false;
        String[] stringArray = ZString.tokenfirst(string, "=");
        if (stringArray.length == 2 && (string2 = this.getAttribute(stringArray[0])) != null && string2.equalsIgnoreCase(stringArray[1])) {
            bl = true;
        }
        return bl;
    }

    public XElementNS getChildElement(String string, String string2) {
        XElementNS xElementNS = this.findChildElement(string, string2);
        if (xElementNS == null) {
            xElementNS = this.createChildElement(string);
            if (string2 == null) {
                this.mHash.put(string, xElementNS);
            } else {
                String[] stringArray = ZString.tokenfirst(string2, "=");
                xElementNS.setAttribute(stringArray[0], stringArray[1]);
            }
        }
        return xElementNS;
    }

    public XElementNS createChildElement(String string) {
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        String[] stringArray = ZString.tokenfirst(string, ".");
        XElementNS xElementNS = null;
        if (stringArray[1] != null) {
            xElementNS = this.findChildElement("." + stringArray[0], null);
            if (xElementNS == null) {
                xElementNS = (XElementNS)((Object)this.getOwnerDocument().createElementNS(null, stringArray[0]));
                this.appendChild((Node)((Object)xElementNS));
            }
            return xElementNS.createChildElement(stringArray[1]);
        }
        xElementNS = (XElementNS)((Object)this.getOwnerDocument().createElementNS(null, stringArray[0]));
        this.appendChild((Node)((Object)xElementNS));
        return xElementNS;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mListener.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mListener.remove(propertyChangeListener);
    }

    public void firePropertyChanged(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        this.firePropertyChanged(propertyChangeEvent);
    }

    public void firePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.mLock) {
            return;
        }
        this.mLock = true;
        Enumeration enumeration = this.mListener.elements();
        while (enumeration.hasMoreElements()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
        this.mLock = false;
    }

    public class XUndoSetAttribute
    extends XUndoElement {
        protected String mName = null;

        public XUndoSetAttribute(XElementNS xElementNS2, String string, String string2, String string3) {
            super(xElementNS2, string2, string3);
            this.mName = string;
        }

        public void undo() {
            String string = (String)this.mRef;
            if (string.length() == 0) {
                this.mOrg.removeAttributeNoUndo(this.mName);
            } else {
                this.mOrg.setAttributeNoUndo(this.mName, string);
            }
        }

        public void redo() {
            String string = (String)this.mObj;
            if (string.length() == 0) {
                this.mOrg.removeAttributeNoUndo(this.mName);
            } else {
                this.mOrg.setAttributeNoUndo(this.mName, string);
            }
        }
    }

    public class XUndoRemoveElement
    extends XUndoElement {
        public XUndoRemoveElement(XElementNS xElementNS2, Node node, Node node2) {
            super(xElementNS2, node, node2);
        }

        public void undo() {
            this.mOrg.insertBeforeNoUndo((Node)this.mObj, (Node)this.mRef);
        }

        public void redo() {
            this.mOrg.removeChildNoUndo((Node)this.mObj);
        }
    }

    public class XUndoInsertElement
    extends XUndoElement {
        public XUndoInsertElement(XElementNS xElementNS2, Node node, Node node2) {
            super(xElementNS2, node, node2);
        }

        public void undo() {
            this.mOrg.removeChildNoUndo((Node)this.mObj);
        }

        public void redo() {
            this.mOrg.insertBeforeNoUndo((Node)this.mObj, (Node)this.mRef);
        }
    }

    public class XUndoElement
    implements IFUndoElement {
        protected XElementNS mOrg = null;
        protected Object mObj = null;
        protected Object mRef = null;

        public XUndoElement(XElementNS xElementNS2, Object object, Object object2) {
            this.mOrg = xElementNS2;
            this.mObj = object;
            this.mRef = object2;
        }

        public void undo() {
        }

        public void redo() {
        }

        public void getFobs(Vector vector) {
            vector.add(this.mOrg);
            vector.add(this.mObj);
        }
    }
}

