/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.gob;

import java.awt.geom.AffineTransform;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.fob.FInteger;
import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GPath;
import jp.co.iti.fagot.gob.GSelector;

public class GRectangle
extends GPath {
    protected ZRectangle mRect = new ZRectangle();
    protected ZDimension mMinSize = new ZDimension();
    protected FInteger mPaintOption = new FInteger();
    protected FInteger mEditOption = new FInteger();
    public static final int NORESIZE = 1;

    public GRectangle() {
        this.mMinSize.setSize(10.0, 10.0);
    }

    public ZRectangle getBounds() {
        return new ZRectangle(this.mRect);
    }

    public byte getHitModeGob(ZPoint zPoint) {
        GSelector gSelector = new GSelector();
        AffineTransform affineTransform = this.getTransform().getTransform();
        gSelector = gSelector.createScaledSelector(1.0 / affineTransform.getScaleX(), 1.0 / affineTransform.getScaleY());
        if (this.isSelect() && (this.getEditOption() & 1) == 0) {
            for (byte by = 2; by <= 9; by = (byte)(by + 1)) {
                if (!gSelector.isHit(this.getSelectorPoint(by), zPoint)) continue;
                return by;
            }
        }
        if (this.getBounds().contains(zPoint)) {
            return 1;
        }
        return 0;
    }

    public ZPoint getConnectPointGob(byte by) {
        ZPoint zPoint = this.getSelectorPoint(by);
        return this.getTransform().transform(zPoint);
    }

    public ZPath getMovingPathGob(DocGridControler docGridControler) {
        return new ZPath(this.getMovingRectGob(docGridControler));
    }

    public ZRectangle getMovingRectGob(DocGridControler docGridControler) {
        ZRectangle zRectangle = this.getBounds();
        ZPoint zPoint = docGridControler.getMoveGridZone();
        switch (docGridControler.getMoveMode()) {
            case 1: 
            case 14: {
                zRectangle.translate(docGridControler.getOffsetGrid());
                break;
            }
            case 2: {
                ZPoint zPoint2 = this.getSelectorPoint(this.getContrastPoint(docGridControler.getMoveMode()));
                ZPoint zPoint3 = new ZPoint(zPoint2.getX(), Math.min(zPoint.getY(), zPoint2.getY() - this.mMinSize.getHeight()));
                ZPoint zPoint4 = new ZPoint(Math.max(zPoint.getX(), zPoint2.getX() + this.mMinSize.getWidth()), zPoint2.getY());
                zRectangle = new ZRectangle(zPoint3, zPoint4);
                break;
            }
            case 3: {
                ZPoint zPoint5 = this.getSelectorPoint(this.getContrastPoint(docGridControler.getMoveMode()));
                ZPoint zPoint6 = new ZPoint(Math.min(zPoint.getX(), zPoint5.getX() - this.mMinSize.getWidth()), Math.min(zPoint.getY(), zPoint5.getY() - this.mMinSize.getHeight()));
                ZPoint zPoint7 = zPoint5;
                zRectangle = new ZRectangle(zPoint6, zPoint7);
                break;
            }
            case 4: {
                ZPoint zPoint8;
                ZPoint zPoint9 = zPoint8 = this.getSelectorPoint(this.getContrastPoint(docGridControler.getMoveMode()));
                ZPoint zPoint10 = new ZPoint(Math.max(zPoint.getX(), zPoint8.getX() + this.mMinSize.getWidth()), Math.max(zPoint.getY(), zPoint8.getY() + this.mMinSize.getHeight()));
                zRectangle = new ZRectangle(zPoint9, zPoint10);
                break;
            }
            case 5: {
                ZPoint zPoint11 = this.getSelectorPoint(this.getContrastPoint(docGridControler.getMoveMode()));
                ZPoint zPoint12 = new ZPoint(Math.min(zPoint.getX(), zPoint11.getX() - this.mMinSize.getWidth()), zPoint11.getY());
                ZPoint zPoint13 = new ZPoint(zPoint11.getX(), Math.max(zPoint.getY(), zPoint11.getY() + this.mMinSize.getHeight()));
                zRectangle = new ZRectangle(zPoint12, zPoint13);
                break;
            }
            case 8: {
                ZPoint zPoint14 = new ZPoint(zRectangle.getX(), zRectangle.getY());
                ZPoint zPoint15 = new ZPoint(Math.max(zPoint.getX(), zRectangle.getX() + this.mMinSize.getWidth()), zRectangle.getY() + zRectangle.getHeight());
                zRectangle = new ZRectangle(zPoint14, zPoint15);
                break;
            }
            case 9: {
                ZPoint zPoint16 = new ZPoint(Math.min(zPoint.getX(), zRectangle.getX() + zRectangle.getWidth() - this.mMinSize.getWidth()), zRectangle.getY());
                ZPoint zPoint17 = new ZPoint(zRectangle.getX() + zRectangle.getWidth(), zRectangle.getY() + zRectangle.getHeight());
                zRectangle = new ZRectangle(zPoint16, zPoint17);
                break;
            }
            case 6: {
                ZPoint zPoint18 = new ZPoint(zRectangle.getX(), Math.min(zPoint.getY(), zRectangle.getY() + zRectangle.getHeight() - this.mMinSize.getHeight()));
                ZPoint zPoint19 = new ZPoint(zRectangle.getX() + zRectangle.getWidth(), zRectangle.getY() + zRectangle.getHeight());
                zRectangle = new ZRectangle(zPoint18, zPoint19);
                break;
            }
            case 7: {
                ZPoint zPoint20 = new ZPoint(zRectangle.getX(), zRectangle.getY());
                ZPoint zPoint21 = new ZPoint(zRectangle.getX() + zRectangle.getWidth(), Math.max(zPoint.getY(), zRectangle.getY() + this.mMinSize.getHeight()));
                zRectangle = new ZRectangle(zPoint20, zPoint21);
            }
        }
        if (zRectangle.getWidth() < 10.0) {
            zRectangle.setWidth(10.0);
        }
        if (zRectangle.getHeight() < 10.0) {
            zRectangle.setHeight(10.0);
        }
        return zRectangle;
    }

    public void groupIn(double d, double d2) {
        ZRectangle zRectangle = this.getBounds();
        zRectangle.translate(d, d2);
        this.setRect(zRectangle);
    }

    public void groupOut(double d, double d2, double d3, double d4) {
        ZRectangle zRectangle = this.getBounds();
        zRectangle.setRect(zRectangle.getX() * d3, zRectangle.getY() * d4, zRectangle.getWidth() * d3, zRectangle.getHeight() * d4);
        zRectangle.translate(d, d2);
        this.setRect(zRectangle);
    }

    public ZPoint getSelectorPoint(byte by) {
        ZRectangle zRectangle = this.getBounds();
        ZPoint zPoint = new ZPoint();
        switch (by) {
            case 2: 
            case 4: 
            case 8: {
                zPoint.setX(zRectangle.getX() + zRectangle.getWidth());
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                zPoint.setX(zRectangle.getX());
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                zPoint.setX(zRectangle.getX() + zRectangle.getWidth() / 2.0);
            }
        }
        switch (by) {
            case 2: 
            case 3: 
            case 6: {
                zPoint.setY(zRectangle.getY());
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                zPoint.setY(zRectangle.getY() + zRectangle.getHeight());
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                zPoint.setY(zRectangle.getY() + zRectangle.getHeight() / 2.0);
            }
        }
        return zPoint;
    }

    public byte getContrastPoint(byte by) {
        byte by2 = 0;
        switch (by) {
            case 2: {
                by2 = 5;
                break;
            }
            case 3: {
                by2 = 4;
                break;
            }
            case 4: {
                by2 = 3;
                break;
            }
            case 5: {
                by2 = 2;
                break;
            }
            case 8: {
                by2 = 9;
                break;
            }
            case 9: {
                by2 = 8;
                break;
            }
            case 6: {
                by2 = 7;
                break;
            }
            case 7: {
                by2 = 6;
            }
        }
        return by2;
    }

    public void paintSelector(DocGraphics docGraphics) {
        docGraphics.getGridControler().pushTransform(this.getTransform());
        GSelector gSelector = new GSelector();
        int n = 9;
        if ((this.getEditOption() & 1) == 1) {
            n = 5;
        }
        for (byte by = 2; by <= n; by = (byte)(by + 1)) {
            ZPoint zPoint = this.getSelectorPoint(by);
            ZPoint zPoint2 = docGraphics.getGridControler().transform(zPoint);
            gSelector.paint(docGraphics.getGraphics(), zPoint2);
        }
        docGraphics.getGridControler().popTransform();
    }

    public void setRect(ZRectangle zRectangle) {
        this.mRect.setRect(zRectangle);
        this.setPath();
    }

    public void setPath() {
        this.setPath(new ZPath(this.getRect()));
    }

    public ZRectangle getRect() {
        return new ZRectangle(this.mRect);
    }

    public void setMinSize(ZDimension zDimension) {
        this.mMinSize.setSize(zDimension);
    }

    public ZDimension getMinSize() {
        return new ZDimension(this.mMinSize);
    }

    public void setPaintOption(int n) {
        this.mPaintOption.set(n);
    }

    public int getPaintOption() {
        return this.mPaintOption.get();
    }

    public void setEditOption(int n) {
        this.mEditOption.set(n);
    }

    public int getEditOption() {
        return this.mEditOption.get();
    }

    public void setFobManager(FobManager fobManager) {
        super.setFobManager(fobManager);
        this.mPaintOption.setFobManager(fobManager, this);
        this.mEditOption.setFobManager(fobManager, this);
    }

    public Object createClone() {
        return new GRectangle();
    }

    public void copyAttribute(Object object) {
        super.copyAttribute(object);
        ((GRectangle)object).setRect(this.getRect());
        ((GRectangle)object).setMinSize(this.getMinSize());
        ((GRectangle)object).setPaintOption(this.getPaintOption());
        ((GRectangle)object).setEditOption(this.getEditOption());
    }
}

