/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.gob;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.util.ZDebug;

public class PTransform {
    protected double m00 = 1.0;
    protected double m10;
    protected double m01;
    protected double m11 = 1.0;
    protected double m02;
    protected double m12;

    public PTransform() {
    }

    public PTransform(AffineTransform affineTransform) {
        this();
        this.setTransform(affineTransform);
    }

    public PTransform(PTransform pTransform) {
        this();
        this.set(pTransform);
    }

    public PTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this();
        this.setTransform(d, d2, d3, d4, d5, d6);
    }

    public PTransform(double d) {
        this();
        this.setTransform(d, 0.0, 0.0, d, 0.0, 0.0);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
    }

    public AffineTransform getScaleTransform() {
        return new AffineTransform(this.m00, 0.0, 0.0, this.m11, 0.0, 0.0);
    }

    public void set(PTransform pTransform) {
        this.setTransform(pTransform.getTransform());
    }

    public void setTransform(AffineTransform affineTransform) {
        this.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
    }

    public void add(PTransform pTransform) {
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = pTransform.getTransform();
        affineTransform2.concatenate(affineTransform);
        this.setTransform(affineTransform2);
    }

    public ZPoint transform(ZPoint zPoint) {
        ZPoint zPoint2 = new ZPoint(zPoint);
        AffineTransform affineTransform = this.getTransform();
        Point2D point2D = affineTransform.transform(zPoint2, null);
        zPoint2.setLocation(point2D.getX(), point2D.getY());
        return zPoint2;
    }

    public Shape transform(Shape shape) {
        AffineTransform affineTransform = this.getTransform();
        return affineTransform.createTransformedShape(shape);
    }

    public ZPoint inverseTransform(ZPoint zPoint) {
        ZPoint zPoint2 = new ZPoint(zPoint);
        AffineTransform affineTransform = this.getTransform();
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            Point2D point2D = affineTransform2.transform(zPoint2, null);
            zPoint2.setLocation(point2D.getX(), point2D.getY());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            ZDebug.err("at.createInverse failed:" + affineTransform.toString());
            noninvertibleTransformException.printStackTrace();
        }
        return zPoint2;
    }

    public Shape inverseTransform(Shape shape) {
        AffineTransform affineTransform = this.getTransform();
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            return affineTransform2.createTransformedShape(shape);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            ZDebug.err("at.createInverse failed:" + affineTransform.toString());
            return null;
        }
    }

    public Object clone() {
        PTransform pTransform = new PTransform();
        pTransform.set(this);
        return pTransform;
    }

    public String toString() {
        return "PTransform:" + this.m00 + " " + this.m10 + " " + this.m01 + " " + this.m11 + " " + this.m02 + " " + this.m12;
    }
}

