/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.PTransform;
import jp.co.iti.fagot.util.ZDebug;

public class ZGraphicUtil {
    public static boolean isNearLine(ZPoint zPoint, ZPoint zPoint2, ZPoint zPoint3, double d) {
        ZRectangle zRectangle = new ZRectangle(Math.min(zPoint.getX(), zPoint2.getX()) - d, Math.min(zPoint.getY(), zPoint2.getY()) - d, Math.abs(zPoint.getX() - zPoint2.getX()) + d * 2.0, Math.abs(zPoint.getY() - zPoint2.getY()) + d * 2.0);
        if (!zRectangle.contains(zPoint3)) {
            return false;
        }
        double d2 = ZGraphicUtil.getDistance(zPoint, zPoint2, zPoint3);
        return d2 < d;
    }

    public static double getDistance(ZPoint zPoint, ZPoint zPoint2, ZPoint zPoint3) {
        ZPoint zPoint4 = zPoint3.minus(zPoint);
        ZPoint zPoint5 = zPoint2.minus(zPoint);
        double d = zPoint4.getX() * zPoint5.getX() + zPoint4.getY() * zPoint5.getY();
        double d2 = zPoint5.getX() * zPoint5.getX() + zPoint5.getY() * zPoint5.getY();
        double d3 = d / d2;
        ZPoint zPoint6 = new ZPoint(zPoint.getX() + zPoint5.getX() * d3, zPoint.getY() + zPoint5.getY() * d3);
        double d4 = (zPoint3.getX() - zPoint6.getX()) * (zPoint3.getX() - zPoint6.getX()) + (zPoint3.getY() - zPoint6.getY()) * (zPoint3.getY() - zPoint6.getY());
        return Math.sqrt(d4);
    }

    public static double getDistance(ZPoint zPoint, ZPoint zPoint2) {
        double d = zPoint.getX() - zPoint2.getX();
        double d2 = zPoint.getY() - zPoint2.getY();
        return Math.sqrt(d * d + d2 * d2);
    }

    public static Shape createArrowShape(ZPoint zPoint, ZPoint zPoint2, double d, double d2) {
        ZPath zPath = new ZPath();
        zPath.moveTo(0.0, 0.0);
        zPath.lineTo(d, d2);
        zPath.lineTo(d, -d2);
        zPath.closePath();
        ZPoint zPoint3 = zPoint.minus(zPoint2);
        double d3 = ZGraphicUtil.getDistance(zPoint, zPoint2);
        ZPoint zPoint4 = new ZPoint(zPoint3.getX() / d3, zPoint3.getY() / d3);
        AffineTransform affineTransform = new AffineTransform(zPoint4.getX(), zPoint4.getY(), -zPoint4.getY(), zPoint4.getX(), zPoint2.getX(), zPoint2.getY());
        Shape shape = affineTransform.createTransformedShape(zPath);
        return shape;
    }

    public static PTransform getNormalizeTransform(ZRectangle zRectangle, ZRectangle zRectangle2) {
        double d;
        double d2 = zRectangle.getWidth() / zRectangle2.getWidth();
        double d3 = Math.min(d2, d = zRectangle.getHeight() / zRectangle2.getHeight());
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        ZPoint zPoint = zRectangle.getCenter();
        ZPoint zPoint2 = zRectangle2.getCenter();
        double d4 = zPoint.getX() - zPoint2.getX() * d3;
        double d5 = zPoint.getY() - zPoint2.getY() * d3;
        return new PTransform(d3, 0.0, 0.0, d3, d4, d5);
    }

    public static Color harfColor(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }

    public static boolean isValidColor(String string) {
        Color color = ZGraphicUtil.stringToColor(string);
        return color != null;
    }

    public static Color stringToColor(String string) {
        Color color = null;
        if (string != null && string.startsWith("#") && (string.length() == 7 || string.length() == 4)) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            try {
                string = string.substring(1);
                int n5 = string.length() / 3;
                n = Integer.parseInt(string.substring(0, n5), 16);
                string = string.substring(n5);
                n2 = Integer.parseInt(string.substring(0, n5), 16);
                string = string.substring(n5);
                n3 = Integer.parseInt(string.substring(0, n5), 16);
                if (n5 == 1) {
                    n4 = 16;
                }
                color = new Color(n * n4, n2 * n4, n3 * n4);
            }
            catch (NumberFormatException numberFormatException) {
                ZDebug.trace("stringToColor:parse error");
            }
        }
        return color;
    }

    public static boolean isBlackFamily(String string) {
        return ZGraphicUtil.isBlackFamily(ZGraphicUtil.stringToColor(string));
    }

    public static boolean isBlackFamily(Color color) {
        int n = 765;
        if (color != null) {
            n = color.getRed() + color.getGreen() + color.getBlue();
        }
        return n < 384;
    }

    public static Color inverseColor(Color color) {
        if (color != null) {
            return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        }
        return null;
    }

    public static String colorToString(Color color) {
        String string = null;
        if (color != null) {
            string = "#";
            String string2 = Integer.toHexString(color.getRed());
            string = string2.length() == 1 ? string + "0" + string2.toUpperCase() : string + string2.toUpperCase();
            String string3 = Integer.toHexString(color.getGreen());
            string = string3.length() == 1 ? string + "0" + string3.toUpperCase() : string + string3.toUpperCase();
            String string4 = Integer.toHexString(color.getBlue());
            string = string4.length() == 1 ? string + "0" + string4.toUpperCase() : string + string4.toUpperCase();
        }
        return string;
    }

    public static String stringToSystemColor(String string) {
        return string;
    }

    public static LineBreakMeasurer createLineBreakMeasurer(String string, Font font, Color color, Color color2, AffineTransform affineTransform) {
        int n = string.length();
        AttributedString attributedString = new AttributedString(string);
        if (font != null) {
            attributedString.addAttribute(TextAttribute.FONT, font, 0, n);
        }
        if (color != null) {
            attributedString.addAttribute(TextAttribute.BACKGROUND, color, 0, n);
        }
        if (color2 != null) {
            attributedString.addAttribute(TextAttribute.FOREGROUND, color2, 0, n);
        } else {
            attributedString.addAttribute(TextAttribute.FOREGROUND, Color.black, 0, n);
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, false, false);
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
        return lineBreakMeasurer;
    }

    public static LineBreakMeasurer createLineBreakMeasurer(String string, String string2, Float f, Color color, Color color2, FontRenderContext fontRenderContext) {
        AttributedString attributedString = new AttributedString(string);
        if (string2 != null) {
            attributedString.addAttribute(TextAttribute.FAMILY, string2);
        }
        if (f != null) {
            attributedString.addAttribute(TextAttribute.SIZE, f);
        }
        if (color != null) {
            attributedString.addAttribute(TextAttribute.BACKGROUND, color);
        }
        if (color2 != null) {
            attributedString.addAttribute(TextAttribute.FOREGROUND, color2);
        } else {
            attributedString.addAttribute(TextAttribute.FOREGROUND, Color.black);
        }
        return new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
    }

    public static ZDimension getTextPreferredSize(LineBreakMeasurer lineBreakMeasurer, AffineTransform affineTransform, int n, double d) {
        boolean bl = false;
        if (d == 0.0) {
            bl = true;
            d = 10000.0;
        }
        int n2 = lineBreakMeasurer.getPosition();
        float f = 0.0f;
        float f2 = 0.0f;
        while (lineBreakMeasurer.getPosition() < n) {
            TextLayout textLayout = lineBreakMeasurer.nextLayout((float)d);
            float f3 = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
            if (affineTransform == null) {
                f2 += f3;
            } else {
                ZPoint zPoint = new ZPoint(0.0, f3);
                Point2D point2D = affineTransform.transform(zPoint, null);
                f2 = (float)((double)f2 + point2D.getY());
            }
            if (f < textLayout.getVisibleAdvance()) {
                f = textLayout.getVisibleAdvance();
            }
            if (!bl) continue;
        }
        lineBreakMeasurer.setPosition(n2);
        return new ZDimension(f, f2);
    }
}

