/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZString;

public class ZResource {
    private Class mAppClass;
    private ResourceBundle mRes;
    private ResourceBundle mPriRes;
    private Properties mProp;
    protected static ZResource mResource = null;

    public ZResource(Class clazz) {
        this(clazz, null);
    }

    public ZResource(Class clazz, Locale locale) {
        this.mAppClass = clazz;
        String string = "";
        String string2 = this.mAppClass.getName();
        String[] stringArray = ZString.tokenize(string2, ".");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + stringArray[i] + ".";
        }
        String string3 = string + "resources." + stringArray[stringArray.length - 1];
        try {
            this.mRes = ResourceBundle.getBundle(string3);
        }
        catch (MissingResourceException missingResourceException) {
            ZDebug.err(string3 + ".properties not found:" + missingResourceException.toString());
            this.mRes = null;
        }
        try {
            this.mPriRes = ResourceBundle.getBundle(string3, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            ZDebug.err(string3 + ".properties not found:" + missingResourceException.toString());
            this.mPriRes = null;
        }
        this.mProp = new Properties();
        this.loadProperty(this.getPropertyFile());
        mResource = this;
    }

    public ZResource(Properties properties) {
        this.mProp = properties;
    }

    public void loadProperty(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.mProp.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("User Properties load failed: " + iOException);
        }
    }

    public void saveProperty() {
        String string = this.getPropertyFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.mProp.store(fileOutputStream, this.mAppClass.getName() + " Properties.");
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            ZDebug.err("User Properties save failed: " + iOException);
        }
    }

    public static ZResource res() {
        return mResource;
    }

    public void loadGeometry(Window window, String string) {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = Integer.parseInt(this.getString("win." + string + ".width"));
            n3 = Integer.parseInt(this.getString("win." + string + ".height"));
        }
        catch (NumberFormatException numberFormatException) {
            n4 = 400;
            n3 = 300;
        }
        try {
            n2 = Integer.parseInt(this.getString("win." + string + ".x"));
            n = Integer.parseInt(this.getString("win." + string + ".y"));
        }
        catch (NumberFormatException numberFormatException) {
            Dimension dimension = window.getToolkit().getScreenSize();
            n2 = (dimension.width - n4) / 2;
            n = (dimension.height - n3) / 2;
        }
        window.setLocation(n2, n);
        window.setSize(n4, n3);
    }

    public void saveGeometry(Window window, String string) {
        Point point = window.getLocation();
        Dimension dimension = window.getSize();
        this.mProp.put("win." + string + ".x", String.valueOf(point.x));
        this.mProp.put("win." + string + ".y", String.valueOf(point.y));
        this.mProp.put("win." + string + ".width", String.valueOf(dimension.width));
        this.mProp.put("win." + string + ".height", String.valueOf(dimension.height));
    }

    public String getString(String string) {
        String string2 = this.mProp.getProperty(string);
        if (string2 == null && this.mPriRes != null) {
            try {
                string2 = this.mPriRes.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
        }
        if (string2 == null && this.mRes != null) {
            try {
                string2 = this.mRes.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
        }
        if (string2 != null && string.startsWith("rid.") && string.endsWith(".dir")) {
            string2 = ZString.replace(string2, "/", File.separator);
        }
        return string2;
    }

    public Vector getStrings(String string) {
        String string2;
        String string3;
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i < 100 && (string3 = this.getString(string2 = string + i)) != null; ++i) {
            vector.add(string3);
        }
        return vector;
    }

    public int getInt(String string, int n) {
        int n2;
        String string2 = this.getString(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    public Color getColor(String string) {
        String string2 = this.getString(string);
        return ZGraphicUtil.stringToColor(string2);
    }

    public URL getURL(String string) {
        String string2 = this.getString(string);
        if (string2 != null) {
            URL uRL = this.mAppClass.getResource(string2);
            return uRL;
        }
        return null;
    }

    public boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.getString(string);
        if (string2 != null) {
            if (string2.toLowerCase().equals("true")) {
                bl2 = true;
            } else if (string2.toLowerCase().equals("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public void putString(String string, String string2) {
        if (string2 == null) {
            this.mProp.remove(string);
        } else {
            this.mProp.put(string, string2);
        }
    }

    public void putStrings(String string, Vector vector) {
        String string2;
        Enumeration enumeration = vector.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            string2 = string + n;
            String string3 = (String)enumeration.nextElement();
            this.putString(string2, string3);
            ++n;
        }
        string2 = string + n;
        this.putString(string2, null);
    }

    public void putInt(String string, int n) {
        this.mProp.put(string, String.valueOf(n));
    }

    private String getPropertyFile() {
        String string = System.getProperty("user.home");
        String[] stringArray = ZString.tokenize(this.mAppClass.getName(), ".");
        String string2 = string + File.separator + stringArray[stringArray.length - 1] + ".properties";
        return string2;
    }

    public void putBoolean(String string, boolean bl) {
        this.mProp.put(string, bl ? "True" : "False");
    }
}

