/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri;

import java.io.File;
import java.util.Vector;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.xml.GRootSVG;
import jp.co.nri.Ridual;
import jp.co.nri.RidualLog;
import jp.co.nri.rid.action.RidToolAction;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.generator.GenerateCSV2;
import jp.co.nri.rid.table.RTable;
import org.w3c.dom.Document;

public class RidualScript {
    protected Ridual mApp = (Ridual)ZApp.getTheApp();
    protected ZResource mRes = this.mApp.getResource();
    protected Throwable mThrowable = null;
    protected RidualLog mLog = null;

    public boolean start(String string) {
        String string2 = ZString.getDateTime();
        String[] stringArray = ZString.tokenize(ZString.replace(string2, " ", "_"), "/:");
        String string3 = ZFile.getParent(string) + File.separator + "log" + File.separator;
        String string4 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string4 = string4 + stringArray[i];
        }
        string4 = string4 + ".log";
        ZDebug.trace(string3 + string4);
        ZDebug.setTraceFile(string3 + string4);
        ZDebug.trace("rid-x dir:" + this.mRes.getString("app.install.path"));
        RidualScript ridualScript = this;
        ZDebug.trace("version  :" + ridualScript.mApp.getVersionInfo());
        this.mLog = new RidualLog(string, string4, string2);
        return true;
    }

    public void end(boolean bl) {
        if (this.mLog != null) {
            this.mLog.end(bl);
        }
    }

    public boolean open(String string) {
        boolean bl = true;
        if (this.mLog != null) {
            String string2 = this.mRes.getString("app.install.path") + File.separator + this.mRes.getString("app.project.dir") + File.separator;
            String string3 = string.substring(string2.length());
            bl = this.mLog.start(string3);
        }
        if (bl) {
            bl = this.mApp.open(string);
        }
        return bl;
    }

    public boolean save() {
        boolean bl = false;
        if (this.mLog != null && this.mLog.check()) {
            bl = this.mApp.save();
        }
        return bl;
    }

    public boolean execImport() {
        RidToolAction ridToolAction = new RidToolAction(this.mApp, "import");
        return this.execToolAction(ridToolAction);
    }

    public boolean execAnalyze() {
        RidToolAction ridToolAction = new RidToolAction(this.mApp, "analyze_html");
        return this.execToolAction(ridToolAction);
    }

    public boolean execGenerate() {
        RidToolAction ridToolAction = new RidToolAction(this.mApp, "generate");
        return this.execToolAction(ridToolAction);
    }

    public boolean execAccessLog() {
        RidToolAction ridToolAction = new RidToolAction(this.mApp, "accesslog");
        return this.execToolAction(ridToolAction);
    }

    protected boolean execToolAction(RidToolAction ridToolAction) {
        ZDebug.trace("--- " + ridToolAction.getActionName() + " start");
        this.mThrowable = ridToolAction.execTool();
        if (this.mThrowable != null) {
            ZDebug.trace("Error:" + this.mThrowable);
        }
        ZDebug.trace("--- " + ridToolAction.getActionName() + " end");
        return this.mThrowable == null;
    }

    public boolean outputZoneSvg(String string) {
        return this.outputSvg("Zone", string);
    }

    public boolean outputMapSvg(String string, boolean bl, String string2) {
        String string3 = "Map." + string;
        if (bl) {
            RidDocumentSite ridDocumentSite = (RidDocumentSite)ZInstance.map().get("document.site");
            boolean bl2 = true;
            if (string.endsWith("Circle")) {
                bl2 = false;
            }
            ridDocumentSite.recalcMap(string3, bl2);
        }
        return this.outputSvg(string3, string2);
    }

    protected boolean outputSvg(String string, String string2) {
        boolean bl = true;
        RidDocumentSite ridDocumentSite = (RidDocumentSite)ZInstance.map().get("document.site");
        Vector vector = ridDocumentSite.createGobs(string);
        try {
            ZDebug.trace("--- OutputSvg:" + string + " -> " + string2);
            GRootSVG gRootSVG = new GRootSVG(vector);
            gRootSVG.writeto(string2, null);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean outputCsv(String string, String string2) {
        boolean bl = true;
        String string3 = null;
        DocDocument docDocument = null;
        if (string.equals("List")) {
            string3 = "table.pages";
            docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
        } else if (string.equals("Resource")) {
            string3 = "table.resources";
            docDocument = (DocDocument)((Object)ZInstance.map().get("document.resource"));
        } else if (string.equals("Document")) {
            string3 = "table.documents";
            docDocument = (DocDocument)((Object)ZInstance.map().get("document.document"));
        } else if (string.equals("PageResource")) {
            string3 = "table.linkedpages";
            docDocument = (DocDocument)((Object)ZInstance.map().get("document.resource"));
        } else {
            ZDebug.trace("unknown panelId:" + string);
            return false;
        }
        RTable rTable = new RTable(string3);
        rTable.reload((Document)((Object)docDocument));
        try {
            ZDebug.trace("--- OutputCsv:" + string + " -> " + string2);
            GenerateCSV2 generateCSV2 = new GenerateCSV2();
            generateCSV2.generateCSV(rTable, string2);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void setProperty(String string, boolean bl) {
        this.mRes.putBoolean(string, bl);
    }

    public void setProperty(String string, String string2) {
        this.mRes.putString(string, string2);
    }
}

