/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocUIAdapter;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.xml.XElementNS;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GOperationSelect;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.gob.PTransform;
import jp.co.iti.fagot.util.ZInstance;

public class RPanPanel
extends JPanel {
    protected RPanDrawPanel mPanel = new RPanDrawPanel();

    public RPanPanel() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.mPanel);
    }

    public void restract() {
        this.mPanel.updateGobs();
        this.repaint(2000L);
    }

    public class GViewportZoom
    extends GOperationSelect {
        public void moveEndGob(DocGridControler docGridControler) {
            double d;
            ZRectangle zRectangle = this.getMovingRectGob(docGridControler);
            String string = ZInstance.prop().getProperty("panel.active");
            DocPane docPane = (DocPane)ZInstance.map().get(string);
            JViewport jViewport = (JViewport)docPane.getParent();
            Dimension dimension = jViewport.getSize();
            double d2 = (double)dimension.width / Math.max(1.0, zRectangle.getWidth());
            double d3 = Math.min(d2, d = (double)dimension.height / Math.max(1.0, zRectangle.getHeight()));
            if (d3 > 4.0) {
                d3 = 4.0;
            } else if (d3 < 0.1) {
                d3 = 0.1;
            }
            ZPoint zPoint = zRectangle.getCenter();
            DocElement docElement = (DocElement)((Object)docPane.getDocument().getRootElement(docPane.getPanelId()));
            docElement.setDisplayScale(docPane.getPanelId(), d3);
            jViewport.doLayout();
            docPane.setCenter(zPoint);
            docPane.updateGobs();
            docPane.repaint();
        }
    }

    public class GViewport
    extends GRectangle {
        public GViewport() {
            this.getStyle().setStrokeColor(new FColor(Color.blue));
            this.mSelect = true;
        }

        public boolean setSelect(boolean bl) {
            return false;
        }

        public void moveEndGob(DocGridControler docGridControler) {
            ZRectangle zRectangle = this.getMovingRectGob(docGridControler);
            ZPoint zPoint = zRectangle.getCenter();
            String string = ZInstance.prop().getProperty("panel.active");
            DocPane docPane = (DocPane)ZInstance.map().get(string);
            docPane.setCenter(zPoint);
            docPane.repaint();
        }

        public byte getHitModeGob(ZPoint zPoint) {
            byte by = super.getHitModeGob(zPoint);
            if (by != 0) {
                by = 14;
            }
            return (byte)by;
        }

        public void paintSelector(DocGraphics docGraphics) {
        }
    }

    public class RPanMouseAdapter
    extends DocUIAdapter {
        public RPanMouseAdapter(DocPane docPane) {
            super(docPane);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mEditor.getGridControler().setMoving(new ZPoint(mouseEvent.getPoint()), 0);
            this.mEditor.repaint();
        }

        public GElement createOperation(MouseEvent mouseEvent) {
            return null;
        }

        protected void OnLButtonDown(MouseEvent mouseEvent) {
            this.mStartPoint = new ZPoint(mouseEvent.getPoint());
            this.mMoveMode = GobManager.getSelectedHitMode(this.mEditor, this.mStartPoint);
            if (this.mMoveMode != 14) {
                GobManager.setCurrent(this.mEditor.getPanelId(), new GViewportZoom());
            } else {
                GobManager.updateCurrent(this.mEditor.getPanelId());
            }
            this.mEditor.getGridControler().setMoveStart(this.mStartPoint, this.mMoveMode);
            GobManager.moveStart(this.mEditor, this.mEditor.getGridControler());
            this.mEditor.getGridControler().setMoving(this.mStartPoint, 0);
            this.mEditor.setCursor(GOperation.getCursor(this.mMoveMode));
            this.mEditor.repaint();
        }

        protected void OnLButtonUp(MouseEvent mouseEvent) {
            super.OnLButtonUp(mouseEvent);
        }

        protected void OnRButtonDown(MouseEvent mouseEvent) {
        }
    }

    public class RPanDrawPanel
    extends DocPane {
        protected GRectangle mViewPort = null;

        public RPanDrawPanel() {
            super("pan");
        }

        public void createGobs() {
            Vector vector = GobManager.getElement(this.getPanelId());
            vector.removeAllElements();
            String string = ZInstance.prop().getProperty("panel.active");
            JComponent jComponent = (JComponent)ZInstance.map().get(string);
            if (!(jComponent instanceof DocPane)) {
                return;
            }
            DocPane docPane = (DocPane)jComponent;
            if (docPane != null) {
                GRectangle gRectangle = new GRectangle();
                Dimension dimension = docPane.getDocument().getLogicalSize();
                gRectangle.setRect(new ZRectangle(0.0, 0.0, dimension.width, dimension.height));
                gRectangle.getStyle().setFillColor(new FColor(docPane.getBackground()));
                gRectangle.getStyle().setStrokeColor(new FColor(Color.black));
                vector.add(gRectangle);
                vector.addAll(docPane.getDocument().createSkeltonGobs(docPane.getPanelId()));
                this.mViewPort = new GViewport();
                JViewport jViewport = (JViewport)docPane.getParent();
                Dimension dimension2 = jViewport.getSize();
                Point point = jViewport.getViewPosition();
                ZRectangle zRectangle = new ZRectangle(point.getX(), point.getY(), dimension2.width, dimension2.height);
                PTransform pTransform = null;
                DocElement docElement = (DocElement)((Object)docPane.getDocument().getRootElement(docPane.getPanelId()));
                pTransform = docElement != null ? docElement.getDisplayScaledTransform(docPane.getPanelId()) : new PTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                Shape shape = pTransform.inverseTransform(zRectangle);
                this.mViewPort.setRect(new ZRectangle(shape.getBounds2D()));
                vector.add(this.mViewPort);
                Dimension dimension3 = this.getSize();
                this.recalcTransform(dimension3.width, dimension3.height);
                this.mViewPort.setSelect(true);
            }
        }

        public void recalcTransform(int n, int n2) {
            String string = ZInstance.prop().getProperty("panel.active");
            JComponent jComponent = (JComponent)ZInstance.map().get(string);
            if (!(jComponent instanceof DocPane)) {
                return;
            }
            DocPane docPane = (DocPane)jComponent;
            if (docPane != null) {
                Dimension dimension = docPane.getDocument().getLogicalSize();
                double d = 5.0;
                double d2 = ((double)n - d * 2.0) / (double)dimension.width;
                double d3 = ((double)n2 - d * 2.0) / (double)dimension.height;
                double d4 = Math.min(d2, d3);
                double d5 = ((double)n - (double)dimension.width * d4) / 2.0;
                double d6 = ((double)n2 - (double)dimension.height * d4) / 2.0;
                DocElement docElement = (DocElement)((Object)this.getDocument().getRootElement(this.getPanelId()));
                XElementNS xElementNS = docElement.getChildElement(".ViewInfo." + this.getPanelId(), null);
                xElementNS.setDoubleAttr("DisplayOffsetX", d5);
                xElementNS.setDoubleAttr("DisplayOffsetY", d6);
                xElementNS.setDoubleAttr("DisplayScale", d4);
            }
        }

        public DocUIAdapter createUIAdapter() {
            return new RPanMouseAdapter(this);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.recalcTransform(n3, n4);
            super.setBounds(n, n2, n3, n4);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(50, 50);
            return dimension;
        }

        public GRectangle getViewPortGob() {
            return this.mViewPort;
        }
    }
}

