/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.action.ZAction;
import jp.co.iti.fagot.doc.DocComponent;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.fob.xml.XDocument;
import jp.co.iti.fagot.fob.xml.XElementNS;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.Ridual;
import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.analyzer.BaseURL;
import jp.co.nri.rid.analyzer.RHTMLAnalyzer;
import jp.co.nri.rid.cleanup.RCleanup;
import jp.co.nri.rid.doc.RidDocument;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.environment.AccessLogDialog;
import jp.co.nri.rid.environment.AnalyzerDialog;
import jp.co.nri.rid.environment.CleanupDialog;
import jp.co.nri.rid.environment.DownloadDialog;
import jp.co.nri.rid.environment.ExistDialog;
import jp.co.nri.rid.environment.ImportDialog;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.environment.SnapshotDialog;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.generator.GeneratorDialog;
import jp.co.nri.rid.generator.RHTMLGenerator;
import jp.co.nri.rid.importer.RDocumentImporter;
import jp.co.nri.rid.importer.RDynamicPageImporter;
import jp.co.nri.rid.importer.RPageImporter;
import jp.co.nri.rid.importer.RResourceImporter;
import jp.co.nri.rid.importer.RStaticPageImporter;
import jp.co.nri.rid.mapper.MapperAccessLog;
import jp.co.nri.rid.o3w.O3W_Importer;
import jp.co.nri.rid.snapshot.snapshot;
import jp.co.nri.rid.snapshot.snapshotDocument;
import jp.co.nri.rid.synchronizer.RSynchronizer;
import jp.co.nri.rid.web.RWebRoboTamer;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class RidToolAction
extends ZAction {
    protected JDialog mTooldlg = null;
    protected JButton mCancel = null;
    protected RToolThread mThread = null;
    private JProgressBar progressBar = new JProgressBar();
    public static final String GENERATE = "generate";
    public static final String ANALYZE_HTML = "analyze_html";
    public static final String IMPORT = "import";
    public static final String EXIST = "exist";
    public static final String SNAPSHOT = "snapshot";
    public static final String CLEANUP = "cleanup";
    public static final String ACCESSLOG = "accesslog";
    public static final String DOWNLOAD = "download";

    public RidToolAction(IZApp iZApp, String string) {
        super(iZApp, string);
    }

    public void doAction(ActionEvent actionEvent) {
        RidElementZone ridElementZone;
        Vector vector;
        DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
        RidMessage ridMessage = new RidMessage();
        String string = ZInstance.prop().getProperty("pj.dir");
        if (string == null) {
            ZDebug.trace("not yet save");
            return;
        }
        if (this.getActionName().equals(GENERATE) && (vector = (ridElementZone = ((RidDocument)docDocument).getTopZone()).getPages(true)).size() == 0) {
            MessageDialog.showError(ridMessage.Warning("W4007", ""));
            return;
        }
        boolean bl = this.openOptionDialog(this.getActionName());
        if (!bl) {
            return;
        }
        this.createDialog(this.getApp().getFrame(), this.getToolName());
        ZDebug.lapStart("Tool");
        this.mThread = new RToolThread(this);
        this.mThread.start();
    }

    public void endAction(Throwable throwable) {
        this.mTooldlg.dispose();
        ZDebug.lapEnd("Tool", false);
        String string = this.getToolName();
        if (throwable != null) {
            throwable.printStackTrace();
        }
        MessageDialog.showException(string, throwable);
    }

    public String getToolName() {
        ZResource zResource = ZApp.getTheApp().getResource();
        if (this.getActionName().equals(GENERATE)) {
            return zResource.getString("msg.generate.title");
        }
        if (this.getActionName().equals(ANALYZE_HTML)) {
            return zResource.getString("msg.analyzer.title");
        }
        if (this.getActionName().equals(IMPORT)) {
            return zResource.getString("msg.import.title");
        }
        if (this.getActionName().equals(EXIST)) {
            return zResource.getString("msg.exist.title");
        }
        if (this.getActionName().equals(SNAPSHOT)) {
            return zResource.getString("msg.snapshot.title");
        }
        if (this.getActionName().equals(CLEANUP)) {
            return zResource.getString("msg.cleanup.title");
        }
        if (this.getActionName().equals(ACCESSLOG)) {
            return zResource.getString("msg.accesslog.title");
        }
        if (this.getActionName().equals(DOWNLOAD)) {
            return zResource.getString("msg.download.title");
        }
        return "";
    }

    public void update() {
        RidElementZone ridElementZone;
        Vector vector;
        boolean bl = true;
        DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
        String string = ZInstance.prop().getProperty("pj.dir");
        if (string == null) {
            bl = false;
        }
        if (this.getActionName().equals(GENERATE) && (vector = (ridElementZone = ((RidDocument)docDocument).getTopZone()).getPages(true)).size() == 0) {
            bl = false;
        }
        this.firePropertyChange("enabled", null, new Boolean(bl));
    }

    public boolean openOptionDialog(String string) {
        boolean bl = true;
        if (this.getActionName().equals(GENERATE)) {
            GeneratorDialog generatorDialog = new GeneratorDialog();
            bl = generatorDialog.show();
        } else if (this.getActionName().equals(ANALYZE_HTML)) {
            AnalyzerDialog analyzerDialog = new AnalyzerDialog();
            bl = analyzerDialog.show();
        } else if (this.getActionName().equals(IMPORT)) {
            String string2 = ZInstance.prop().getProperty("pj.dir");
            ImportDialog importDialog = new ImportDialog();
            bl = importDialog.show(string2);
        } else if (this.getActionName().equals(EXIST)) {
            ExistDialog existDialog = new ExistDialog();
            bl = existDialog.show();
        } else if (this.getActionName().equals(SNAPSHOT)) {
            SnapshotDialog snapshotDialog = new SnapshotDialog();
            bl = snapshotDialog.show();
        } else if (this.getActionName().equals(CLEANUP)) {
            CleanupDialog cleanupDialog = new CleanupDialog();
            bl = cleanupDialog.show();
        } else if (this.getActionName().equals(ACCESSLOG)) {
            AccessLogDialog accessLogDialog = new AccessLogDialog();
            bl = accessLogDialog.show();
        } else if (this.getActionName().equals(DOWNLOAD)) {
            DownloadDialog downloadDialog = new DownloadDialog();
            bl = downloadDialog.show();
        }
        return bl;
    }

    public Throwable execTool() {
        Throwable throwable;
        block50: {
            DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
            String string = ZInstance.prop().getProperty("pj.dir");
            throwable = null;
            try {
                if (this.getActionName().equals(GENERATE)) {
                    RHTMLGenerator rHTMLGenerator = new RHTMLGenerator();
                    docDocument.beginTransaction();
                    rHTMLGenerator.generate(docDocument, string);
                    docDocument.commit();
                    break block50;
                }
                if (this.getActionName().equals(ANALYZE_HTML)) {
                    docDocument.beginTransaction();
                    try {
                        Object object;
                        ZResource zResource = ZApp.getTheApp().getResource();
                        boolean bl = zResource.getBoolean("analyze.o3w.import");
                        if (bl) {
                            ZDebug.trace("O3W");
                            object = new O3W_Importer();
                            ((O3W_Importer)object).Import();
                        }
                        ZDebug.trace("\u30a2\u30ca\u30e9\u30a4\u30ba");
                        object = Ridual.getTopZoneURL();
                        try {
                            BaseURL baseURL = null == object ? null : new BaseURL((String)object);
                            RHTMLAnalyzer rHTMLAnalyzer = new RHTMLAnalyzer((Document)((Object)docDocument), string);
                            rHTMLAnalyzer.analyze(this.progressBar, baseURL);
                            docDocument.commit();
                            break block50;
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new RidException("Bad setting: Top zone URL.");
                        }
                    }
                    catch (Throwable throwable2) {
                        docDocument.commit();
                        ZDebug.trace("Analyze failed");
                        throwable = throwable2;
                    }
                    break block50;
                }
                if (this.getActionName().equals(IMPORT)) {
                    boolean bl;
                    Object object;
                    boolean bl2;
                    Object object2;
                    ZResource zResource = ZApp.getTheApp().getResource();
                    boolean bl3 = zResource.getBoolean("import.page");
                    if (bl3) {
                        docDocument.beginTransaction();
                        try {
                            RStaticPageImporter rStaticPageImporter = new RStaticPageImporter();
                            rStaticPageImporter.Import();
                            object2 = new RDynamicPageImporter();
                            ((RPageImporter)object2).Import();
                            docDocument.commit();
                        }
                        catch (Throwable throwable3) {
                            docDocument.commit();
                            ZDebug.trace("import(page) failed");
                            throwable = throwable3;
                        }
                    }
                    if (bl2 = zResource.getBoolean("import.resource")) {
                        object2 = (DocDocument)((Object)ZInstance.map().get("document.resource"));
                        ((XDocument)((Object)object2)).beginTransaction();
                        try {
                            object = new RResourceImporter();
                            ((RResourceImporter)object).Import();
                            ((XDocument)((Object)object2)).commit();
                        }
                        catch (Throwable throwable4) {
                            ((XDocument)((Object)object2)).commit();
                            ZDebug.trace("import(resource) failed");
                            throwable = throwable4;
                        }
                    }
                    if (bl = zResource.getBoolean("import.document")) {
                        object = (DocDocument)((Object)ZInstance.map().get("document.document"));
                        ((XDocument)((Object)object)).beginTransaction();
                        try {
                            RDocumentImporter rDocumentImporter = new RDocumentImporter();
                            rDocumentImporter.Import();
                            ((XDocument)((Object)object)).commit();
                        }
                        catch (Throwable throwable5) {
                            ((XDocument)((Object)object)).commit();
                            ZDebug.trace("import(document) failed");
                            throwable = throwable5;
                        }
                    }
                    break block50;
                }
                if (this.getActionName().equals(EXIST)) {
                    boolean bl;
                    Object object;
                    boolean bl4;
                    ZResource zResource = ZApp.getTheApp().getResource();
                    boolean bl5 = zResource.getBoolean("exist.page");
                    if (bl5) {
                        docDocument.beginTransaction();
                        try {
                            RSynchronizer rSynchronizer = new RSynchronizer();
                            rSynchronizer.sync("sync.page", docDocument.getDocumentElement(), "rid.html.dir");
                            docDocument.commit();
                        }
                        catch (Throwable throwable6) {
                            docDocument.commit();
                            ZDebug.trace("Check alive(page) failed");
                            throwable = throwable6;
                        }
                    }
                    if (bl4 = zResource.getBoolean("exist.resource")) {
                        DocDocument docDocument2 = (DocDocument)((Object)ZInstance.map().get("document.resource"));
                        docDocument2.beginTransaction();
                        try {
                            object = new RSynchronizer();
                            ((RSynchronizer)object).sync("sync.resource", docDocument2.getDocumentElement(), "rid.html.dir");
                            docDocument2.commit();
                        }
                        catch (Throwable throwable7) {
                            docDocument2.commit();
                            ZDebug.trace("Check alive(resource) failed");
                            throwable = throwable7;
                        }
                    }
                    if (bl = zResource.getBoolean("exist.document")) {
                        object = (DocDocument)((Object)ZInstance.map().get("document.document"));
                        ((XDocument)((Object)object)).beginTransaction();
                        try {
                            RSynchronizer rSynchronizer = new RSynchronizer();
                            rSynchronizer.sync("sync.document", object.getDocumentElement(), "rid.docs.dir");
                            ((XDocument)((Object)object)).commit();
                        }
                        catch (Throwable throwable8) {
                            ((XDocument)((Object)object)).commit();
                            ZDebug.trace("Check alive(document) failed");
                            throwable = throwable8;
                        }
                    }
                    break block50;
                }
                if (this.getActionName().equals(SNAPSHOT)) {
                    boolean bl = false;
                    ZResource zResource = ZApp.getTheApp().getResource();
                    DocDocument docDocument3 = (DocDocument)((Object)ZInstance.map().get("document.snapshot"));
                    docDocument3.beginTransaction();
                    try {
                        snapshot snapshot2 = new snapshot();
                        String string2 = snapshot2.time_stamp();
                        bl = snapshot2.exec(string, string2);
                        if (bl) {
                            snapshotDocument snapshotDocument2 = new snapshotDocument();
                            String string3 = string2 + File.separator + zResource.getString("rid.work.dir");
                            String string4 = string2;
                            String string5 = zResource.getString("snapshot.comment");
                            snapshotDocument2.document((Document)((Object)docDocument3), string3, string4, string5);
                            docDocument3.commit();
                            String string6 = ((DocElement)((Object)docDocument.getDocumentElement())).getChildElementAttribute(".ReferenceUnit.FileUnit", "Type=snapshot", "Name");
                            String string7 = string + File.separator + zResource.getString("rid.data.dir");
                            this.saveDocument(docDocument3, string7 + File.separator + string6);
                        }
                        break block50;
                    }
                    catch (Throwable throwable9) {
                        docDocument3.commit();
                        ZDebug.trace("snapshot failed");
                        throwable = throwable9;
                    }
                    break block50;
                }
                if (this.getActionName().equals(CLEANUP)) {
                    boolean bl;
                    boolean bl6;
                    Object object;
                    Object object3;
                    Object object4;
                    ZDebug.trace("Start Cleanup");
                    ZResource zResource = ZApp.getTheApp().getResource();
                    boolean bl7 = zResource.getBoolean("cleanup.page");
                    if (bl7) {
                        docDocument.beginTransaction();
                        try {
                            RCleanup rCleanup = new RCleanup();
                            rCleanup.cleanupSite(docDocument);
                            object4 = (DocPane)ZInstance.map().get("Zone");
                            object3 = (DocElement)((Object)docDocument.getRootElement(((DocComponent)object4).getPanelId()));
                            if (!((XElementNS)((Object)object3)).getBooleanAttr("Exist", true)) {
                                object = ((RidDocument)docDocument).getTopZone();
                                ((RidElementZone)object).changeRoot((DocPane)object4);
                            }
                            docDocument.commit();
                        }
                        catch (Throwable throwable10) {
                            docDocument.commit();
                            ZDebug.trace("Cleanup(page) failed");
                            throwable = throwable10;
                        }
                    }
                    if (bl6 = zResource.getBoolean("cleanup.resource")) {
                        object4 = (DocDocument)((Object)ZInstance.map().get("document.resource"));
                        ((XDocument)((Object)object4)).beginTransaction();
                        try {
                            object3 = new RCleanup();
                            ((RCleanup)object3).cleanupResource((DocDocument)((Object)object4));
                            ((XDocument)((Object)object4)).commit();
                        }
                        catch (Throwable throwable11) {
                            ((XDocument)((Object)object4)).commit();
                            ZDebug.trace("Cleanup(resource) failed");
                            throwable = throwable11;
                        }
                    }
                    if (bl = zResource.getBoolean("cleanup.document")) {
                        object3 = (DocDocument)((Object)ZInstance.map().get("document.document"));
                        ((XDocument)((Object)object3)).beginTransaction();
                        try {
                            object = new RCleanup();
                            ((RCleanup)object).cleanupDocument((DocDocument)((Object)object3));
                            ((XDocument)((Object)object3)).commit();
                        }
                        catch (Throwable throwable12) {
                            ((XDocument)((Object)object3)).commit();
                            ZDebug.trace("Cleanup(document) failed");
                            throwable = throwable12;
                        }
                    }
                    break block50;
                }
                if (this.getActionName().equals(ACCESSLOG)) {
                    ZDebug.trace("access log start");
                    ZResource zResource = ZApp.getTheApp().getResource();
                    docDocument.beginTransaction();
                    try {
                        MapperAccessLog mapperAccessLog = new MapperAccessLog();
                        mapperAccessLog.accesslog(string, (Document)((Object)docDocument), zResource.getString("accesslog.csvfile"));
                        docDocument.commit();
                        ((RidDocumentSite)docDocument).requestUpdateAccessCount();
                    }
                    catch (Throwable throwable13) {
                        docDocument.commit();
                        ZDebug.trace("access log failed");
                        throwable = throwable13;
                    }
                    ZDebug.trace("access log end");
                    break block50;
                }
                if (!this.getActionName().equals(DOWNLOAD)) break block50;
                ZDebug.trace("download start");
                ZResource zResource = ZApp.getTheApp().getResource();
                try {
                    RWebRoboTamer rWebRoboTamer = new RWebRoboTamer();
                    boolean bl = zResource.getBoolean("download.resource");
                    ZDebug.trace("resource:" + bl);
                    rWebRoboTamer.isResourceDownload = bl;
                    String string8 = zResource.getString("download.proxy.host");
                    int n = zResource.getInt("download.proxy.port", 0);
                    ZDebug.trace("proxy host:" + string8);
                    ZDebug.trace("proxy port:" + n);
                    rWebRoboTamer.setProxy(string8, n);
                    String string9 = ZInstance.prop().getProperty("download.proxy.user");
                    String string10 = ZInstance.prop().getProperty("rid.perform");
                    rWebRoboTamer.setAuthorization(string9, string10);
                    String string11 = Ridual.getHtmlDir();
                    rWebRoboTamer.setSaveDir(new File(string11));
                    String string12 = zResource.getString("download.url");
                    if (string12 != null) {
                        ZDebug.trace("url:" + string12);
                        rWebRoboTamer.get(string12);
                    }
                }
                catch (Throwable throwable14) {
                    ZDebug.trace("download failed");
                    throwable = throwable14;
                }
                ZDebug.trace("download end");
            }
            catch (Throwable throwable15) {
                ZDebug.trace("exec tool failed");
                throwable = throwable15;
            }
        }
        return throwable;
    }

    public void createDialog(Frame frame, String string) {
        this.mTooldlg = new JDialog(frame, "Ridual/" + string);
        this.mTooldlg.setModal(false);
        JPanel jPanel = new JPanel();
        this.mCancel = new JButton("Cancel");
        this.mCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RidToolAction.this.mThread.interrupt();
                RidToolAction.this.mThread.stop();
                RidToolAction.this.mTooldlg.dispose();
            }
        });
        jPanel.add(this.mCancel);
        this.progressBar.setString(string);
        this.progressBar.setStringPainted(true);
        try {
            this.progressBar.setIndeterminate(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(8, 8, 0, 8));
        jPanel2.add("North", this.progressBar);
        jPanel2.add((Component)jPanel, "South");
        this.mTooldlg.getContentPane().add((Component)jPanel2, "Center");
        this.mTooldlg.pack();
        this.mTooldlg.setSize(280, this.mTooldlg.getHeight());
        Dimension dimension = this.mTooldlg.getToolkit().getScreenSize();
        this.mTooldlg.setLocation(dimension.width / 2 - this.mTooldlg.getWidth() / 2, dimension.height / 2 - this.mTooldlg.getHeight() / 2);
        this.mTooldlg.show();
    }

    protected DocDocument saveDocument(DocDocument docDocument, String string) {
        try {
            String string2 = docDocument.getEncoding();
            boolean bl = docDocument.getIndenting();
            ZDebug.trace("save:" + string);
            OutputFormat outputFormat = new OutputFormat((Document)((Object)docDocument), string2, bl);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DOMSerializer dOMSerializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat).asDOMSerializer();
            dOMSerializer.serialize((Document)((Object)docDocument));
            return docDocument;
        }
        catch (Throwable throwable) {
            ZDebug.err("FileSave failed:" + string);
            throwable.printStackTrace();
            return null;
        }
    }

    class RToolThread
    extends Thread {
        protected RidToolAction mAct = null;

        RToolThread(RidToolAction ridToolAction2) {
            super(ridToolAction2.getActionName());
            this.mAct = ridToolAction2;
        }

        public void run() {
            Throwable throwable = RidToolAction.this.execTool();
            if (RidToolAction.this.getActionName().equals(RidToolAction.ANALYZE_HTML) || RidToolAction.this.getActionName().equals(RidToolAction.IMPORT)) {
                RidDocumentSite ridDocumentSite = (RidDocumentSite)ZInstance.map().get("document.site");
                ridDocumentSite.requestRecalcMap();
                RUpdateManager.update(0, true);
            } else {
                RUpdateManager.update(0);
            }
            this.mAct.endAction(throwable);
        }
    }
}

