/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.analyzer;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class BaseURL {
    private static final String[] IGNORE_HEADER_STRINGS = new String[]{" ", "news:", "mail:", "telto:", "tel:", "mailto:", "javascript:"};
    private static final char[] IGNORE_HEADER_CHARS = new char[]{'?', '<', '#'};
    private static final char[] SEPARATORCHARS = new char[]{'#', '?'};
    private String protocol = null;
    private String host = null;
    private String path = null;
    private int port = -1;
    private int pathlen = 0;

    public BaseURL(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        this.protocol = uRL.getProtocol();
        this.host = uRL.getHost();
        this.path = uRL.getPath();
        this.port = uRL.getPort();
        this.pathlen = this.path.length();
    }

    public String getInnerPath(String string, String string2) {
        String string3;
        Serializable serializable;
        int n;
        try {
            n = string2.charAt(0);
            for (int i = IGNORE_HEADER_CHARS.length - 1; 0 <= i; --i) {
                if (IGNORE_HEADER_CHARS[i] != n) continue;
                return null;
            }
            String string4 = string2.toLowerCase();
            for (int i = IGNORE_HEADER_STRINGS.length - 1; 0 <= i; --i) {
                if (!string4.startsWith(IGNORE_HEADER_STRINGS[i])) continue;
                return null;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        n = string2.indexOf(63);
        int n2 = string2.indexOf(35);
        if (0 > n) {
            if (0 <= n2) {
                string2 = string2.substring(0, n2);
            }
        } else {
            string2 = 0 <= n2 ? string2.substring(0, n < n2 ? n : n2) : string2.substring(0, n);
        }
        try {
            serializable = new URL(string2);
            string3 = ((URL)serializable).getProtocol();
            if (0 < string3.length()) {
                if (!string3.equalsIgnoreCase(this.protocol)) {
                    return null;
                }
                if (!((URL)serializable).getHost().equalsIgnoreCase(this.host)) {
                    return null;
                }
                if (((URL)serializable).getPort() != this.port) {
                    return null;
                }
                String string5 = ((URL)serializable).getPath();
                if (0 >= string5.length()) {
                    string5 = "/";
                }
                if (!string5.startsWith(this.path)) {
                    return null;
                }
                String string6 = string5.substring(this.pathlen);
                return string6.startsWith("/") ? string6 : "/" + string6;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        string2 = string2.replace(File.separatorChar, '/');
        serializable = string2.startsWith("/") ? new File(string2) : new File(new File(this.path, string).getParentFile(), string2);
        string3 = ((File)serializable).getPath();
        if ('/' != File.separatorChar) {
            string3 = string3.replace(File.separatorChar, '/');
        }
        try {
            string3 = new URI(string3).normalize().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                return new URL(this.protocol, this.host, this.port, string3).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        try {
            if (!string3.startsWith(this.path)) {
                return new URL(this.protocol, this.host, this.port, string3).toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        String string7 = string3.substring(this.pathlen);
        return string7.startsWith("/") ? string7 : "/" + string7;
    }

    public String getOuterPath(String string) {
        String string2 = new File(this.path, string).getPath();
        return '/' != File.separatorChar ? string2.replace(File.separatorChar, '/') : string2;
    }
}

