/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.doc;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GRectShape;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.nri.rid.doc.AccessCounts;

public class MapModel {
    protected ZRectangle mPageRect = new ZRectangle(0.0, 0.0, 30.0, 40.0);
    protected ZRectangle mTitleRect = new ZRectangle(0.0, 0.0, 30.0, 10.0);
    protected ZPoint mBasePoint = new ZPoint(8000.0, 6000.0);
    protected ZPoint mBaseOffset = new ZPoint(0.0, 0.0);
    protected ZPoint mLinkOffset = new ZPoint(0.5, 0.5);
    protected AffineTransform mAtObject = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    protected AffineTransform mAtCoord = new AffineTransform(100.0f, 0.0f, 0.0f, 100.0f, 0.0f, 0.0f);
    protected double mCircleOffset = 100.0;
    protected double mScale = 1.0;
    protected AccessCounts mAcc = new AccessCounts();
    protected int mAccessMax = 1000;

    public Shape createPageShape(double d, double d2, String string) {
        GRectShape gRectShape = new GRectShape();
        gRectShape.setShape(string);
        gRectShape.setRect(this.mPageRect);
        return this.createShape(gRectShape.getPath(), d, d2);
    }

    public Shape createScenarioShape(double d, double d2) {
        ZRectangle zRectangle = new ZRectangle(this.mPageRect);
        double d3 = 20.0;
        zRectangle.setX(zRectangle.getX() - d3);
        zRectangle.setY(zRectangle.getY() - d3);
        zRectangle.setWidth(zRectangle.getWidth() + d3 * 2.0);
        zRectangle.setHeight(zRectangle.getHeight() + d3 * 2.0);
        return this.createShape(zRectangle, d, d2);
    }

    public Shape createTitleShape(double d, double d2) {
        return this.createShape(this.mTitleRect, d, d2);
    }

    public Shape[] createAccessShapes(double d, double d2, AccessCounts accessCounts) {
        ZRectangle zRectangle = new ZRectangle(this.mPageRect);
        double d3 = zRectangle.getHeight() * 2.5;
        zRectangle.setY(zRectangle.getY() + zRectangle.getHeight() - d3);
        zRectangle.setHeight(d3);
        zRectangle.setX(zRectangle.getX() + 5.0);
        zRectangle.setWidth(zRectangle.getWidth() - 10.0);
        ZRectangle[] zRectangleArray = this.mAcc.createAccessRects(zRectangle, accessCounts);
        if (zRectangleArray == null) {
            return null;
        }
        Shape[] shapeArray = new Shape[zRectangleArray.length];
        for (int i = 0; i < zRectangleArray.length; ++i) {
            shapeArray[i] = this.createShape(zRectangleArray[i], d, d2);
        }
        return shapeArray;
    }

    public Shape createShape(Shape shape, double d, double d2) {
        Shape shape2 = this.mAtObject.createTransformedShape(shape);
        ZPoint zPoint = this.modelToView(new ZPoint(d, d2));
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, zPoint.getX(), zPoint.getY());
        return affineTransform.createTransformedShape(shape2);
    }

    public ZPoint getLinkPoint(double d, double d2) {
        ZPoint zPoint = this.modelToView(new ZPoint(d, d2));
        zPoint.translate(this.getLinkPointOffset());
        return zPoint;
    }

    public ZPoint getLinkHarfPoint(double d, double d2) {
        return this.getLinkPoint(d + 0.5, d2);
    }

    public ZPoint getLinkPointOffset() {
        ZPoint zPoint = new ZPoint(this.mPageRect.getWidth() * this.mLinkOffset.getX(), this.mPageRect.getHeight() * this.mLinkOffset.getY());
        ZPoint zPoint2 = new ZPoint();
        this.mAtObject.transform(zPoint, zPoint2);
        return zPoint2;
    }

    public ZPoint modelToCoord(ZPoint zPoint) {
        ZPoint zPoint2 = new ZPoint();
        if (this.getCoordTransform() != null) {
            this.getCoordTransform().transform(zPoint, zPoint2);
        } else {
            double d = this.getCircleOffset();
            zPoint2.setX(Math.cos(zPoint.getY()) * (zPoint.getX() - 1.0) * d);
            zPoint2.setY(Math.sin(zPoint.getY()) * (zPoint.getX() - 1.0) * d);
        }
        return zPoint2;
    }

    public ZPoint modelToView(ZPoint zPoint) {
        ZPoint zPoint2 = this.modelToCoord(zPoint);
        zPoint2.translate(new ZPoint(this.mBasePoint.getX() - this.mBaseOffset.getX(), this.mBasePoint.getY() - this.mBaseOffset.getY()));
        return zPoint2;
    }

    public ZPoint coordToModel(ZPoint zPoint) {
        ZPoint zPoint2 = new ZPoint();
        if (this.getCoordTransform() != null) {
            try {
                this.getCoordTransform().inverseTransform(zPoint, zPoint2);
            }
            catch (Exception exception) {
                ZDebug.err("inverse transform failed");
            }
        } else {
            double d = this.getCircleOffset();
            zPoint2.setX(Math.sqrt((zPoint.getX() * zPoint.getX() + zPoint.getY() * zPoint.getY()) / (d * d)) + 1.0);
            double d2 = Math.atan(zPoint.getY() / zPoint.getX());
            if (zPoint.getX() < 0.0) {
                d2 += Math.PI;
            } else if (zPoint.getY() < 0.0) {
                d2 += Math.PI * 2;
            }
            zPoint2.setY(d2);
        }
        return zPoint2;
    }

    public ZPoint viewToModel(ZPoint zPoint) {
        zPoint.translate(-(this.mBasePoint.getX() - this.mBaseOffset.getX()), -(this.mBasePoint.getY() - this.mBaseOffset.getY()));
        ZPoint zPoint2 = this.coordToModel(zPoint);
        return zPoint2;
    }

    public void setAccessCounts(AccessCounts accessCounts) {
        if (accessCounts != null) {
            this.mAcc = accessCounts;
        }
    }

    public void setBasePoint(ZPoint zPoint) {
        this.mBasePoint = zPoint;
    }

    public void setLinkOffset(ZPoint zPoint) {
        this.mLinkOffset = zPoint;
    }

    public void setObjectTransform(AffineTransform affineTransform) {
        this.mAtObject = affineTransform;
    }

    public void setCoordTransform(AffineTransform affineTransform) {
        this.mAtCoord = affineTransform;
    }

    protected AffineTransform getCoordTransform() {
        AffineTransform affineTransform = null;
        if (this.mAtCoord != null) {
            affineTransform = new AffineTransform(this.mAtCoord);
            affineTransform.scale(this.mScale, this.mScale);
        }
        return affineTransform;
    }

    public double getCircleOffset() {
        return this.mCircleOffset * this.mScale;
    }

    public void clearOffset() {
        this.mScale = 1.0;
        this.mBaseOffset = new ZPoint(0.0, 0.0);
    }

    public ZRectangle fitToPanel(ZRectangle zRectangle, Dimension dimension) {
        double d = Math.max(0.0, -zRectangle.getY());
        double d2 = Math.max(0.0, zRectangle.getY() + zRectangle.getHeight() - (double)dimension.height);
        double d3 = Math.max(d, d2);
        double d4 = Math.max(0.0, -zRectangle.getX());
        double d5 = Math.max(0.0, zRectangle.getX() + zRectangle.getWidth() - (double)dimension.width);
        double d6 = Math.max(d4, d5);
        ZRectangle zRectangle2 = new ZRectangle(zRectangle);
        if (d3 > 0.0 || d6 > 0.0) {
            this.mScale = Math.min((double)dimension.height / zRectangle.getHeight(), (double)dimension.width / zRectangle.getWidth());
            if (this.mScale > 1.0) {
                this.mScale = 1.0;
            }
            this.mBaseOffset.setX(this.mBasePoint.getX() - (this.mBasePoint.getX() - zRectangle.getX()) * this.mScale);
            this.mBaseOffset.setY(this.mBasePoint.getY() - (this.mBasePoint.getY() - zRectangle.getY()) * this.mScale);
            zRectangle2 = this.mScale < 1.0 ? new ZRectangle(0.0, 0.0, dimension.width, dimension.height) : new ZRectangle(0.0, 0.0, zRectangle.getWidth(), zRectangle.getHeight());
        }
        return zRectangle2;
    }
}

