/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.environment;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.environment.DocumentType;
import jp.co.nri.rid.environment.DocumentTypeDialog;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;

public class EnvDocumentList
extends JPanel {
    protected JPanel mPanel = new JPanel();
    protected JScrollPane mSPanel = null;
    protected JPanel mBPanel = null;
    protected JList mList = null;
    protected JButton mJBNew = null;
    protected JButton mJBEdit = null;
    protected JButton mJBDel = null;
    protected Vector mDtLst = null;
    protected DefaultListModel mModel = null;
    protected int mListCnt = 0;

    public EnvDocumentList() throws Exception {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.crtDocList();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.mSPanel, gridBagConstraints);
        this.mPanel.add(this.mSPanel);
        this.crtButtonPanel(gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.mBPanel, gridBagConstraints);
        this.mPanel.add(this.mBPanel);
    }

    public void crtDocList() throws Exception {
        this.mModel = new DefaultListModel();
        this.mList = new JList(this.mModel);
        this.mList.setSelectionMode(0);
        this.mDtLst = this.getDocList();
        this.mListCnt = this.mDtLst.size();
        for (int i = 0; i < this.mDtLst.size(); ++i) {
            DocumentType documentType = (DocumentType)this.mDtLst.elementAt(i);
            this.mModel.addElement(documentType.app);
        }
        this.mSPanel = new JScrollPane();
        this.mSPanel.getViewport().setView(this.mList);
        this.mSPanel.setPreferredSize(new Dimension(200, 30));
    }

    public void crtButtonPanel(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) throws Exception {
        this.mBPanel = new JPanel();
        this.mBPanel.setLayout(gridBagLayout);
        this.mJBNew = new JButton("New");
        this.mJBNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvDocumentList.this.NewDocument();
            }
        });
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.mJBNew, gridBagConstraints);
        this.mBPanel.add(this.mJBNew);
        this.mJBEdit = new JButton("Edit");
        this.mJBEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvDocumentList.this.EditDocument();
            }
        });
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.mJBEdit, gridBagConstraints);
        this.mBPanel.add(this.mJBEdit);
        this.mJBDel = new JButton("Delete");
        this.mJBDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvDocumentList.this.DelDocument();
            }
        });
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.mJBDel, gridBagConstraints);
        this.mBPanel.add(this.mJBDel);
    }

    public Vector getDocList() throws Exception {
        String string;
        String string2;
        Vector<DocumentType> vector = new Vector<DocumentType>();
        ZResource zResource = ZApp.getTheApp().getResource();
        int n = 1;
        while (!this.isNullString(string2 = zResource.getString(string = "command.doc.ext." + Integer.toString(n)))) {
            string = "command.doc.app." + Integer.toString(n);
            String string3 = zResource.getString(string);
            string = "command.doc.cmd." + Integer.toString(n);
            String string4 = zResource.getString(string);
            string = "command.doc.view." + Integer.toString(n);
            String string5 = zResource.getString(string);
            DocumentType documentType = new DocumentType();
            documentType.app = string3;
            documentType.cmd = string4;
            documentType.ext = string2;
            documentType.view = string5;
            vector.add(documentType);
            ++n;
        }
        return vector;
    }

    public void setDocList() throws Exception {
        int n = Math.max(this.mListCnt, this.mDtLst.size());
        ZResource zResource = ZApp.getTheApp().getResource();
        for (int i = 1; i <= n; ++i) {
            String string = "command.doc.app." + Integer.toString(i);
            String string2 = "command.doc.cmd." + Integer.toString(i);
            String string3 = "command.doc.ext." + Integer.toString(i);
            String string4 = "command.doc.view." + Integer.toString(i);
            if (i <= this.mDtLst.size()) {
                DocumentType documentType = (DocumentType)this.mDtLst.elementAt(i - 1);
                zResource.putString(string, documentType.app);
                zResource.putString(string2, documentType.cmd);
                zResource.putString(string3, documentType.ext);
                zResource.putString(string4, documentType.view);
                continue;
            }
            zResource.putString(string, null);
            zResource.putString(string2, null);
            zResource.putString(string3, null);
            zResource.putString(string4, null);
        }
    }

    public JPanel getPanel() {
        return this.mPanel;
    }

    public void NewDocument() {
        RidMessage ridMessage = new RidMessage();
        DocumentTypeDialog documentTypeDialog = new DocumentTypeDialog();
        DocumentType documentType = new DocumentType();
        boolean bl = documentTypeDialog.newDocument(documentType);
        if (bl) {
            if (this.isNullString(documentType.app) || this.isNullString(documentType.cmd) || this.isNullString(documentType.ext)) {
                MessageDialog.showError(ridMessage.Warning("W4008", ""));
            } else if (this.mDtLst.indexOf(documentType) == -1) {
                this.mDtLst.add(documentType);
                this.mModel.addElement(documentType.app);
            }
        }
    }

    public void EditDocument() {
        DocumentType documentType;
        DocumentTypeDialog documentTypeDialog;
        boolean bl;
        int n = this.mList.getSelectedIndex();
        if (n > -1 && (bl = (documentTypeDialog = new DocumentTypeDialog()).editDocument(documentType = (DocumentType)this.mDtLst.elementAt(n)))) {
            this.mDtLst.remove(n);
            this.mModel.remove(n);
            this.mDtLst.add(n, documentType);
            this.mModel.add(n, documentType.app);
        }
    }

    public void DelDocument() {
        int n = this.mList.getSelectedIndex();
        if (n > -1) {
            this.mDtLst.remove(n);
            this.mModel.remove(n);
        }
    }

    public boolean isNullString(String string) {
        boolean bl = string == null || string.equals("");
        return bl;
    }
}

