/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.environment;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.Ridual;
import org.w3c.dom.Node;

public class HtmlDirDialog {
    private static final String MSG_TITLE = "msg.htmldir.title";
    private static final String MSG_HTMLDIR = "msg.htmldir.htmldir";
    private static final String MSG_ATPIP = "msg.htmldir.atpip";
    private static final String MSG_SET = "msg.htmldir.set";
    private static final String MSG_CANCEL = "msg.htmldir.cancel";
    private static final String MSG_DEFAULT = "msg.htmldir.default";
    private static final String MSG_REF = "msg.htmldir.ref";
    private static final String MSG_INFO = "msg.htmldir.info";
    private static final String MSG_ERROR_SAVE = "msg.htmldir.error.save";
    private static final String MSG_ERROR_LICENSE = "msg.htmldir.error.license";
    private JTextField htmlDir = new JTextField();
    private JTextField atPip = new JTextField();
    private JDialog gdlg;
    private JFileChooser chooser = null;

    public HtmlDirDialog() {
        ZResource zResource = ZApp.getTheApp().getResource();
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        this.gdlg = new JDialog((Frame)jFrame, zResource.getString(MSG_TITLE));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.createLabelConstraints();
        GridBagConstraints gridBagConstraints2 = this.createComponentConstraints();
        GridBagConstraints gridBagConstraints3 = this.createComponentConstraints2();
        GridBagConstraints gridBagConstraints4 = this.createComponentConstraints3();
        GridBagConstraints gridBagConstraints5 = this.createInfoConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel(zResource.getString(MSG_HTMLDIR));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridx = 0;
        gridBagLayout.setConstraints(this.htmlDir, gridBagConstraints3);
        jPanel.add(this.htmlDir);
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridx = 1;
        JButton jButton = new JButton(new RefAction(zResource.getString(MSG_REF), this.gdlg));
        gridBagLayout.setConstraints(jButton, gridBagConstraints4);
        jPanel.add(jButton);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        jLabel = new JLabel(zResource.getString(MSG_ATPIP));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridx = 0;
        gridBagLayout.setConstraints(this.atPip, gridBagConstraints2);
        jPanel.add(this.atPip);
        jLabel = new JLabel(zResource.getString(MSG_INFO));
        jLabel.setForeground(Color.BLUE);
        gridBagConstraints5.gridy = 4;
        gridBagConstraints5.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints5);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JButton(new SetAction(zResource.getString(MSG_SET), this.gdlg)));
        jPanel2.add(new JButton(new CancelAction(zResource.getString(MSG_CANCEL), this.gdlg)));
        jPanel2.add(new JButton(new DefaultAction(zResource.getString(MSG_DEFAULT), this.gdlg)));
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridx = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints2);
        jPanel.add(jPanel2);
        this.gdlg.setContentPane(jPanel);
        this.gdlg.setModal(true);
    }

    public void show() {
        String string = Ridual.getHtmlDir2();
        String string2 = Ridual.getHtmlDirPIP();
        this.htmlDir.setText(null == string ? "" : string);
        this.atPip.setText(null == string2 ? "" : string2);
        this.gdlg.pack();
        Dimension dimension = this.gdlg.getToolkit().getScreenSize();
        this.gdlg.setLocation(dimension.width / 2 - this.gdlg.getWidth() / 2, dimension.height / 2 - this.gdlg.getHeight() / 2);
        this.gdlg.show();
    }

    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        return gridBagConstraints;
    }

    private GridBagConstraints createInfoConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 32, 0, 32);
        return gridBagConstraints;
    }

    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        return gridBagConstraints;
    }

    private GridBagConstraints createComponentConstraints2() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        return gridBagConstraints;
    }

    private GridBagConstraints createComponentConstraints3() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        return gridBagConstraints;
    }

    private void createIndex1() throws TransformerConfigurationException, TransformerException {
        ZResource zResource = ZApp.getTheApp().getResource();
        File file = new File(zResource.getString("app.install.path"), zResource.getString("app.config.dir"));
        File file2 = new File(file, "application");
        StreamSource streamSource = new StreamSource(new File(file2, "index_1.xsl"));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setOutputProperty("method", "html");
        transformer.setOutputProperty("encoding", "Shift_JIS");
        File file3 = new File(ZInstance.prop().getProperty("pj.dir"), zResource.getString("rid.admin.dir"));
        transformer.transform(new DOMSource((Node)((Object)((DocDocument)((Object)ZInstance.map().get("document.site"))))), new StreamResult(new File(file3, "index_1.html")));
    }

    private boolean setHtmlDir(String string, String string2) {
        Ridual ridual = (Ridual)ZApp.getTheApp();
        if (!ridual.checkLicense(false)) {
            JOptionPane.showMessageDialog(this.gdlg, ZApp.getTheApp().getResource().getString(MSG_ERROR_LICENSE));
            return false;
        }
        String string3 = "";
        try {
            Ridual.setHtmlDir(string);
            Ridual.setHtmlDirPIP(string2);
            if (ridual.save()) {
                this.createIndex1();
                return true;
            }
            string3 = ZApp.getTheApp().getResource().getString(MSG_ERROR_SAVE);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            string3 = throwable.getMessage();
        }
        try {
            JOptionPane.showMessageDialog(this.gdlg, string3);
        }
        catch (HeadlessException headlessException) {
            headlessException.printStackTrace();
        }
        return false;
    }

    private class RefAction
    extends AbstractAction {
        private JDialog dlg;

        public RefAction(String string, JDialog jDialog) {
            super(string);
            this.dlg = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HtmlDirDialog.this.chooser == null) {
                HtmlDirDialog.this.chooser = new JFileChooser();
                HtmlDirDialog.this.chooser.setFileSelectionMode(1);
            }
            HtmlDirDialog.this.chooser.setCurrentDirectory(new File(Ridual.getHtmlDir()));
            if (HtmlDirDialog.this.chooser.showOpenDialog(this.dlg) != 0) {
                return;
            }
            File file = HtmlDirDialog.this.chooser.getSelectedFile();
            HtmlDirDialog.this.htmlDir.setText(file.getAbsolutePath());
        }
    }

    private class DefaultAction
    extends AbstractAction {
        private JDialog dlg;

        public DefaultAction(String string, JDialog jDialog) {
            super(string);
            this.dlg = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HtmlDirDialog.this.setHtmlDir(null, null)) {
                this.dlg.hide();
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private JDialog dlg;

        public CancelAction(String string, JDialog jDialog) {
            super(string);
            this.dlg = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dlg.hide();
        }
    }

    private class SetAction
    extends AbstractAction {
        private JDialog dlg;

        public SetAction(String string, JDialog jDialog) {
            super(string);
            this.dlg = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HtmlDirDialog.this.htmlDir.getText();
            String string2 = HtmlDirDialog.this.atPip.getText();
            if (HtmlDirDialog.this.setHtmlDir(0 < string.length() ? string : null, 0 < string2.length() ? string2 : null)) {
                this.dlg.hide();
            }
        }
    }
}

