/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.environment;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.Ridual;
import jp.co.nri.rid.environment.EnvDialog;
import jp.co.nri.rid.environment.EnvFileChooser;

public class ImportDialog {
    public static final String IGNORE_PREFIX = "rid.ignore.prefix";
    public static final String IMPORT_PAGE = "import.page";
    public static final String IMPORT_RESOURCE = "import.resource";
    public static final String IMPORT_DOCUMENT = "import.document";
    public static final String IMPORT_DIR = "import.dir";
    public static final String IMPORT_COMMENT = "import.comment";
    public static final String MSG_IMPORT_TITLE = "msg.import.title";
    public static final String MSG_IMPORT_PAGE = "msg.import.page";
    public static final String MSG_IMPORT_RESOURCE = "msg.import.resource";
    public static final String MSG_IMPORT_DOCUMENT = "msg.import.document";
    public static final String MSG_IMPORT_IMPORT = "msg.import.import";
    public static final String MSG_IMPORT_COMMENT = "msg.import.comment";
    public static final String MSG_IMPORT_DIR = "msg.import.dir";
    public static final String MSG_IMPORT_IGNORE = "msg.import.ignore";
    public static final String MSG_IMPORT_REF = "msg.import.ref";
    protected JPanel mPanel = null;
    protected JTextField mIgnorePrefix = null;
    protected JCheckBox mImportPage = null;
    protected JCheckBox mImportResource = null;
    protected JCheckBox mImportDocument = null;
    protected JTextField mImportDir = null;
    protected String mImportPath = null;
    protected JButton mImportDirButton = null;
    protected JTextField mImportComment = null;
    protected String mProjectDir = null;

    public boolean show(String string) {
        ZResource zResource = ZApp.getTheApp().getResource();
        this.mProjectDir = string;
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog envDialog = new EnvDialog(jFrame, zResource.getString(MSG_IMPORT_TITLE));
        this.mPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel(zResource.getString(MSG_IMPORT_IGNORE));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        this.mIgnorePrefix = this.createIgnorePrefix();
        gridBagLayout.setConstraints(this.mIgnorePrefix, gridBagConstraints);
        this.mPanel.add(this.mIgnorePrefix);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jLabel = new JLabel(zResource.getString(MSG_IMPORT_IMPORT));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        this.mImportPage = this.createImporCheckBox(zResource.getString(MSG_IMPORT_PAGE), IMPORT_PAGE);
        gridBagLayout.setConstraints(this.mImportPage, gridBagConstraints);
        this.mPanel.add(this.mImportPage);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 2;
        this.mImportResource = this.createImporCheckBox(zResource.getString(MSG_IMPORT_RESOURCE), IMPORT_RESOURCE);
        gridBagLayout.setConstraints(this.mImportResource, gridBagConstraints);
        this.mPanel.add(this.mImportResource);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        this.mImportDocument = this.createImporCheckBox(zResource.getString(MSG_IMPORT_DOCUMENT), IMPORT_DOCUMENT);
        gridBagLayout.setConstraints(this.mImportDocument, gridBagConstraints);
        this.mPanel.add(this.mImportDocument);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jLabel = new JLabel(zResource.getString(MSG_IMPORT_DIR));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = this.createImportDir();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.mPanel.add(jPanel);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jLabel = new JLabel(zResource.getString(MSG_IMPORT_COMMENT));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        this.mImportComment = this.createImportComment();
        gridBagLayout.setConstraints(this.mImportComment, gridBagConstraints);
        this.mPanel.add(this.mImportComment);
        envDialog.setControlPanel(this.mPanel);
        envDialog.doModal();
        boolean bl = envDialog.isOK();
        if (bl) {
            this.setImportResource();
        }
        return bl;
    }

    private JTextField createIgnorePrefix() {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string = zResource.getString(IGNORE_PREFIX);
        JTextField jTextField = new JTextField(string);
        return jTextField;
    }

    private String getIgnorePrefix() {
        String string = this.mIgnorePrefix.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private JCheckBox createImporCheckBox(String string, String string2) {
        ZResource zResource = ZApp.getTheApp().getResource();
        boolean bl = zResource.getBoolean(string2);
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setSelected(bl);
        return jCheckBox;
    }

    public JPanel createImportDir() {
        String string;
        ZResource zResource = ZApp.getTheApp().getResource();
        this.mImportPath = zResource.getString(IMPORT_DIR);
        if (this.mImportPath == null) {
            this.mImportPath = "";
        }
        if (!(string = this.mImportPath.substring(0, Math.min(this.mProjectDir.length(), this.mImportPath.length()))).equalsIgnoreCase(this.mProjectDir)) {
            this.mImportPath = "";
        }
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mImportDir = new JTextField(this.mImportPath);
        jPanel.add(this.mImportDir);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.mImportDir, gridBagConstraints);
        this.mImportDirButton = new JButton(zResource.getString(MSG_IMPORT_REF));
        this.mImportDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.fileChooser();
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.mImportDirButton, gridBagConstraints);
        jPanel.add(this.mImportDirButton);
        return jPanel;
    }

    public void fileChooser() {
        String string;
        Object object;
        this.mImportPath = this.getImportPath();
        if (this.mImportPath == null) {
            object = ZApp.getTheApp().getResource();
            this.mImportPath = Ridual.getHtmlDir();
        }
        if ((string = ((EnvFileChooser)(object = new EnvFileChooser())).show(this.mPanel, this.mImportPath, 1)) != null) {
            this.mImportDir.setText(string);
            this.mImportPath = string;
        }
    }

    private String getImportPath() {
        String string = this.mImportDir.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private JTextField createImportComment() {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string = zResource.getString(IMPORT_COMMENT);
        JTextField jTextField = new JTextField(string);
        return jTextField;
    }

    private String getImportComment() {
        String string = this.mImportComment.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private void setImportResource() {
        ZResource zResource = ZApp.getTheApp().getResource();
        zResource.putString(IGNORE_PREFIX, this.getIgnorePrefix());
        zResource.putBoolean(IMPORT_PAGE, this.mImportPage.isSelected());
        zResource.putBoolean(IMPORT_RESOURCE, this.mImportResource.isSelected());
        zResource.putBoolean(IMPORT_DOCUMENT, this.mImportDocument.isSelected());
        String string = this.getImportPath();
        zResource.putString(IMPORT_DIR, this.getImportPath());
        zResource.putString(IMPORT_COMMENT, this.getImportComment());
    }
}

