/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.generator;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import jp.co.nri.rid.generator.GenerateParser;
import org.w3c.dom.Document;

public class GenerateCSV
extends GenerateParser {
    public static final String SITE_XML = "Site.xml";
    public static final String RESOURCE_XML = "Resource.xml";
    public static final String DOCUMENT_XML = "Document.xml";
    public static final String ZONE_UNIT = "<ZoneUnit>";
    public static final String PAGE_UNIT = "<PageUnit>";
    public static final String RESOURCE_UNIT = "<ResourceUnit>";
    public static final String DOCUMENT_UNIT = "<DocumentUnit>";
    protected FileOutputStream outFileStream = null;
    protected OutputStreamWriter outWriter = null;

    public boolean csvSite(Document document, String string) throws Exception {
        return this.csv(SITE_XML, document, string);
    }

    public boolean csvResource(Document document, String string) throws Exception {
        return this.csv(RESOURCE_XML, document, string);
    }

    public boolean csvDocument(Document document, String string) throws Exception {
        return this.csv(DOCUMENT_XML, document, string);
    }

    private boolean csv(String string, Document document, String string2) throws Exception {
        GenerateParser.ProjectInfo projectInfo = this.documentParser(document, "", "");
        return this.generateCSV(string, projectInfo, string2);
    }

    private boolean generateCSV(String string, GenerateParser.ProjectInfo projectInfo, String string2) throws Exception {
        boolean bl = false;
        this.outFileStream = new FileOutputStream(string2);
        this.outWriter = new OutputStreamWriter(this.outFileStream);
        this.writeCSV(string, projectInfo.zone);
        this.outWriter.close();
        return true;
    }

    private void writeCSV(String string, GenerateParser.ZoneInfo zoneInfo) throws Exception {
        Object object;
        int n;
        this.writeUnit(ZONE_UNIT, zoneInfo.attr_lst);
        if (string.compareTo(SITE_XML) == 0) {
            for (n = 0; n < zoneInfo.page_lst.size(); ++n) {
                object = (GenerateParser.PageInfo)zoneInfo.page_lst.elementAt(n);
                this.writeUnit(PAGE_UNIT, ((GenerateParser.PageInfo)object).attr_lst);
            }
        } else if (string.compareTo(RESOURCE_XML) == 0) {
            for (n = 0; n < zoneInfo.resource_lst.size(); ++n) {
                object = (GenerateParser.ResourceInfo)zoneInfo.resource_lst.elementAt(n);
                this.writeUnit(RESOURCE_UNIT, ((GenerateParser.ResourceInfo)object).attr_lst);
            }
        } else if (string.compareTo(DOCUMENT_XML) == 0) {
            for (n = 0; n < zoneInfo.document_lst.size(); ++n) {
                object = (GenerateParser.DocumentInfo)zoneInfo.document_lst.elementAt(n);
                this.writeUnit(DOCUMENT_UNIT, ((GenerateParser.DocumentInfo)object).attr_lst);
            }
        }
        for (n = 0; n < zoneInfo.zone_lst.size(); ++n) {
            object = (GenerateParser.ZoneInfo)zoneInfo.zone_lst.elementAt(n);
            this.writeCSV(string, (GenerateParser.ZoneInfo)object);
        }
    }

    private void writeUnit(String string, Vector vector) throws Exception {
        String string2 = "";
        string2 = string;
        for (int i = 0; i < vector.size(); ++i) {
            GenerateParser.Attribute attribute = (GenerateParser.Attribute)vector.elementAt(i);
            string2 = attribute.value.indexOf(",") != -1 ? string2 + "," + "\"" + attribute.value + "\"" : string2 + "," + attribute.value;
        }
        string2 = string2 + "\n";
        this.outWriter.write(string2, 0, string2.length());
    }
}

