/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.o3w;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.nri.rid.o3w.O3W_DocAnalyzer;
import jp.co.nri.rid.o3w.O3W_Xml;
import jp.co.nri.rid.o3w.O3W_XmlAnalyzer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class O3W_Importer
extends O3W_Xml {
    private static final String CREATOR_NAME = "O3W";
    private static final String PAGETYPE_SERVER = "server";
    private static final String PAGETYPE_DYNAMIC = "dynamic";
    private static final String LINKTYPE_SERVER = "server";
    private static final String INTENSITY_VIRTUAL = "Virtual";

    public int Import() throws Exception {
        int n = 0;
        DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
        O3W_DocAnalyzer o3W_DocAnalyzer = new O3W_DocAnalyzer();
        o3W_DocAnalyzer.analyzeSite((Document)((Object)docDocument));
        Vector vector = o3W_DocAnalyzer.getXmlFileList();
        O3W_XmlAnalyzer o3W_XmlAnalyzer = new O3W_XmlAnalyzer();
        n = o3W_XmlAnalyzer.parserO3WXml(vector, (Document)((Object)docDocument));
        return n;
    }

    public void importO3WXml(Document document, String string, Document document2) throws Exception {
        Element element;
        Element element2 = document.getDocumentElement();
        Element element3 = (Element)XPathAPI.selectSingleNode((Node)element2, (String)"ZoneUnit");
        if (!string.equals("")) {
            element = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = "ZoneUnit[@Name='" + stringTokenizer.nextToken() + "']";
                element3 = (Element)XPathAPI.selectSingleNode((Node)element3, (String)string2);
            }
        }
        if (element3 != null) {
            this.importZoneUnit(element3, document2.getDocumentElement());
            this.importPageUnit(string, element3, document2.getDocumentElement());
            element = (Element)XPathAPI.selectSingleNode((Node)element2, (String)"Link");
            this.importLinkUnit(element, document2.getDocumentElement());
        } else {
            ZDebug.trace("No Search ZoneUnit [" + string.replace(File.separatorChar, '/') + "]");
        }
    }

    private void importZoneUnit(Element element, Element element2) throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)element2, (String)"ZoneUnit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3 = (Element)nodeList.item(i);
            element.setAttribute("Top", element3.getAttribute("Top"));
            element.setAttribute("Error", element3.getAttribute("Error"));
            element.setAttribute("ControlId", element3.getAttribute("ControlId"));
            element.setAttribute("DefaultDSID", element3.getAttribute("DefaultDSID"));
        }
    }

    private void importPageUnit(String string, Element element, Element element2) throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)element2, (String)"PageUnit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string2 = element3.getAttribute("File");
            String string3 = "PageUnit[@File='" + this.createFilePath(string, string2) + "']";
            Element element4 = (Element)XPathAPI.selectSingleNode((Node)element, (String)string3);
            if (element4 == null) {
                this.createPageUnit(element, element3);
                continue;
            }
            this.updatePageUnit(element4, element3);
        }
    }

    private String createFilePath(String string, String string2) throws Exception {
        String string3 = string.length() != 0 ? string + "/" + string2 : string2;
        return string3;
    }

    private void createPageUnit(Element element, Element element2) throws Exception {
        String string = element2.getAttribute("PLTr");
        String string2 = element2.getAttribute("PageType");
        String string3 = element2.getAttribute("File");
        Element element3 = this.createSubElement(element, "PageUnit");
        element3.setAttribute("Creator", CREATOR_NAME);
        element3.setAttribute("Name", string3);
        element3.setAttribute("PageType", string2);
        if (!string.equals("")) {
            element3.setAttribute("Comment", string);
        }
        if (string2.equals("server")) {
            element3.setAttribute("Exist", "true");
        } else {
            element3.setAttribute("Exist", "false");
        }
    }

    private void updatePageUnit(Element element, Element element2) throws Exception {
        String string;
        String string2 = element2.getAttribute("PLTr");
        if (!string2.equals("")) {
            element.setAttribute("Comment", string2);
        }
        if ((string = element2.getAttribute("PageType")).equals("server")) {
            element.setAttribute("Exist", "true");
        }
    }

    private void importLinkUnit(Element element, Element element2) throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)element2, (String)"LinkUnit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string = element3.getAttribute("Connect0");
            String string2 = element3.getAttribute("Connect1");
            String string3 = element3.getAttribute("ProcRet");
            String string4 = element3.getAttribute("ActionId");
            if (string.equals("") || string2.equals("")) continue;
            this.createLinkUnit(element, string, string2, string3, string4);
        }
    }

    private void createLinkUnit(Element element, String string, String string2, String string3, String string4) throws Exception {
        Element element2 = this.existLinkUnit(element, string, string2);
        if (element2 == null) {
            element2 = this.createSubElement(element, "LinkUnit");
            element2.setAttribute("Creator", CREATOR_NAME);
            element2.setAttribute("Intensity", INTENSITY_VIRTUAL);
            element2.setAttribute("Exist", "true");
            element2.setAttribute("LinkType", "server");
            if (!string3.equals("")) {
                element2.setAttribute("Condition", string3);
            }
            if (!string4.equals("")) {
                element2.setAttribute("Comment", string4);
            }
            Element element3 = this.createSubElement(element2, "Connect0");
            element3.setAttribute("Key", string);
            Element element4 = this.createSubElement(element2, "Connect1");
            element4.setAttribute("Key", string2);
        } else {
            if (!string3.equals("")) {
                element2.setAttribute("Condition", string3);
            }
            if (!string4.equals("")) {
                element2.setAttribute("Comment", string4);
            }
            element2.setAttribute("LinkType", "server");
            element2.setAttribute("Intensity", INTENSITY_VIRTUAL);
            element2.setAttribute("Exist", "true");
        }
    }

    private String getPageUnitFileAttr(Element element, String string) throws Exception {
        String string2 = "";
        String string3 = "PageUnit[@File='" + string + "']";
        Element element2 = (Element)XPathAPI.selectSingleNode((Node)element, (String)string3);
        if (element2 != null) {
            string2 = element2.getAttribute("File");
        }
        return string2;
    }

    private Element existLinkUnit(Element element, String string, String string2) throws Exception {
        Element element2 = null;
        NodeList nodeList = XPathAPI.selectNodeList((Node)element, (String)"LinkUnit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3 = (Element)nodeList.item(i);
            Element element4 = (Element)XPathAPI.selectSingleNode((Node)element3, (String)"Connect0");
            Element element5 = (Element)XPathAPI.selectSingleNode((Node)element3, (String)"Connect1");
            String string3 = element4.getAttribute("Key");
            String string4 = element5.getAttribute("Key");
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            element2 = element3;
            break;
        }
        return element2;
    }
}

