/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZFileFilter;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.RMenu;
import jp.co.nri.rid.doc.RidElementPage;
import jp.co.nri.rid.export.ExportCsvDialog;
import jp.co.nri.rid.generator.GenerateCSV2;
import jp.co.nri.rid.search.SPColorListener;
import jp.co.nri.rid.search.SPColumnNames;
import jp.co.nri.rid.search.SPFieldHolderPanel;
import jp.co.nri.rid.search.SPHeaderListener;
import jp.co.nri.rid.search.SPResourceHash;
import jp.co.nri.rid.search.SPSpacerLabel;
import jp.co.nri.rid.search.SPTableColumnModel;
import jp.co.nri.rid.search.SPTableModel;
import jp.co.nri.rid.search.SPTableModelDetailInfo;
import jp.co.nri.rid.search.SPTableModelIsolated;
import jp.co.nri.rid.search.SPTableModelLarge;
import jp.co.nri.rid.search.SPTableModelStatistics;
import jp.co.nri.rid.search.SPTableModelUnused;
import jp.co.nri.rid.search.SPWindowAdapter;
import jp.co.nri.rid.table.LineNoRowHeader;
import jp.co.nri.rid.xml.elementBooster;

public class SearchPanel
extends JPanel {
    private static final String SCCSID = "@(#)SearchPanel.java";
    private static final String RCSID = "$Id: SearchPanel.java,v 1.56 2003-07-17 18:26:56+09 nsmr Exp $";
    static final boolean DEBUG = false;
    static final int BUTTON_WIDTH = 150;
    static final int BUTTON_HEIGHT = 30;
    static final int SPACER_HEIGHT = 20;
    static final int TABLE_ROW_HEIGHT = 24;
    static final int TABLE_WIDTH = 300;
    JTextField depthField;
    SPFieldHolderPanel depthPanel;
    JCheckBox changeIconColorCheckBox;
    JButton selectColorButton;
    JPanel changeIconColorPanel;
    JButton saveCSVButton;
    JPanel saveCSVPanel;
    private JTable resultTable;
    JScrollPane resultScrollPanel;
    JLabel targetLabel;
    JLabel statusLabel;
    static final int[] SEARCH_TARGETS = new int[]{0, 1, 2, 3, 4, 5, 6, 8};

    public SearchPanel() {
        SPColumnNames.init();
        SPResourceHash.init();
        this.initDepthPanel();
        this.initChangeIconColorPanel();
        this.initResultScrollPanel();
        JPanel[] jPanelArray = this.createSearchButtonPanels();
        this.initSaveCSVPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        for (int i = 0; i < jPanelArray.length; ++i) {
            SPSpacerLabel sPSpacerLabel = new SPSpacerLabel(1, 20);
            jPanel.add(jPanelArray[i]);
        }
        this.targetLabel = this.createStatusLabel();
        this.statusLabel = this.createStatusLabel();
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "West");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.targetLabel, "North");
        jPanel2.add((Component)this.resultScrollPanel, "Center");
        jPanel2.add((Component)this.statusLabel, "South");
        this.add((Component)jPanel2, "Center");
        this.init();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new SPWindowAdapter());
        jFrame.getContentPane().add((Component)new SearchPanel(), "Center");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void debugOut(String string) {
    }

    private JPanel[] createSearchButtonPanels() {
        JPanel[] jPanelArray = new JPanel[]{};
        if (SEARCH_TARGETS == null) {
            return jPanelArray;
        }
        if (SEARCH_TARGETS.length == 0) {
            return jPanelArray;
        }
        ButtonLsnr buttonLsnr = new ButtonLsnr();
        jPanelArray = new JPanel[SEARCH_TARGETS.length];
        for (int i = 0; i < SEARCH_TARGETS.length; ++i) {
            jPanelArray[i] = new JPanel(new BorderLayout());
            int n = SEARCH_TARGETS[i];
            JButton jButton = new JButton(SPTableModel.toString(n));
            jButton.setActionCommand(Integer.toString(n));
            jButton.addActionListener(buttonLsnr);
            jButton.setHorizontalAlignment(2);
            jPanelArray[i].add((Component)jButton, "Center");
            if (n == 0 && this.changeIconColorPanel != null) {
                jPanelArray[i].add((Component)this.changeIconColorPanel, "South");
            }
            if (n != 7 || this.depthPanel == null) continue;
            jPanelArray[i].add((Component)this.depthPanel, "South");
        }
        return jPanelArray;
    }

    private void initDepthPanel() {
        this.depthField = new JTextField("5", 5);
        this.depthField.setHorizontalAlignment(4);
        this.depthPanel = new SPFieldHolderPanel();
        this.depthPanel.addField("depth", this.depthField);
    }

    private void initChangeIconColorPanel() {
        this.changeIconColorCheckBox = new JCheckBox(SPResourceHash.getString("changeColor"));
        this.selectColorButton = new JButton(" ... ");
        this.selectColorButton.addActionListener(new SPColorListener());
        this.changeIconColorPanel = new JPanel();
        this.changeIconColorPanel.add(this.changeIconColorCheckBox);
        this.changeIconColorPanel.add(this.selectColorButton);
    }

    private void initSaveCSVPanel() {
        this.saveCSVButton = new JButton(SPResourceHash.getString("saveCSV"));
        this.saveCSVButton.addActionListener(new CsvButtonLsnr());
        this.saveCSVPanel = new JPanel(new BorderLayout());
        this.saveCSVPanel.add(this.saveCSVButton);
    }

    private void initResultScrollPanel() {
        this.resultTable = new JTable();
        this.resultTable.addMouseListener(new TableListener());
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.setRowHeight(24);
        this.resultTable.setPreferredScrollableViewportSize(new Dimension(300, 24));
        JTableHeader jTableHeader = this.resultTable.getTableHeader();
        jTableHeader.addMouseListener(new SPHeaderListener());
        this.resultScrollPanel = new JScrollPane(this.resultTable);
    }

    public JLabel createStatusLabel() {
        JLabel jLabel = new JLabel("a");
        jLabel.setBorder(new EmptyBorder(1, 2, 1, 1));
        Dimension dimension = jLabel.getPreferredSize();
        jLabel.setText("");
        jLabel.setPreferredSize(dimension);
        return jLabel;
    }

    public int init() {
        this.resultTable.setModel(new SPTableModel());
        this.saveCSVButton.setEnabled(false);
        this.changeIconColorCheckBox.setSelected(false);
        this.selectColorButton.setBackground(Color.gray);
        this.statusLabel.setText("");
        return 1;
    }

    public JComponent getTable() {
        return this.resultTable;
    }

    class TableListener
    implements MouseListener {
        TableListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SPTableModel sPTableModel;
            elementBooster elementBooster2;
            Object object = mouseEvent.getSource();
            if (!(object instanceof JTable)) {
                return;
            }
            JTable jTable = (JTable)object;
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            if (n >= 0 && n2 >= 0 && mouseEvent.isPopupTrigger() && (elementBooster2 = (sPTableModel = (SPTableModel)jTable.getModel()).getElementAt(n, n2)) != null && elementBooster2.element() instanceof RidElementPage) {
                RMenu.createContextMenu(mouseEvent, (RidElementPage)((Object)elementBooster2.element()));
            }
        }
    }

    class CsvButtonLsnr
    implements ActionListener {
        CsvButtonLsnr() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            TableModel tableModel = SearchPanel.this.resultTable.getModel();
            if (!(tableModel instanceof SPTableModel)) {
                return;
            }
            SPTableModel sPTableModel = (SPTableModel)tableModel;
            if (!sPTableModel.isImplemented()) {
                return;
            }
            String string = this.openFileDialog("csv", "CSV File", "rid.csv.dir");
            if (string == null) {
                return;
            }
            try {
                object = new GenerateCSV2();
                ((GenerateCSV2)object).generateCSV(SearchPanel.this.resultTable, string);
            }
            catch (Exception exception) {
                SearchPanel.this.debugOut("Write csv failed:" + exception.toString());
                exception.printStackTrace();
            }
            object = null;
            String string2 = ZInstance.prop().getProperty("pj.dir");
            if (string2 != null) {
                ZResource zResource = ZApp.getTheApp().getResource();
                object = string2 + File.separator + zResource.getString("rid.docs.dir");
                String string3 = string.substring(0, Math.min(string.length(), ((String)object).length()));
                if (string3.equalsIgnoreCase((String)object)) {
                    ExportCsvDialog exportCsvDialog = new ExportCsvDialog();
                    exportCsvDialog.show(string);
                }
            }
        }

        public String openFileDialog(String string, String string2, String string3) {
            IZApp iZApp = ZApp.getTheApp();
            if (iZApp == null) {
                SearchPanel.this.debugOut("Not running within Ridual application.");
                return null;
            }
            ZResource zResource = ZApp.getTheApp().getResource();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new ZFileFilter(new String(string), string2));
            String string4 = ZInstance.prop().getProperty("pj.dir");
            String string5 = zResource.getString("app.install.path");
            if (string4 != null) {
                string5 = string4 + File.separator + zResource.getString(string3);
            }
            jFileChooser.setCurrentDirectory(new File(string5));
            int n = jFileChooser.showSaveDialog(ZApp.getTheApp().getFrame());
            String string6 = null;
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    string6 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string6 = file.getAbsolutePath();
                }
                if (string6 != null && !string6.endsWith("." + string)) {
                    string6 = string6 + "." + string;
                }
            }
            ZApp.getTheApp().updateRecent(null);
            return string6;
        }
    }

    class ButtonLsnr
    implements ActionListener {
        ButtonLsnr() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = actionEvent.getActionCommand();
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            SPTableModel sPTableModel = n == 0 ? new SPTableModelIsolated(SearchPanel.this.changeIconColorCheckBox.isSelected(), SearchPanel.this.selectColorButton.getBackground()) : (n == 1 ? new SPTableModelLarge() : (n == 2 ? new SPTableModelUnused() : (n == 8 ? new SPTableModelStatistics() : (n == 3 ? new SPTableModelDetailInfo(n) : (n == 4 ? new SPTableModelDetailInfo(n) : (n == 5 ? new SPTableModelDetailInfo(n) : (n == 6 ? new SPTableModelDetailInfo(n) : new SPTableModel(n))))))));
            SearchPanel.this.targetLabel.setText(SPTableModel.toString(n));
            SearchPanel.this.statusLabel.setText(sPTableModel.getStatusString());
            SearchPanel.this.resultTable.setModel(sPTableModel);
            SearchPanel.this.resultTable.setColumnModel(new SPTableColumnModel(n));
            LineNoRowHeader lineNoRowHeader = new LineNoRowHeader(SearchPanel.this.resultTable);
            SearchPanel.this.resultScrollPanel.setRowHeaderView(lineNoRowHeader);
            SearchPanel.this.resultScrollPanel.getRowHeader().setPreferredSize(lineNoRowHeader.getPreferredSize());
            SearchPanel.this.resultScrollPanel.getVerticalScrollBar().setValue(0);
            SearchPanel.this.resultScrollPanel.getHorizontalScrollBar().setValue(0);
            if (sPTableModel.isImplemented()) {
                SearchPanel.this.saveCSVButton.setEnabled(true);
            } else {
                SearchPanel.this.saveCSVButton.setEnabled(false);
            }
        }
    }
}

