/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class WebFile {
    private File mySaveDir = null;
    private String myRootPath = null;
    private URL myURL = null;
    private File myFile = null;
    private String myHost = null;
    public String[] DefaultNames = new String[]{"index.html", "index.htm"};
    private static final char[] SKIPCHARS = new char[]{':', ';', '*', '\"', '<', '>', '|', '#'};

    public WebFile(String string) {
        this.myHost = string;
    }

    public void setSaveDir(File file) {
        this.mySaveDir = file;
    }

    public void setRootPath(String string) {
        this.myRootPath = string;
    }

    public URL getURL() {
        return this.myURL;
    }

    public boolean setURL(String string) throws MalformedURLException {
        return this.setURL(new URL(string));
    }

    public boolean setURL(URL uRL, String string) throws MalformedURLException {
        return this.setURL(new URL(uRL, string));
    }

    private boolean setURL(URL uRL) throws MalformedURLException {
        int n;
        String string = uRL.getPath();
        String string2 = uRL.getProtocol();
        String string3 = uRL.getHost();
        int n2 = uRL.getPort();
        try {
            string = new URI(string).normalize().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        if (string.startsWith("/../")) {
            return false;
        }
        if (!string3.toLowerCase().equals(this.myHost)) {
            return false;
        }
        if (null != this.myRootPath && !string.startsWith(this.myRootPath)) {
            return false;
        }
        for (int i = SKIPCHARS.length - 1; 0 <= i; --i) {
            if (0 > string.indexOf(SKIPCHARS[i])) continue;
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (n = stringTokenizer.countTokens() - 1; 0 <= n; --n) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith(" ")) {
                return false;
            }
            if (!string4.startsWith(".") || string4.equals("..") || string4.equals(".")) continue;
            return false;
        }
        if (string.endsWith("/")) {
            n = this.DefaultNames.length;
            for (int i = 0; i < n; ++i) {
                uRL = new URL(string2, string3, n2, string + this.DefaultNames[i]);
                try {
                    URLConnection uRLConnection = uRL.openConnection();
                    if (!(uRLConnection instanceof HttpURLConnection)) continue;
                    if (200 != ((HttpURLConnection)uRLConnection).getResponseCode()) {
                    }
                }
                catch (IOException iOException) {}
                continue;
                this.myURL = uRL;
                return true;
            }
            this.myURL = null;
        } else {
            this.myURL = new URL(string2, string3, n2, string);
        }
        return true;
    }

    public int save() throws IOException {
        File file = this.myFile.getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        return this.save(this.myFile);
    }

    public File fusionPath() {
        String string = this.myURL.getPath();
        if (null != this.myRootPath) {
            string = string.substring(this.myRootPath.length());
        }
        this.myFile = new File(this.mySaveDir, string);
        return this.myFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int save(File file) throws IOException {
        int n = 4096;
        byte[] byArray = new byte[n];
        URLConnection uRLConnection = this.myURL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("HTTP\u4ee5\u5916\u306e\u63a5\u7d9a");
        }
        int n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
        if (200 != n2) {
            return n2;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            int n3;
            while (0 <= (n3 = bufferedInputStream.read(byArray, 0, n))) {
                bufferedOutputStream.write(byArray, 0, n3);
            }
        }
        finally {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        return n2;
    }
}

