/*
 * @(#)ZGroupToggleButton.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.action;

import java.awt.event.ActionEvent;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

import javax.swing.JToggleButton;

import java.util.Enumeration;
import java.util.Hashtable; 
import java.util.Vector;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ui.UIFactory;
/**
 * O[v toggledButton ̃bsONXłB
 * @author  N
 * @version 1.01 2001/01/07
 */
public class ZGroupToggleButton {
	/**
	 * B̃RXgN^łB
	 * @param app		AvP[VNX
	 * @param ui			UIt@Ng[
	 * @param szActions	ANV
	 */
	public ZGroupToggleButton(IZApp app,UIFactory ui,String[] szActions) {
	mApp = app ;

	// ANVi[̈
	mActions = new Hashtable();

	for ( int nIndex=0; nIndex<szActions.length; nIndex++ ) {
		String szAct = szActions[nIndex];
		JToggleButton btn = (JToggleButton)ui.getToolItem(szAct);

		if ( btn != null ) {
			mActions.put(szAct,new ZGroupToggleButtonAction(app,btn,szAct));
		} else {
			System.out.println("Button not found:"+szAct);
		}
	}

	// ftHgԂ̐ݒ
	mDefault = szActions[0] ;
	setDefault();
	}

	/**
	 * {^ԂftHgɖ߂
	 */
	public void setDefault() {
	Enumeration elm = mActions.elements();
	while ( elm.hasMoreElements() ) {
		ZToggleButtonAction act = (ZToggleButtonAction)elm.nextElement();
		act.off();
	}

	setState(mDefault);
	}

	/**
	 * {^ԂZbg
	 * @param szNew IĂ{^̃ANV
	 */
	public void setState( String szNew ) {
	// ݏԂ̉
	String szOld = mState;
	if ( mState != null ) {
		ZToggleButtonAction act = getAction( mState ) ;
		if ( act != null ) {
			act.off();
		}
	}

	// VԂ̐ݒ
	mState = szNew ;
	if ( mState != null ) {
		ZToggleButtonAction act = getAction( mState ) ;
		if ( act != null ) {
			act.on();
		}
	}

	// Cxg̒ʒm
	PropertyChangeEvent evt = new PropertyChangeEvent(this,"groupbar",szOld,mState);
	firePropertyChanged( evt );
	}

	/**
	 * {^Ԃ擾
	 * @return IĂ{^̃ANV
	 */
	public String getState() {
	return ( mState );
	}

	/**
	 * ANV擾
	 * @param szAction ANV
	 * @return ANV
	 */
	protected ZToggleButtonAction getAction ( String szAction ) {
	return ( (ZToggleButtonAction) mActions.get(szAction) );
	}

	//## vpeB`FWXi[ ###################################
	/**
     * ԕύXXi[̓o^
     * @param lis Xi[
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
	mListener.add(listener);
	}

	/**
     * ԕύXXi[̍폜
     * @param lis Xi[
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
	mListener.remove(listener);
	}

	/**
     * ԕύX̒ʒm
	 * @param evt Cvbg{bNXCxg
	 */
	public void firePropertyChanged( PropertyChangeEvent evt ) {
	if ( mLock ) {
		return;
	}
	mLock = true;
	Enumeration elm = mListener.elements();
	while ( elm.hasMoreElements() ) {
		PropertyChangeListener listener = (PropertyChangeListener)elm.nextElement();
		listener.propertyChange( evt );
	}
	mLock = false;
	}

	//## TuNX ###################################################
	/**
	 * ToggleButtonpANV
	 */
	public class ZGroupToggleButtonAction extends ZToggleButtonAction {
	/**
	 * B̃RXgN^łB
	 * @param app      AvP[VNX
	 * @param btn      {^
	 * @param szAction ANV
	 */
	public ZGroupToggleButtonAction(IZApp app, JToggleButton btn,
									String szAction) {
    super(app,btn,szAction);
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {
	setState( getActionName() );
	}
	}

	//## Agr[g ###############################################
    /**
     * AvP[V
     */
	protected IZApp		mApp	= null ;

    /**
     * ANVXg
     */
	protected Hashtable	mActions= null ;

    /**
     * ftHg{^̃ANV
     */
	protected String 	mDefault= null ;

    /**
     * ݑIĂ{^̃ANV
     */
	protected String 	mState  = null ;

    /**
     * bN
     * ̓{bNX̕ύXɂAēxf[^ύXꂽꍇA
     * CxgĔ\̂ŁȀꍇ̓CxgʒmȂ悤
     * 邽߂̃tO
     */
	protected boolean 	mLock		= false;

    /**
     * ԕύXXi[Xg
     */
	protected Vector	mListener	= new Vector();
}
