/*
 * @(#)DocBar.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 *
 * Document Toolbar
 */
package jp.co.iti.fagot.doc;

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JToolBar;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JRadioButton;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
/**
 * Documentɓ\tElement`Toolbar<br>
 * 
 * Install Dir\\Conf\\DocbarfBNgɒ`ĂElement쐬pc[o[
 * 쐬BDocbarfBNgɂ͎̃t@CQi[Ă
 * <ui>
 * <li>ʃj[pc[`t@C(docbar.properties)
 * <li>ꂼ̃c[ɑΉgifC[W
 * </ul>
 *
 * `t@Cɂ͎̏񂪊i[Ă
 * <ui>
 * <li>pl
 *   <ui>
 *   <li>pl(panel.count)
 *   <li>pl̃c[(panel.<i>number</i>)BL̈Ӗ͎̂Ƃ
 *       <center><table>
 *         <tr><th>L</th><th>Ӗ</th></tr>
 *         <tr><td>()</td><td>c[̃O[v(z)</td></tr>
 *         <tr><td>+</td><td>{^gO{^ɐݒ</td></tr>
 *       </table></center>
 *   </ul>
 * <li>c[`
 *   <ui>
 *   <li>c[pgifC[W(<i>tool name</i>.image)
 *   <li>{^ꂽƂ̃ANV(<i>tool name</i>.action)
 *   <li>c[`bv(<i>tool name</i>.tooltip)
 *   </ul>
 * </ul>
 * 
 * @author  N
 * @version 1.01 2002/10/23
 */
public class DocBar extends JToolBar{

	/**
	 * RXgN^
	 */
    public DocBar() {
	super();
	}

	/**
	 * ANeBuȃpl̐ؑ
	 * @param nPanel plԍ
	 */
    public void setPanel( int nPanel ) {
	// USč폜
	removeAll();
	mToolItems	 = new Hashtable();
	mCurrentButton = null;

	// vpeB̓Ǎ
	ZProperties prop = DocManager.loadProperty( DocManager.DOC_BAR );
	String[] szToolKeys=ZString.tokenize(prop.getProperty("panel."+nPanel));
	loadTools(prop,szToolKeys);

	// ɋ󔒃R|[lgݒ肵ďl
//	add(Box.createVerticalGlue());

	// ĕ`
	validate();
	repaint();
	}

	/**
	 * c[ڂ擾܂B
	 * {^ȊOUIR|[lgύXꍇɎgp܂B
	 * @param szKey  ږ
	 */
	public Component getToolItem(String szKey) {
	return (Component) mToolItems.get(szKey);
	}

	//## c[̍쐬 #################################################
	/**
	 * c[̓Ǎ
	 * @param prop       vpeBt@C
	 * @param szToolKeys c[ڂ̔z
	 */
	public void loadTools( Properties prop, String[] szToolKeys ){

	JPanel tmpPanel = null;
	for (int nIndex = 0; nIndex < szToolKeys.length; nIndex++) {
		Component cmp = null;
	    if (szToolKeys[nIndex].equals("-")) {
//			cmp = Box.createVerticalStrut(5);
			cmp = Box.createHorizontalStrut(5);
//			cmp = new Box.Filler(new Dimension(0,0), new Dimension(0,0), 
//			  new Dimension(0, 1000000));
	    } else if (szToolKeys[nIndex].equals("(")) {
			tmpPanel = new JPanel();
			tmpPanel.setAlignmentX(0.0f);
			tmpPanel.setLayout( new BoxLayout( tmpPanel, BoxLayout.X_AXIS ) );
	    } else if (szToolKeys[nIndex].equals(")")) {
			cmp = tmpPanel;
			tmpPanel = null;
	    } else {
			// i̍쐬
			cmp = createTool(prop, szToolKeys[nIndex]);
			mToolItems.put(szToolKeys[nIndex], cmp);

			// ftHg{^̓o^
			if ( mCurrentButton == null && cmp instanceof JToggleButton &&
				!(cmp instanceof JRadioButton) ) {
				mCurrentButton = (JToggleButton)cmp;
				mCurrentButton.setSelected(true);
				ZInstance.prop().put(ACTION,szToolKeys[nIndex].substring(1));
			}

			// Tuplɓ\tꍇ
			if ( cmp == null ) {
				ZDebug.err("Create tool failed.("+szToolKeys[nIndex]+")");
			} else if ( tmpPanel != null ) {
				tmpPanel.add(cmp);
				cmp = null ;
			}
		}
	    if ( cmp != null) {
			add(cmp);
//			ZDebug.trace(cmp.toString());
		}
	}
	}

	/**
	 * c[ڂ쐬܂B
	 * @param prop      vpeBt@C
	 * @param szToolKey c[
	 */
	public Component createTool(Properties prop, String szToolKey) {
	String szToolClass = prop.getProperty( szToolKey + SFX_CLASS );

	Component cmp = null;
	if ( szToolClass == null ) {
		cmp = createButton(prop, szToolKey);
	} else if ( szToolClass.equals("Label") ){
		cmp = createLabel(prop, szToolKey);
	} else {
		// NX̎擾
		Class cClass;
		try {
			cClass = Class.forName( szToolClass );
		} catch ( ClassNotFoundException cn ) {
			ZDebug.err ( "ClassNotFound:" + szToolClass ) ;
			return null ;
		}

		// CX^X
		Object obj ;
		try {
			obj = cClass.newInstance();
		} catch ( InstantiationException ie ) {
			ZDebug.err ( "Class newInstance Failed:" + szToolClass ) ;
			return null ;
		} catch ( IllegalAccessException ia ) {
			ZDebug.err ( "Class newInstance Failed:" + szToolClass ) ;
			return null ;
		}

		if ( ! ( obj instanceof Component ) ) {
			ZDebug.err ( "Class is not instanceof Compenent:" + szToolClass ) ;
			return null ;
		}
		cmp = (Component) obj;
		initializeComponent( prop, szToolKey, cmp );
	}
	return cmp ;
	}

	/**
	 * c[{^쐬܂B
	 * @param prop      vpeBt@C
	 * @param szToolKey c[
	 */
	protected Component createButton(Properties prop, String szToolKey) {
	// gO{^`FbN
	boolean bToggled = false ;
	if ( szToolKey.startsWith(TOGGLED) ) {
		bToggled = true ;
		szToolKey = szToolKey.substring(1);
	}

	// C[W̎擾
	String szImage = DocManager.getConfigFile( DocManager.DOC_BAR, 
						prop.getProperty( szToolKey + SFX_IMAGE ) );
    AbstractButton btn ;
	ImageIcon img = new ImageIcon(szImage);
	if ( img == null ) {
		ZDebug.err( "Resouce not found:"+szImage );
		return null;
	}

	// {^̍쐬
	if ( bToggled ) {
		btn = new JToggleButton();
	} else {
		btn = new JButton();
	}
	btn.setAlignmentY(0.5f);
    btn.setRequestFocusEnabled(false);
    btn.setMargin(new Insets(1,1,1,1));

	btn.setText(null);
	btn.setIcon(img);

	// c[`bv̐ݒ
	String szTip = prop.getProperty( szToolKey + SFX_TOOLTIP );
	if (szTip == null) {
		szTip = szToolKey;
	}
	if (szTip != null) {
	    btn.setToolTipText(szTip);
	}
	initializeComponent( prop, szToolKey, btn );
    return btn;
	}

	/**
	 * x쐬܂B
	 * @param prop      vpeBt@C
	 * @param szToolKey c[
	 */

	protected Component createLabel(Properties prop, String szToolKey) {
	// C[W̎擾
	String szImage = DocManager.getConfigFile( DocManager.DOC_BAR, 
						prop.getProperty( szToolKey + SFX_IMAGE ) );
	ImageIcon img = new ImageIcon(szImage);
	if ( img == null ) {
		ZDebug.err( "Resouce not found:"+szImage );
		return null;
	}

	JLabel label = new JLabel();
	label.setAlignmentY(0.5f);
//    label.setRequestFocusEnabled(false);
//    label.setMargin(new Insets(1,1,1,1));

	label.setText(null);
	label.setIcon(img);

	// c[`bv̐ݒ
	String szTip = prop.getProperty( szToolKey + SFX_TOOLTIP );
	if (szTip == null) {
		szTip = szToolKey;
	}
	if (szTip != null) {
	    label.setToolTipText(szTip);
	}

	Dimension dim = label.getPreferredSize();
	dim.width = 69;
	label.setPreferredSize(dim);
	label.setMinimumSize(dim);
//    ((JComboBox)cmp).setAlignmentX(0.0f);

//	initializeComponent( prop, szToolKey, btn );
    return label;
	}

	/**
	 * R|[lg̏
	 * @param prop      vpeBt@C
	 * @param szToolKey c[
	 * @param cmp R|[lg
	 */
	protected void initializeComponent(Properties prop, String szToolKey,Component cmp) {
	// XNvg̐ݒ
	String szScript = prop.getProperty( szToolKey + SFX_SCRIPT );
	if ( szScript == null ) {
		// gO{^ȂԕύXۑ
		if ( cmp instanceof JToggleButton ) {
			Action act = new AbstractAction( szToolKey ){
			public void actionPerformed(ActionEvent evt) {
				// {^Ԃ̃NA
				if ( mCurrentButton != null ) {
					mCurrentButton.setSelected(false);
				}

				// {^Ԃ̐ݒ
				JToggleButton myButton = (JToggleButton)evt.getSource();
				myButton.setSelected(true);
				mCurrentButton = myButton;
//				ZDebug.trace("on:"+getValue(Action.NAME));
				ZInstance.prop().put(ACTION,getValue(Action.NAME));
			}
			};
			((JToggleButton)cmp).addActionListener(act);

		// R{{bNXȂTCYύX
		} else if ( cmp instanceof JComboBox ) {
			Dimension dim = cmp.getPreferredSize();
			dim.width = 69;
			((JComboBox)cmp).setPreferredSize(dim);
			((JComboBox)cmp).setMinimumSize(dim);
		    ((JComboBox)cmp).setAlignmentX(0.0f);
		}
	} else {
		// R|[lg̏
		Object[] iniObjs = { cmp };
		DocManager.invokeDocBarFunction(szToolKey,"initialize",iniObjs);

		// ANVXi[̓o^
		if ( cmp instanceof JComboBox ) {
			Action act = new AbstractAction( szToolKey ){
			public void actionPerformed(ActionEvent evt) {
				String szName = (String)getValue(Action.NAME);
				Object[] actObjs = { evt };
				DocManager.invokeDocBarFunction(szName,"actionPerformed",actObjs);
			}
			};
			((JComboBox)cmp).addActionListener(act);

		// ANVXi[̓o^
		} else if ( cmp instanceof JToggleButton ) {
			if ( szToolKey.startsWith("svg_") ) {
				/**
				 ** SVGn̓ꏈ
				 **/
				Action act = new AbstractAction( szToolKey ){
				public void actionPerformed(ActionEvent evt) {
					// {^Ԃ̃NA
					if ( mCurrentButton != null ) {
						mCurrentButton.setSelected(false);
					}

					// {^Ԃ̐ݒ
					JToggleButton myButton = (JToggleButton)evt.getSource();
					myButton.setSelected(true);
					mCurrentButton = myButton;
//					ZDebug.trace("on:"+getValue(Action.NAME));
					ZInstance.prop().put(ACTION,getValue(Action.NAME));

					String szName = (String)getValue(Action.NAME);
					Object[] actObjs = { new DocBarEvent(evt,szName) };
					DocManager.invokeDocBarFunction(szName,"actionPerformed",actObjs);

				}
				};
				((JToggleButton)cmp).addActionListener(act);

			} else {
				// ̑̃gO{^
				Action act = new AbstractAction( szToolKey ){
				public void actionPerformed(ActionEvent evt) {
					String szName = (String)getValue(Action.NAME);
					Object[] actObjs = { evt };
					DocManager.invokeDocBarFunction(szName,"actionPerformed",actObjs);
				}
				};
				((JToggleButton)cmp).addActionListener(act);
			}
		}
	}
	}
	
	static private Hashtable icons = new Hashtable();
	
	static public ImageIcon getDocBarIcon(String name){
		ImageIcon icon = (ImageIcon)icons.get(name);
		if(null == icon){
			icon = new ImageIcon( DocManager.getConfigFile(DocManager.DOC_BAR, name) );
			icons.put(name, icon);
		}
		
		return icon;
	}

	//## Agr[g ###############################################
    /**
	 * Jg{^
     */
    protected JToggleButton mCurrentButton = null;

    /**
	 * c[nbV}bv
     */
    protected Hashtable	mToolItems	 = new Hashtable();

    /**
	 * \[X擾pFC[W
     */
    public static final String SFX_IMAGE   = ".image";

    /**
	 * \[X擾pFXNvg
     */
    public static final String SFX_SCRIPT  = ".script";

    /**
	 * \[X擾pFc[`bv
     */
    public static final String SFX_TOOLTIP = ".tooltip";

    /**
	 * \[X擾pFNX
     */
    public static final String SFX_CLASS   = ".class";

    /**
	 * \[X擾pFgO{^
     */
	public static final String TOGGLED		= "+";

    /**
	 * CX^X}l[Wo^L[
     */
	public  static final String ACTION		= "docbar.action";

    /**
	 * pr̃{^L[FI
     */
	public  static final String SELECT_ACTION	= "select";

    /**
	 * pr̃{^L[FÂ݈ړ
     */
	public  static final String MOVE_ACTION		= "move";

    /**
	 * pr̃{^L[Fgk
     */
	public  static final String ZOOM_ACTION		= "zoom";
}
