/*
 * @(#)DocManager.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 *
 * Document Manager Super class
 */
package jp.co.iti.fagot.doc;

import java.io.File;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.IOException;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Locale;

import org.w3c.dom.Element;

import org.xml.sax.InputSource;

import org.apache.xerces.parsers.DOMParser;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.ui.UIFactory;

import jp.co.iti.fagot.doc.DefaultAction;

import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZScript;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
/**
 * DocpbP[W̃}l[W
 *
 * JX^}CYڑSʂǗ
 *
 * @author  N
 * @version 1.01 2002/10/23
 */
public class DocManager {

	//## CX^X̍쐬 ###########################################
	/**
	 * AvP[VCX^X̍쐬
	 */
	static public IApplication createApplication() {
	return (IApplication)createInstance(APPLICATION,"main");
	}

	/**
	 * hLgCX^X̍쐬
	 * @param szKey hLgʎq
	 */
	static public IDocument createDocument(String szKey) {
	return (IDocument)createInstance(DOCUMENT,szKey);
	}

	/**
	 * GgCX^X̍쐬
	 * XElementNS̊{NXɂ̓ftHghLgȂ߁AconstructElement
	 * ŃGg
	 *
	 * @param szKey hLgʎq
	 */
	static public IElement createElement(DocDocument doc,String ns, String name) {
	IElement elm = (IElement)createInstance(ELEMENT,name);
	if ( elm != null ) {
		elm.constructElement(doc,ns,name);
	}
	return elm;
	}

	/**
	 * ANVCX^X̍쐬
	 */
	static public DefaultAction[] createAction() {
	ZProperties prop = loadProperty(APPLICATION);
	String[] szActions = ZString.tokenize(prop.getProperty("actions"));
	DefaultAction[] act = new DefaultAction[szActions.length];
	for ( int nIndex=0 ; nIndex<szActions.length ; nIndex++ ) {
		act[nIndex] = (DefaultAction)createInstance(APPLICATION,szActions[nIndex]);
		act[nIndex].setApp(ZApp.getTheApp());
		act[nIndex].setActionName(szActions[nIndex]);
	}
	return act;
	}

	/**
	 * CX^X̍쐬
	 * @param szConfig RtBO[V
	 * @param szKey    NX
	 */
	static protected Object createInstance(String szConfig,String szKey) {
	// vpeBt@CNX̒o
	String szClass = getClassName(szConfig,szKey);
	if ( szClass != null ) {
		try {
//			ZDebug.trace(szClass);
			Object obj = Class.forName(szClass);
			if ( obj instanceof Class ) {
				return ((Class)obj).newInstance();
			}
			return null;
		} catch ( Throwable t ) {
			ZDebug.trace("Class not found:"+szClass);
			t.printStackTrace();
		}
	}
	return null;
	}

	/**
	 * NX̎擾
	 * hLgNX̃[hɃNXKvȂ̂ŁApublic
	 * @param szConfig RtBO[V
	 * @param szKey hLgʎq
	 */
	static public String getClassName(String szConfig,String szKey) {
	// vpeBt@CNX̒o
	ZProperties prop = loadProperty( szConfig ) ;
	String szPackage = prop.getProperty( szKey+".package" );
	String szClass   = prop.getProperty( szKey+".class" );
	if ( szPackage != null && szClass != null ) {
		return szPackage+"."+szClass;
	}
	return null;
	}

	//## |bvAbvj[ ##########################################
	/**
	 * ReLXgj[쐬邽߂UIFactory𐶐܂B
	 * @param szConfig RtBO[V
	 */
	static public UIFactory createUIFactory(String szConfig) {
	UIFactory ui = 	(UIFactory)mFactories.get(szConfig);
	if ( ui == null ) {
		ui = new UIFactory(
						ZApp.getTheApp(),
						new ZResource(loadProperty(szConfig)));
		mFactories.put( szConfig, ui );
	}
	return ui;
	}

	//## vpeBCAEg ##########################################
	/**
	 * vpeBCAEgxmlǂݍ݂܂
	 * @param szTag Gg^O
	 */
	static public Element createElementLayout(String szTag) {
	Element elm = (Element)mLayouts.get(szTag);
	if ( elm == null ) {
		ZProperties prop = loadProperty( ELEMENT ) ;
		String szLayout = prop.getProperty( szTag+".layout" );
		try {
			DOMParser parser = new DOMParser();
			parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd",false);
//			ZDebug.trace("Open:"+getConfigFile(ELEMENT,szLayout));
//			InputSource in = new InputSource(getConfigFile(ELEMENT,szLayout));
			InputSource in = createInputSource(getConfigFile(ELEMENT,szLayout));
			parser.parse(in);
			elm = parser.getDocument().getDocumentElement();
		} catch ( Throwable t ) {
			ZDebug.err("FileOpen failed:"+getConfigFile(ELEMENT,szLayout));
			ZDebug.err("    "+t.toString());
			t.printStackTrace();
		}
		mLayouts.put( szTag, elm );
	}
	return elm;
	}

	/**
	 * XMLǂݍݗpInputSource쐬܂
	 * @param szFile t@C
	 */
	static public InputSource createInputSource(String szFile) {
	InputSource in = null;
	try {
		FileInputStream     fis = new FileInputStream(szFile);
		BufferedInputStream bis = new BufferedInputStream(fis);
		in = new InputSource(bis);
	} catch ( Throwable t ) {
		ZDebug.err("FileOpen failed:"+szFile);
		ZDebug.err("    "+t.toString());
//		t.printStackTrace();
	}
	return in;
	}

	//## }bvpR}ht@CnbV ##############################
	/**
	 * }bvpR}hxmlǂݍ݂܂
	 * @param szFile t@CtpX
	 */
	static public Element createMapElement(String szFile) {
	Element elm = (Element)mMaps.get(szFile);
	if ( elm == null ) {
		try {
			DOMParser parser = new DOMParser();
			parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd",false);
//			ZDebug.trace("Open:"+szFile);
//			InputSource in = new InputSource(szFile);
			InputSource in = createInputSource(szFile);
			parser.parse(in);
			elm = parser.getDocument().getDocumentElement();
		} catch ( Throwable t ) {
			ZDebug.err("FileOpen failed:"+szFile);
			ZDebug.err("    "+t.toString());
			t.printStackTrace();
		}
		mMaps.put( szFile, elm );
	}
	return elm;
	}

	/**
	 * }bvpR}ht@Cǂݍ݂܂
	 * @param szFile t@CtpX
	 */
	static public Reader createTextFile(String szFile) {
	String text = (String)mTexts.get(szFile);
	if ( text == null ) {
		StringBuffer sb = new StringBuffer();
		try {
			FileInputStream fis = new FileInputStream(szFile);
			byte buf[] = new byte[4096];
			int len;
			while ((len = fis.read(buf)) != -1) {
				sb.append( new String( buf,0,len ) );
			}
		} catch ( Throwable t ) {
			ZDebug.err("FileOpen failed:"+szFile);
			ZDebug.err("    "+t.toString());
			t.printStackTrace();
		}
		mTexts.put( szFile, sb.toString() );
	}
	return new StringReader(text);
	}

	//## XNvg ###################################################
	/**
	 * hLgo[\bȟĂяo
	 * @param szKey  ANVL[
	 * @param szFunc \bh
	 * @param params p[^
	 */
	static public Object invokeDocBarFunction(String szKey, String szFunc, Object[] params ) {
	ZProperties prop = loadProperty( DOC_BAR );
	String szScript = prop.getProperty( szKey + DocBar.SFX_SCRIPT );
	String szFile   = getConfigFile( DOC_BAR, szScript );
	return invokeFunction(szFile,szFunc,params);
	}

	/**
	 * Gg\bȟĂяo(Elementw)
	 * @param szScript XNvg
	 * @param szFunc   \bh
	 * @param params   p[^
	 */
	static private Object invokeFunction( String szScript, String szFunc, Object[] params ) {
	ZScript mgr = (ZScript)mScripts.get(szScript);
	if ( mgr == null ) {
		mgr = new ZScript();
		mgr.loadScript(szScript);
		mScripts.put( szScript, mgr );
	}
	return mgr.invoke(szFunc,params);
	}

	//## vpeB ###################################################
	/**
	 * fBNg̎擾
	 * @param szPath pX
	 */
	static public String getConfigDirectory( String szPath ) {
	ZResource res   = ZApp.getTheApp().getResource();
	String install = res.getString("app.install.path");
	String config  = res.getString("app.config.dir");
//	ZDebug.trace("ins:"+install+" conf:"+config+" path:"+szPath);
	return install+File.separator+config+File.separator+szPath;
	}

	/**
	 * RtBO[Vt@C̎擾
	 * @param szPath pX
	 * @param szFile t@C
	 */
	static public String getConfigFile( String szPath, String szFile ) {
	return getConfigDirectory( szPath ) + File.separator + szFile ;
	}

	/**
	 * vpeB̓ǂݍ
	 * @param szPath pX
	 */
	static public ZProperties loadProperty(String szPath ) {
	return loadProperty( szPath, szPath );
	}

	/**
	 * vpeB̓ǂݍ
	 * ftHg̃vpeBǂݍ񂾌AftHgP[̃vpeB㏑
	 * ftHgP[̃t@C݂ȂĂ悢
	 * @param szPath pX
	 * @param szFile t@C
	 */
	static public ZProperties loadProperty(String szPath, String szFile ) {
	String szConf = getConfigFile( szPath, szFile );
	String szProp = szConf + ".properties" ;
	ZProperties prop = (ZProperties)mProperties.get(szProp);
	if ( prop == null ) {
		prop = new ZProperties();
		try {
			FileInputStream inStream = new FileInputStream(szProp);
			prop.load(inStream);
			inStream.close();
			
			// ftHgP[̃vpeBǂݍݏ
			String localeSuffix = Locale.getDefault().getLanguage();
			if ( localeSuffix.length() > 0 ) {
				try {
					ZProperties propLocal = new ZProperties();
					String szLocal = szConf + "_" + localeSuffix + ".properties" ;
					inStream = new FileInputStream(szLocal);
					propLocal.load(inStream);
					inStream.close();
					
					prop.putAll( propLocal );
				} catch (IOException io) {
					// ftHgP[̃vpeBǂݍ݂ɎsĂȂ
				}
			}
			
			mProperties.put(szProp,prop);
		} catch (IOException io) {
			ZDebug.err("Custom Properties load failed:("+szProp+")"+io);
		}
	}
	return prop;
	}

	//## Agr[g ###############################################
	/**
	 * vpeBnbVe[u
	 */
	protected static Hashtable mProperties = new Hashtable();

	/**
	 * XNvgnbVe[u
	 */
	protected static Hashtable mScripts = new Hashtable();

	/**
	 * UIt@NgnbVe[u
	 */
	protected static Hashtable mFactories = new Hashtable();

	/**
	 * vpeBCAEgnbVe[u
	 */
	protected static Hashtable mLayouts = new Hashtable();

	/**
	 * }bvR}hnbVe[u
	 */
	protected static Hashtable mMaps = new Hashtable();

	/**
	 * }bveLXgnbVe[u
	 */
	protected static Hashtable mTexts = new Hashtable();

	//## e:config ##############################################
	/**
	 * panelfBNg
	 */
	public static final String APPLICATION	= "application";

	/**
	 * panelfBNg
	 */
	public static final String PANEL	= "panel";

	/**
	 * documentfBNg
	 */
	public static final String DOCUMENT	= "document";

	/**
	 * elementfBNg
	 */
	public static final String ELEMENT	= "element";

	/**
	 * docbarfBNg
	*/
	public static final String DOC_BAR	= "docbar";

	//## e:method ##############################################
	/**
	 * AvP[V\bh
	 */
	public static final String UPDATE_DOCUMENT	= "updateDocument";

	/**
	 * pl\bh
	 */
	public static final String CREATE_PANEL		= "createPanel";

	/**
	 * Document\bh
	 */
	public static final String GET_BACKGROUND	= "getBackground";

	/**
	 * Element\bhF
	 */
	public static final String CREATE_ELEMENT	= "create";

	/**
	 * Element\bhFqbg[h
	 */
	public static final String GET_HIT_MODE		= "getHitMode";

}
