/*
 * @(#)FInteger.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.fob;

import java.lang.Integer;
import java.lang.NumberFormatException;
/**
 * Integer
 * @author  gG
 * @version 1.01 2001/01/07
 */
public class FInteger extends FElement {

	/**
	 * RXgN^
	 */
	public FInteger() {
	super();
	}

	/**
	 * RXgN^
	 */
	public FInteger(int data) {
	super( new Integer(data) );
	}

	/**
	 * RXgN^
	 */
	public FInteger(Integer data) {
	super(data);
	}

	/**
	 * RXgN^
	 */
	public FInteger(FInteger data) {
	super();
	set(data);
	}

	/**
	 * l̎擾
	 */
	public int get() {
	return ( (isNull())?0:((Integer)getData()).intValue() ) ;
	}

	/**
	 * l̐ݒ
	 */
	public void set(int data) {
	setData( new Integer(data) ) ;
	}

	/**
	 * l̐ݒ
	 */
	public void set( FInteger data) {
	setData( data.getData() ) ;
	}

	/**
	 * l̃CNg
	 */
	public void increment() {
		set(get()+1);
	}

	/**
	 * l̃fNg
	 */
	public void decrement() {
		set(get()-1);
	}

	/**
	 * l̃`FbN
	 * @param szValue `FbN镶
	 */
	static public boolean isInteger(String szValue) {
		int n = 0 ;
		if ( szValue == null ) {
			return false;
		}
		try {
			n = new Integer(szValue).intValue();
		} catch ( NumberFormatException nf ) {
			return false;
		}
		return true;
	}

	/**
	 * l̎擾
	 * @param szValue `FbN镶
	 */
	static public int stringToInt(String szValue) {
		int n = 0 ;
		if ( szValue == null ) {
			return 0;
		}
		try {
			n = new Integer(szValue).intValue();
		} catch ( NumberFormatException nf ) {
			return 0;
		}
		return n;
	}

	//## CLONE ########################################################
	/**
	 * CX^X̍쐬
	 * eNXɂăCX^X𐶐
	 * zNXiуCX^XȂNXjłnullԂ
	 */
	public Object createClone() {
	return new FInteger();
	}
}
