/*
 * @(#)FobManager.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.fob;

import java.util.Vector;
import java.util.Stack;
import java.util.Enumeration;

import jp.co.iti.fagot.util.ZDebug;
/**
 * Fob}l[W
 *
 * FElement̊ǗNXB
 * <ul>
 * <li>beginTransaction,commit,rollbackȂǃgUNV`
 * <li>gUNVɏ]Aundo,redo`
 * <li>undo,redoɂf[^̕ύX擾郊Xi[Ǘ
 * <li>undo,redoɂf[^̕ύXXi[ɒʒm
 * </ul>
 *
 * @author  gG
 * @version 1.01 2001/01/07
 */

public class FobManager {

	/**
	 * fobOtO
	 */
	protected boolean bTrace = false;

	/**
	 * RXgN^
	 */
	public FobManager(){
	reset();
	}

	//## XVԂ̎擾 ###############################################
	/**
	 * XVԂ̏
	 * hLgۑꂽƂɍXVԂ邽߂ɌĂяo܂
	 */
	public void setModified() {
	mIsModified = false ;
	}

	/**
	 * XVԂ̎擾
	 */
	public boolean isModified() {
	return mIsModified ;
	}


	//## gUNVǗ #########################################
	/**
	 * undoX^bÑNA
	 */
	public void reset() {
	mUndoTran = null;
	mUndo = new Stack();
	mRedo = new Stack();
	}

	/**
	 * gUNVH
	 */
	public boolean isTransaction() {
	return ( mUndoTran != null );
	}

//	private String mPrevStack = null;
	/**
	 * gUNV̊Jn
	 */
	public void beginTransaction() {
	if ( bTrace ) ZDebug.trace("begin");
	if ( mUndoTran == null ) {
		mUndoTran = new Stack();
//		mPrevStack = ZDebug.getStack();
	} else {
		ZDebug.trace("Duplicate Transaction");
//		ZDebug.printStack();
//		ZDebug.trace("PrevStack ---");
//		System.out.println(mPrevStack);
	}
	}

	/**
	 * R~bg
	 */
	public void commit() {

	if ( mUndoTran == null ) {
		if ( bTrace ) ZDebug.trace("commit:none");
	} else if ( !mUndoTran.isEmpty() ) {
		Vector items = getFobs( mUndoTran ) ;
		firePropertyChange( FPropertyChangeEvent.PRE_COMMIT, items );
		mUndo.push( mUndoTran ) ;
		if ( bTrace ) ZDebug.trace("commit:"+mUndoTran.size()+" total:"+mUndo.size());
		mRedo.removeAllElements();
		items = getFobs( mUndoTran ) ;
		firePropertyChange( FPropertyChangeEvent.COMMIT, items );
		mIsModified = true;
	} else {
		if ( bTrace ) ZDebug.trace("commit:empty");
	}
	mUndoTran = null ;
	}

	/**
	 * ǉR~bg
	 */
	public void commitPlus() {
	if ( mUndoTran == null ) {
		if ( bTrace ) ZDebug.trace("commit plus:none");
	} else if ( !mUndoTran.isEmpty() ) {
		if ( mUndo.isEmpty() ) {
			if ( bTrace ) ZDebug.trace("commit plus -> commit");
			commit();
		} else {
			Vector items = getFobs( mUndoTran ) ;
			firePropertyChange( FPropertyChangeEvent.PRE_COMMIT, items );
			Stack oldTran = (Stack)mUndo.peek();
			oldTran.addAll( mUndoTran );
			if ( bTrace ) ZDebug.trace("commit plus:"+mUndoTran.size()+" total:"+mUndo.size()+" transize:"+oldTran.size());
//			ZDebug.printStack();
			mRedo.removeAllElements();
			items = getFobs( mUndoTran ) ;
			firePropertyChange( FPropertyChangeEvent.COMMIT, items );
			mIsModified = true;
		}
	} else {
		if ( bTrace ) ZDebug.trace("commit plus:empty");
	}
	mUndoTran = null ;
	}

	/**
	 * [obN
	 */
	public void rollback() {
	if ( mUndoTran == null ) {
		if ( bTrace ) ZDebug.trace("rollback:none");
		return ;
	}
//	Vector items = getFobs( mUndoTran ) ;
//	firePropertyChange( FPropertyChangeEvent.PRE_ROLLBACK, items );
	while ( !mUndoTran.isEmpty() ) {
		IFUndoElement item = (IFUndoElement)mUndoTran.pop();
		item.undo();
	}
//	items = getFobs( mUndoTran ) ;
//	firePropertyChange( FPropertyChangeEvent.ROLLBACK, items );
	if ( bTrace ) ZDebug.trace("rollback");
	mUndoTran = null ;
	}

	/**
	 * AhDACe̒ǉ
	 */
	public void push( IFUndoElement item ) {
	if ( mUndoTran != null ) {
		mUndoTran.push( item );
	}
	}

	/**
	 * AhD̉
	 */
	public boolean canUndo() {
//	ZDebug.trace("this:"+this+" size:"+mUndo.size());
	return( !mUndo.isEmpty() );
	}

	/**
	 * AhD̎s
	 */
	public void undo() {
	if ( bTrace ) ZDebug.trace("undo size:"+mUndo.size()+","+mRedo.size());
	if (canUndo()) {
		Vector items = new Vector();
		Stack undo = (Stack)mUndo.pop();
		Stack redo = new Stack();
		while ( !undo.isEmpty() ) {
			IFUndoElement item = (IFUndoElement)undo.pop();
			item.undo();
			item.getFobs(items);
			redo.push(item);
		}
		mRedo.push(redo);
		firePropertyChange( FPropertyChangeEvent.UNDO, items );
	}
	if ( bTrace ) ZDebug.trace("         :"+mUndo.size()+","+mRedo.size());
	}

	/**
	 * hD̉
	 */
	public boolean canRedo() {
	return( !mRedo.isEmpty() );
	}

	/**
	 * hD̎s
	 */
	public void redo() {
	if ( bTrace ) ZDebug.trace("undo size:"+mUndo.size()+","+mRedo.size());
	if (canRedo()) {
		Vector items = new Vector();
		Stack redo = (Stack)mRedo.pop();
		Stack undo = new Stack();
		while ( !redo.isEmpty() ) {
			IFUndoElement item = (IFUndoElement)redo.pop();
			item.redo();
			item.getFobs(items);
			undo.push(item);
		}
		mUndo.push(undo);
		firePropertyChange( FPropertyChangeEvent.REDO, items );
	}
	if ( bTrace ) ZDebug.trace("         :"+mUndo.size()+","+mRedo.size());
	}

	/**
	 * Fob̎W
	 * @param WundoO[v
	 */
	public Vector getFobs(Stack st) {
	Vector items = new Vector();
	Enumeration elm = st.elements();
	while( elm.hasMoreElements() ) {
		IFUndoElement item = (IFUndoElement)elm.nextElement();
		item.getFobs(items);
	}
	return items;
	}

	/**
	 * Xi[o^
	 * @param listerner Xi[
	 */
	public void addPropertyChangeListener(
		IFPropertyChangeListener listerner) {
	mListener.add( listerner );
	}

	/**
	 * Xi[폜
	 * @param listerner Xi[
	 */
	public void removePropertyChangeListener(
		IFPropertyChangeListener listerner) {
	mListener.remove( listerner );
	}

	/**
	 * Cxg
	 * @param type  Cxg^Cv
	 * @param items CxgIuWFNg
	 */
	public void firePropertyChange(String type, Vector items) {
	FPropertyChangeEvent evt = new FPropertyChangeEvent( type, items);

	// Xi[ɒʒm
	Enumeration elm = mListener.elements() ;
	while ( elm.hasMoreElements() ) {
		IFPropertyChangeListener listerner
			= (IFPropertyChangeListener)elm.nextElement();
		listerner.propertyChange( evt );
	}
	}

	//## Agr[g################################################
	/**
	 * ݂̃gUNVŕύXElementi[Stack
	 */
	protected Stack mUndoTran = null ;

	/**
	 * undo҂Elementi[StackStack
	 */
	protected Stack mUndo ;

	/**
	 * redo҂Elementi[StackStack
	 */
	protected Stack mRedo ;

	/**
	 * vpeBύXXi[Vector
	 */
	protected Vector mListener = new Vector();

	/**
	 * XVꂽH
	 */
	protected boolean mIsModified = false;
}
