/*
 * @(#)ZLine.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.geom;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.IFobElement;
import jp.co.iti.fagot.fob.FDouble;

import jp.co.iti.fagot.util.ZGraphicUtil;
/**
 * geompbP[ẂAJava{f[^NX({double)𗘗p₷
 * NXgp̖̒Zk̂߂ƁA̓Ǝ\bhǉ̂߂
 * pB
 *
 * Line
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class ZLine extends Line2D.Double {

	/**
	 * RXgN^
	 */
	public ZLine() {
	}

	/**
	 * RXgN^
	 */
	public ZLine(double x1,double y1,double x2,double y2) {
	this();
	setLine(x1,y1,x2,y2);
	}

	/**
	 * RXgN^
	 */
	public ZLine(ZPoint pt1,ZPoint pt2) {
	this();
	setLine(pt1.getX(),pt1.getY(),pt2.getX(),pt2.getY());
	}

	/**
	 * RXgN^
	 */
	public ZLine( ZLine line ) {
	this();
	setLine(line.getX1(),line.getY1(),line.getX2(),line.getY2());
	}

	//## I[oCh #################################################
	/**
	 * n_XW̎擾
	 */
	public double getX1() {
    return x1;
	}

	/**
	 * n_YW̎擾
	 */
	public double getY1() {
    return y1;
	}

	/**
	 * n_̎擾
	 */
	public Point2D getP1() {
	    return new ZPoint(getX1(), getY1());
	}

	/**
	 * n_̎擾
	 */
	public ZPoint getP1Z() {
	    return new ZPoint(getX1(), getY1());
	}

	/**
	 * I_XW̎擾
	 */
	public double getX2() {
    return x2;
	}

	/**
	 * I_YW̎擾
	 */
	public double getY2() {
    return y2;
	}

	/**
	 * I_̎擾
	 */
	public Point2D getP2() {
	    return new ZPoint(getX2(), getY2());
	}

	/**
	 * I_̎擾
	 */
	public ZPoint getP2Z() {
	    return new ZPoint(getX2(), getY2());
	}

	/**
	 * W̐ݒ
	 */
	public void setLine(double X1, double Y1, double X2, double Y2) {
	setX1(X1);
	setY1(Y1);
	setX2(X2);
	setY2(Y2);
	}

	/**
	 * `̎擾
	 */
	public Rectangle2D getBounds2D() {
    double x, y, w, h;
	if (getX1() < getX2()) {
		x = getX1();
		w = getX2() - getX1();
	} else {
		x = getX2();
		w = getX1() - getX2();
	}
	if (getY1() < getY2()) {
		y = getY1();
		h = getY2() - getY1();
	} else {
		y = getY2();
		h = getY1() - getY2();
	}
	    return new ZRectangle(x, y, w, h);
	}

	//## ǉ #########################################################
	/**
	 * ړ
	 */
	public void translate(double x, double y) {
	translate(new ZPoint(x,y));
	}

	/**
	 * ړ
	 */
	public void translate( ZPoint pt) {
	ZPoint p1 = getP1Z();
	p1.translate(pt);
	setP1(p1);

	ZPoint p2 = getP2Z();
	p2.translate(pt);
	setP2(p2);
	}

	/**
	 * ̎擾
	 */
	public double length() {
	return ( ZGraphicUtil.getDistance(getP1Z(),getP2Z()) );
	}

	//## FAGOT ########################################################
	/**
	 * n_XW̐ݒ
	 */
	public void setX1( double x ) {
	this.x1 = x;
	}

	/**
	 * n_YW̐ݒ
	 */
	public void setY1( double y ) {
	this.y1 = y;
	}

	/**
	 * n_̐ݒ
	 */
	public void setP1( ZPoint pt ) {
	setX1(pt.getX());
	setY1(pt.getY());
	}

	/**
	 * I_XW̐ݒ
	 */
	public void setX2( double x ) {
	this.x2 = x;
	}

	/**
	 * I_YW̐ݒ
	 */
	public void setY2( double y ) {
	this.y2 = y;
	}

	/**
	 * I_̐ݒ
	 */
	public void setP2( ZPoint pt ) {
	setX2(pt.getX());
	setY2(pt.getY());
	}

	//##  #########################################################
	/**
	 * pXɋ߂H
	 * @param pt      _
	 * @param dMargin ]T
	 */
	public boolean isNear(ZPoint pt, double dMargin) {
	return ZGraphicUtil.isNearLine(getP1Z(),getP2Z(),pt,dMargin);
	}

	//## Agr[g ###############################################
	/**
	 * X1W
	 */
	protected double x1;

	/**
	 * Y1W
	 */
	protected double y1;

	/**
	 * X2W
	 */
	protected double x2;

	/**
	 * Y2W
	 */
	protected double y2;
}
