/*
 * @(#)UFrame.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.ui;

import java.util.Hashtable; 
import java.util.Vector;
import java.util.Enumeration;
import java.util.Locale;

import java.awt.Frame;
import java.awt.Component;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.SwingUtilities;

import java.net.URL;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;
/**
 * Framenʕi
 * @author  N
 * @version 1.01 2001/01/07
 */
public class UFrame extends JFrame implements IZApp {

	/**
     * RXgN^
     * @param szName t[
	 */
	public UFrame(String szName) {
	mFrameName = szName;
	}

	//## UI #######################################################
	/**
     * L&F̐ݒ
	 */
	public void setLookAndFeel() {
	// Look&Feel
	String szLF = getResource().getString("app.lookandfeel");
	if ( szLF != null ) {
		try {
			UIManager.setLookAndFeel(szLF);
		    SwingUtilities.updateComponentTreeUI(this);
		    Enumeration elm = getChildWindows().elements();
		    while ( elm.hasMoreElements() ) {
			    SwingUtilities.updateComponentTreeUI(
			    	(Component)elm.nextElement());
			}
		} catch ( Throwable t ) {
			ZDebug.err("Error loading L&F: " + t);
			t.printStackTrace();
		}
	}
	}

	/**
     * UIt@Ng[̍쐬
	 */
	protected void createUIFactory() {
		mUIFactory = new UIFactory(this);
	}

	/**
     * ^Cg̕\,ACR̕\
	 */
	protected void setTitle() {
	// ^Cg̕\
	String szTitle = getResource().getString("app."+mFrameName+".title" );
	setTitle( szTitle );

	// ACR̕\
	URL url = getResource().getURL("app."+mFrameName+".icon") ;
	if ( url != null ) {
		ImageIcon img = new ImageIcon(url);
		setIconImage( img.getImage() );
	}
	}

	/**
	 * j[o[̍\z
	 */
	protected void createMenuBar() {
	mMenubar = 	getUIFactory().createMenuBar("app.menubar");
	if ( mMenubar != null ) {
		getRootPane().setJMenuBar( mMenubar ) ;
	}
	}

	/**
	 * c[o[̍\z
	 */
	protected void createToolBar() {
	mToolbar = getUIFactory().createToolBar("app.toolbar");
	if ( mToolbar != null ) {
		getContentPane().add("North",mToolbar);
    }
	}

	/**
     * t[A_v^̐ݒ
	 */
	protected void addFrameAdapter() {
	addWindowListener(new UFrameAdapter());	// t[I̐ݒ
	}

	/**
     * UIt@Ng[̎擾
	 */
	public UIFactory getUIFactory() {
	return mUIFactory;
	}

	/**
     * ŋߊJt@Cj[̍XV
     *
	 * ͍XVȂAdlg.setCurrentDirectorysăfBNg
	 * ύXɂȂƃj[\ŃG[ł邽߁AŃt@CXV
	 *
     * @param szFile t@Cij[̍XV݂̂̏ꍇnullj
	 */
	public void updateRecent(String szFile) {
//	getUIFactory().updateRecent( this, "recent", szFile );
	}

	//## qEBhE #################################################
	/**
     * EBhE}l[W̐ݒ
     * @param mgr EBhE}l[W
	 */
	public void setWindowManager(UWindowManager mgr) {
	mWindowManager = mgr;
	}

	/**
     * EBhE}l[W̎擾
	 */
	public UWindowManager getWindowManager() {
	return mWindowManager;
	}

	/**
     * qEBhE̎W
	 */
	protected Vector getChildWindows() {
	if ( getWindowManager() != null ) {
		return getWindowManager().getWindows();
	}
	return new Vector();
	}

	//## Resource #####################################################
	/**
     * \[X̍쐬
	 */
	protected void createResource() {
	mResource = new ZResource(getClass()) ;
	}

	/**
	 * \[X̕ۑ
	 */
	public void saveResource() {
	getResource().saveProperty();
	}

	/**
     * \[X̎擾
	 */
	public ZResource getResource() {
	return mResource;
	}

	/**
     * t[̎擾
	 */
	public String getFrameName() {
	return mFrameName;
	}

	//## Action #######################################################
	/**
	 * ANVo^
	 * @param actions ANV
	 */
	protected void addActions(Action[] actions ) {
	for (int nIndex = 0; nIndex < actions.length; nIndex++) {
	    Action act = actions[nIndex];
	    mActions.put(act.getValue(Action.NAME), act);
	}
	}

	/**
	 * ANV擾܂B
	 * @param szCmd  ANV
	 * @returns item ANVA܂́Anull
	 */
	public Action getAction(String szCmd) {
	return (Action) mActions.get(szCmd);
	}

	/**
	 * ANVUI̍XV
	 */
	public void updateActions() {
	Enumeration elm = mActions.elements() ;
	while ( elm.hasMoreElements() ) {
		Action act = (Action)elm.nextElement();
//		if ( act instanceof UAction ) {
//			((UAction)act).update();
//		}
	}
	}

	//## public #######################################################
	/**
	 * t[̎擾
	 * q_CAOoꍇȂǂɗp
	 */
	public Frame getFrame() {
	return this;
	}

	/**
	 * t[̏I(I[oCh)
	 */
	public void exitFrame() {
	}

	/**
	 * IO
	 */
	public boolean preExit( boolean bForce ) {
	return true;
	}

	/**
	 * AvP[V̏I
	 */
	public void exit() {
	}

	//## TuNX ###################################################
	/**
	 * Sɒ~邽߂WindowAdapterhNX
	 */
	protected class UFrameAdapter extends WindowAdapter {
	/**
	 * EBhȄI
	 * @param event EBhECxg
	 */
	public void windowClosing(WindowEvent e) {
	exitFrame();
	}

	/**
	 * EBhE̔ANeBu
	 * @param event EBhECxg
	 */
	public void windowDeactivated(WindowEvent e) {
	System.gc();
	}
	}

	//## Agr[g ###############################################
    /**
     * Frame
     */
    private String		mFrameName;

	/**
	 * UIt@Ng[
	 */
    private UIFactory	mUIFactory;

	/**
	 * EBhE}l[W
	 */
	private UWindowManager mWindowManager = null;

	/**
	 * j[o
	 */
    private JMenuBar	mMenubar;

	/**
	 * c[o[
	 */
    private JToolBar	mToolbar;

    /**
     * ANVnbVe[u
     */
    private Hashtable	mActions = new Hashtable();

    /**
     * \[X
     */
    private ZResource	mResource;
}
