/*
 * @(#)UWindowManager.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.ui;

import java.awt.Window;

import java.util.Vector;

import jp.co.iti.fagot.IZApp;

import jp.co.iti.fagot.ui.UFrame;
import jp.co.iti.fagot.ui.UDialog;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;
/**
 * EBhE}l[W
 * AvP[V̎qEBhE(Frame,Dialog)Ǘ
 * @author  N
 * @version 1.01 2001/01/07
 */
public class UWindowManager {

	/**
     * RXgN^
	 * @param app AvP[V
	 * @param nCount qEBhE̐
	 */
	public UWindowManager(IZApp app,int nCount) {
	mApp = app;
	mChildren = new Window[nCount];
	}

	//## I[oCh #################################################
	/**
	 * qEBhE̍쐬iʏI[oChj
	 * @param nIndex EBhEԍ
	 */
	public Window createWindow( int nIndex ) {
	return null;
	}

	/**
	 * EBhE̍XViʏI[oChj
	 * @param nIndex EBhEԍ
	 */
	public void updateWindow( int nIndex ) {
	}

	//## EBhE ###############################################
	/**
	 * J
	 */
	public void openWindow() {
	if ( !mEnableWindow ) {
		// OIɎqt[\ĂΕ\
		for( int nIndex=0 ; nIndex<getWindowCount() ; nIndex++ ) {
			if ( getResource().getBoolean(RES_PREFIX+nIndex) ) {
				setVisible( nIndex, true );
			}
		}
		mEnableWindow = true;
	}
	}

	/**
	 * qEBhE̕\
	 * @param nIndex t[ԍ
	 * @param bShow \L
	 */
	public void setVisible( int nIndex, boolean bShow ) {
	if ( bShow ) {
		if ( getWindow(nIndex) == null ) {
			mChildren[nIndex] = createWindow(nIndex) ;
		}
		// \
		updateWindow( nIndex );
	}
	getWindow(nIndex).setVisible( bShow );
	}

	/**
	 * qEBhE\Ă邩H
	 * @param nIndex t[ԍ
	 * @param bShow \L
	 */
	public boolean isVisible( int nIndex ) {
	boolean bRet = true;
	if ( getWindow(nIndex) == null ) {
		bRet = false ;
	} else {
		bRet = getWindow(nIndex).isVisible();
//		bRet = ((Window)win).isShowing() ;
	}
	return bRet;
	}

	/**
	 * EBhE̎擾
	 * @param nIndex EBhEԍ
	 */
	public Window getWindow( int nIndex ) {
	return mChildren[nIndex];
	}

	/**
	 * qEBhE̎W
	 */
	public Vector getWindows() {
	Vector vec = new Vector();
	for( int nIndex=0 ; nIndex<getWindowCount() ; nIndex++ ) {
		Window win = getWindow(nIndex);
		if ( win != null ) {
			vec.add( win );
		}
	}
	return vec;
	}

	/**
	 * 
	 */
	public void closeWindow() {
	if ( mEnableWindow ) {
		// qt[\Ă΁ANɂ\悤A
		// \Ԃۑ
		for( int nIndex=0 ; nIndex<getWindowCount() ; nIndex++ ) {
			Window win = getWindow( nIndex );
			if ( win != null ) {
				boolean bShow = isVisible( nIndex ) ;
				getResource().putString(RES_PREFIX+nIndex,
										((bShow)?"true":"false"));
				if ( bShow ) {
					String szWin = null ;
					if ( win instanceof UFrame ) {
						szWin = ((UFrame)win).getFrameName();
					} else if ( win instanceof UDialog ) {
						szWin = ((UDialog)win).getDialogName();
					}
					if ( szWin != null ) {
						// t[̈ʒuۑ
						getResource().saveGeometry(win,szWin);
					}
					setVisible( nIndex,false );
				}
			}
		}
		mEnableWindow = false;
	}
	}

	/**
	 * qEBhELH
	 */
	public boolean isEnable( int nIndex ) {
	return mEnableWindow;
	}

	//## vpeB ###################################################
	/**
	 * AvP[V̎擾
	 */
	public IZApp getApp() {
	return mApp;
	}

	/**
	 * \[X̎擾
	 */
	public ZResource getResource() {
	ZResource res = null;
	if ( getApp() != null ) {
		res = getApp().getResource();
	}
	return res;
	}

	/**
	 * qEBhE̐̎擾
	 */
	public int getWindowCount() {
	int nCount = 0 ;
	if ( mChildren != null ) {
		nCount = mChildren.length;
	}
	return nCount;
	}

	//## Agr[g ###############################################
	/**
	 * AvP[V
	 */
	protected IZApp mApp = null;

    /**
     * qEBhE
     */
	protected Window mChildren[] = null;

	/**
	 * \[XANZXvtBbNX
	 */
	static protected final String RES_PREFIX = "app.childWindow.";

	/**
	 * EBhELH
	 */
	protected boolean mEnableWindow = false;
}
