/*
 * @(#)ZDebug.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.util;

import java.text.DateFormat;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.FileWriter;
import java.io.IOException;

import java.util.Date;
import java.util.Vector;
import java.util.Enumeration;


/**
 * fobOT|[gCu񋟂܂B
 * ׂstatic\bh̃[eBeBł
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public class ZDebug {
	/**
	 * g[Xo̗͂Lݒ肵܂B
	 * @param bTrace g[X̗L
	 */
	static public void setTrace(boolean bTrace) {
	mTrace = bTrace;
	}

	/**
	 * g[Xt@Cݒ肵܂B
	 * @param szFile g[Xt@C̐ݒ
	 */
	static public void setTraceFile(String szFile) {
	mFile = szFile;
	}

	/**
	 * X^bNWG[o͂ɏo͂܂
	 *
	 yo͗z
	ZDebug.printStack()
		at jp.co.iti.fagot.ui.ibox.UTextArea.setString(UTextArea.java:43)
		at jp.co.iti.fagot.ui.UInputPanel.loadProperty(UInputPanel.java:233)
	 */
	static public void printStack() {
    try {
		String szTest = null;
		szTest.toString();
	} catch(NullPointerException np) {
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		PrintStream ps = new PrintStream(stream,true);
		np.printStackTrace(ps);
		String szStack = stream.toString();
		// 1߂")"܂(̃\[X̃X^bN)Ƃ̂
		int nIndex = szStack.indexOf(")");
		String szPrint = "ZDebug.printStack()"+szStack.substring(nIndex+1);
		printErr(szPrint);
    }
	}

	/**
	 * X^bN擾܂
	 *
	 */
	static public String getStack() {
	String szText = null;
    try {
		String szTest = null;
		szTest.toString();
	} catch(NullPointerException np) {
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		PrintStream ps = new PrintStream(stream,true);
		np.printStackTrace(ps);
		String szStack = stream.toString();
		// 1߂")"܂(̃\[X̃X^bN)Ƃ̂
		int nIndex = szStack.indexOf(")");
		szText = szStack.substring(nIndex+1);
    }
    return szText;
	}

	/**
	 * g[XWo͂ɏo͂܂
	 * @param szStr o͂镶
	 */
	static public void trace(Throwable szTh) {
	if ( !mTrace ) return;
	String szCaller = getCaller();
	println(szCaller+szTh.toString());
	StackTraceElement[] ste = szTh.getStackTrace();
	
	if(null == ste) return;
	for(int i = ste.length - 1; 0 <= i; i--) println(ste[i].toString());
	}

	/**
	 * g[XWo͂ɏo͂܂
	 * @param szStr o͂镶
	 */
	static public void trace(String szStr) {
	if ( !mTrace ) {
		return;
	}
	String szCaller = getCaller();
	println(szCaller+szStr);
	}

	/**
	 * }[J[Wo͂ɏo͂܂
	 */
	static public void trace() {
	if ( !mTrace ) {
		return;
	}
	String szCaller = getCaller();
	println(szCaller+"### trace ###");
	}


	/**
	 * G[WG[o͂ɏo͂܂
	 * @param szStr o͂镶
	 */
	static public void err(String szStr) {
	String szCaller = getCaller();
	printErr(szCaller+szStr);
	}

	/*
	 * oCg̃_v
	 *
	 * oCǧ`ŕWo͂ɏo͂܂
	 *
	 yo͗z
    *** Dump *** : 000000 : 44 3a 5c 77 6f 72 6b 5c  72 69 64 2d 78 5c 45 64  | D:\work\ rid-x\Ed
    *** Dump *** : 000010 : 69 74 6f 72 5c 73 72 63  5c 64 65 6d 6f 5c 55 6e  | itor\src \demo\Un
    *** Dump *** : 000020 : 69 63 6f 72 6f 2e 6a 61  76 61                    | icoro.ja va      
	 *
	 * @param src oCg
	 */
	static public void dump( byte[] src ) {
	if ( !mTrace ) {
		return;
	}
	int nLen = src.length ;
	if ( nLen > 64 ) nLen = 64 ;

	int nDmp = 0 ;
	int nAt  ;
	int nCol ;
	while ( nDmp < nLen )
	{
		String szLine = "    *** Dump *** : " ;
		szLine += getHex( 6, nDmp ) ;
		szLine += " : ";
		nCol = (nLen-nDmp>16)?16:nLen-nDmp ;
		for ( nAt=0 ; nAt<16 ; nAt++ ) {
			if ( nAt < nCol ) { szLine += getHex( 2,(int)src[nDmp+nAt] ) ;
								szLine += " " ; }
			else			  {	szLine += "   " ; }
			if ( nAt == 7 )	  {	szLine += " "  ; }
		}
		szLine += " | " ;
		for ( nAt = 0 ; nAt<16 ; nAt++ ) {
			if ( nAt < nCol ) { szLine += (char)(src[nDmp+nAt]) ; }
			else			  { szLine += " " ; }
			if ( nAt == 7 )	  {	szLine += " " ; }
		}
		println( szLine ) ;
		nDmp += nCol ;
	}
	}

	/**
	 * ̐`F16i_v
	 * gƂɃTvĂ悤
	 */
	static public String getHex( int nSize, int val ) {
	String szRet = "" ;
	int nKeta = 0 ;
	for (  ; nKeta < nSize && val != 0 ; nKeta++ ) {
		int nx = val % 16 ;
		val    = val / 16 ;
		szRet = new Character(Character.forDigit(nx,16)).toString() + szRet;
	}
	for ( ; nKeta < nSize ; nKeta++ ) {
		szRet = "0" + szRet ;
	}
	return ( szRet ) ;
	}

	/**
	 * \̊Jn
	 * @param szText
	 */
	static public void lapStart(String szText) {
	mLaps = new Vector();
	Date date = new Date();
	mLaps.add(date);
	String szCaller = getCaller();
	mLaps.add(szCaller+szText);
	}

	/**
	 * bv|Cg
	 * @param szText
	 */
	static public void lap(String szText) {
	if ( mLaps == null ) {
		return;
	}
	Date date = new Date();
	mLaps.add(date);
	String szCaller = getCaller();
	mLaps.add(szCaller+szText);
	}

	/**
	 * \̏I
	 * @param szText Rg
	 * @param isCSV  csv`ŏo
	 */
	static public void lapEnd(String szText, boolean isCSV) {
	if ( mLaps == null ) {
		return;
	}
	Date date = new Date();
	mLaps.add(date);
	String szCaller = getCaller();
	mLaps.add(szCaller+szText);

	// vԂ̌vZ
	Date start = (Date)mLaps.firstElement();
	long total = date.getTime() - start.getTime();
	
	// bv^C̕\
	DateFormat fmt = DateFormat.getTimeInstance();
	Enumeration elm = mLaps.elements();
	Date   dt = (Date)elm.nextElement();
	String st = (String)elm.nextElement();
	if ( isCSV ) {
		// lap timecsv`ŏo
		String szOut = "*** lap ***,";
		long prev = dt.getTime();
		while ( elm.hasMoreElements() ) {
			dt = (Date)elm.nextElement();
			st = (String)elm.nextElement();
			long cur = dt.getTime();
			long interval = cur-prev;
//			szOut += st + "," + interval + ",";
			szOut += interval + ",";
			prev = cur;
		}
		println(szOut);

	} else {
		// lap timeƃRgo
		println("*** lap ***");
		println(fmt.format(dt)+":total["+total+"]"+st);
		long prev = dt.getTime();
		while ( elm.hasMoreElements() ) {
			dt = (Date)elm.nextElement();
			st = (String)elm.nextElement();
			long cur = dt.getTime();
			long interval = cur-prev;
			long ms  = cur % 1000;
			float per = interval * 100 / total;
			println(fmt.format(dt)+":"+ms+"#"+
							   interval+"["+
							   per+"%]"+st);
			prev = cur;
		}
	}
	mLaps = null;
	}

	//## ֐ #####################################################
	/**
	 * Ăяo̎擾
	 */
	static protected String getCaller() {
	String szPrint = null;
    try {
		String szTest = null;
		szTest.toString();
	} catch(NullPointerException np) {
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		PrintStream ps = new PrintStream(stream,true);
		np.printStackTrace(ps);
		String szStack = stream.toString();
		// 2߂"("܂(Ăяõt@C)Ƃ̂
		int nIndex = szStack.indexOf("(");
		String szTmp = szStack.substring(nIndex+1);
		nIndex = szTmp.indexOf("(");
		szTmp = szTmp.substring(nIndex+1);
		// 3߂͌Ăяõ\bhcĂ̂ŁA\bh𒊏o
		nIndex = szTmp.indexOf("(");
		String szPackage = szTmp.substring(0,nIndex);
		String szClass[] = ZString.tokenize(szPackage,".");
		String szFunction= szClass[szClass.length-1];
		// 3߂"("܂łƂ̂
		szTmp = szTmp.substring(nIndex);
		// ")"܂(Ăяõt@C+sԍ)𒊏o
		nIndex = szTmp.indexOf(")");
		szPrint = szTmp.substring(0,nIndex+1) + szFunction + ":";
    }
    return szPrint;
	}

	/**
	 * g[Xo
	 * @param szStr o͂镶
	 */
	static protected void println(String szStr) {
	if ( mFile == null ) {
		System.out.println(szStr);
	} else {
		try {
			FileWriter fw = new FileWriter( mFile, true );
			fw.write( szStr + "\n" );
			fw.close();
		} catch(IOException io) {
			// NOP
		}
	}
	}

	/**
	 * G[o
	 * @param szStr o͂镶
	 */
	static protected void printErr(String szStr) {
	if ( mFile == null ) {
		System.err.println(szStr);
	} else {
		try {
			FileWriter fw = new FileWriter( mFile, true );
			fw.write( "*ERR*:" + szStr + "\n");
			fw.close();
		} catch(IOException io) {
			// NOP
		}
	}
	}

	//## Agr[g ###############################################
	/**
	 * g[X̗L
	 */
	static protected boolean mTrace = true;

	/**
	 * g[Xt@C
	 */
	static protected String mFile = null;

	/**
	 * \pbvRei
	 */
	static protected Vector mLaps = null;
}
