/*
 * @(#)ZFileFilter.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.util;

import java.io.File;
import java.util.Hashtable;
import java.util.Enumeration;

import javax.swing.filechooser.FileFilter;

/**
 * t@CtB^ȈՃo[W
 *
 * yz - gif,jpg t@CIԏꍇ
 *
 *     JFileChooser chooser = new JFileChooser();
 *     FuFileFilter filter = new ZFileFilter(
 *                   new String{"gif", "jpg"}, "JPEG & GIF Images")
 *     chooser.addChoosableFileFilter(filter);
 *     chooser.showOpenDialog(this);
 *
 * @author  N
 * @version 1.01 2000/10/12
 */
public class ZFileFilter extends FileFilter {

    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";

    private Hashtable sFilters = null;
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

	/**
	 * RXgN^iSẴt@C^CvIj
	 * @see #addExtension
	 */
	public ZFileFilter() {
	sFilters = new Hashtable();
	}

	/**
	 * RXgN^iP̃t@C^CvIj
	 * @see #addExtension
	 */
	public ZFileFilter(String extension) {
	this(extension,null);
	}

	/**
	 * RXgN^iP̃t@C^Cvi̕tjIj
	 * yz: new FuFileFilter("jpg", "JPEG Image Images");
	 * @see #addExtension
	 */
	public ZFileFilter(String extension, String description) {
	this();
	if(extension!=null) {
		addExtension(extension);
	}
 	if(description!=null) {
		 setDescription(description);
	}
	}

	/**
	 * RXgN^ĩt@C^CvIj
	 * yz: new FuFileFilter(String {"gif", "jpg"});
	 * @see #addExtension
	 */
	public ZFileFilter(String[] filters) {
	this(filters, null);
	}

	/**
	 * RXgN^ĩt@C^Cvi̕tjIj
	 * yz: new FuFileFilter(String {"gif", "jpg"}, "Gif and JPG Images");
	 * @see #addExtension
	 */
	public ZFileFilter(String[] filters, String description) {
	this();
	for (int nIndex = 0; nIndex < filters.length; nIndex++) {
	    addExtension(filters[nIndex]);
	}
 	if(description!=null) {
		setDescription(description);
    }
	}

	/**
	 * 󂯕tt@C^CvH
	 */
	public boolean accept(File f) {
	if(f != null) {
	    if(f.isDirectory()) {
			return true;
	    }
	    String extension = ZFile.getExt(f.getName());
	    if ( extension != null ) {
			extension = extension.toLowerCase();
			if ( sFilters.get(extension) != null ) {
				return true;
			}
	    }
	}
	return false;
	}

	/**
	 * t@C^Cvǉ
	 * yz: new FuFileFilter("jpg", "JPEG Image Images");
	 *   FuFileFilter filter = new FuFileFilter();
	 *   filter.addExtension("jpg");
	 *   filter.addExtension("tif");
	 */
	public void addExtension(String extension) {
	if(sFilters == null) {
	    sFilters = new Hashtable(5);
	}
	sFilters.put(extension.toLowerCase(), this);
	fullDescription = null;
	}

	/**
	 * t@Ĉ擾
	 */
	public String getDescription() {
	if(fullDescription == null) {
	    if(description == null || isExtensionListInDescription()) {
 		fullDescription = description==null ? "(" : description + " (";
		// build the description from the extension list
		Enumeration extensions = sFilters.keys();
		if(extensions != null) {
		    fullDescription += "." + (String) extensions.nextElement();
		    while (extensions.hasMoreElements()) {
			fullDescription += ", " + (String) extensions.nextElement();
		    }
		}
		fullDescription += ")";
	    } else {
		fullDescription = description;
	    }
	}
	return fullDescription;
	}

	/**
	 * t@Ĉݒ
	 * yz: filter.setDescription("Gif and JPG Images");
	 */
	public void setDescription(String description) {
	this.description = description;
	fullDescription = null;
	}

	/**
	 * Determines whether the extension list (.jpg, .gif, etc) should
	 * show up in the human readable description.
	 *
	 * Only relevent if a description was provided in the constructor
	 * or using setDescription();
	 */
	public void setExtensionListInDescription(boolean b) {
	useExtensionsInDescription = b;
	fullDescription = null;
	}

	/**
	 * Returns whether the extension list (.jpg, .gif, etc) should
	 * show up in the human readable description.
	 *
	 * Only relevent if a description was provided in the constructor
	 * or using setDescription();
	 */
	public boolean isExtensionListInDescription() {
	return useExtensionsInDescription;
	}
}

