/*
 * @(#)ZGraphicUtil.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.util;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Font;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

import java.text.AttributedString;
import java.text.AttributedCharacterIterator;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.PTransform;

import jp.co.iti.fagot.util.ZDebug;

/**
 * OtBbN[eBeB
 *
 * }``̊{֐`B
 * ׂĐÓI\bh
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class ZGraphicUtil {
	/**
	 * Ɠ_߂肵܂
	 * @param pt1  ̊Jn_
	 * @param pt2  ̊Jn_
	 * @param pt   _
	 * @param margin ]T
	 */
	static public boolean isNearLine(
		ZPoint pt1,ZPoint pt2,ZPoint pt,double margin ) {

	// pt1  pt2 ̊Ԃ pt 邩H
	ZRectangle rect =
		new ZRectangle(
			Math.min(pt1.getX(),pt2.getX())-margin  ,
			Math.min(pt1.getY(),pt2.getY())-margin  ,
			Math.abs(pt1.getX()-pt2.getX())+margin*2,
			Math.abs(pt1.getY()-pt2.getY())+margin*2
		);
	if ( !rect.contains(pt) ) {
		 return false;
	}

	double dist = getDistance(pt1,pt2,pt);

	// 
	if ( dist < margin ) {
		return true ;
	}
	return false;
	}

	/**
	 * Ɠ_̋vZ܂
	 * @param pt1  ̊Jn_
	 * @param pt2  ̊Jn_
	 * @param pt   _
	 */
	static public double getDistance(ZPoint pt1,ZPoint pt2,ZPoint pt ) {
	// ޸ق̒o
	ZPoint ptA = pt.minus(pt1);
	ZPoint ptB = pt2.minus(pt1);

	// W̌vZ	Ax * Bx + Ay * By
	//              ----------------
	//				Bx * Bx + By * By
	double zx = ptA.getX()*ptB.getX() + ptA.getY()*ptB.getY() ;
	double zy = ptB.getX()*ptB.getX() + ptB.getY()*ptB.getY() ;
	double zz = zx / zy ;

	// Ƃ̌_
	ZPoint ptC = new ZPoint(pt1.getX()+ptB.getX()*zz,
							pt1.getY()+ptB.getY()*zz);

	// _Ɠ_Ƃ̋̂Q
	double dist = ( pt.getX()-ptC.getX() ) * ( pt.getX()-ptC.getX()) +
				  ( pt.getY()-ptC.getY() ) * ( pt.getY()-ptC.getY()) ;

	return ( Math.sqrt(dist) ) ;
	}

	/**
	 * _Ɠ_̋vZ܂
	 * @param pt1  _1
	 * @param pt2  _2
	 */
	static public double getDistance(ZPoint pt1,ZPoint pt2) {
	double x = pt1.getX()-pt2.getX();
	double y = pt1.getY()-pt2.getY();
	return ( Math.sqrt(x*x + y*y) );
	}

	//## 쐬 #########################################################
	/**
	 * ShapevZ܂
	 * @param pt1  ̊Jn_
	 * @param pt2  ̏I_
	 * @param pt   _
	 */
	static public Shape createArrowShape(ZPoint pt1,ZPoint pt2,double length,double width) {
	// Op`̍쐬iE獶ւ̖j
	ZPath p1 = new ZPath();
	p1.moveTo(      0,      0 );
	p1.lineTo( length,  width );
	p1.lineTo( length, -width );
	p1.closePath();

	// p2p1ւ̒PʃxNg߂
	ZPoint ptA = pt1.minus(pt2);
	double distance = getDistance(pt1,pt2);
	ZPoint ptUnit = new ZPoint(ptA.getX()/distance,ptA.getY()/distance);

	// ϊs̍쐬
    //		[   cos(theta)    -sin(theta)    pt2.x   ]
    //		[   sin(theta)     cos(theta)    pt2.y   ]
    // Athetap1p2ւ̒PʃxNg
	AffineTransform at = new AffineTransform(
			ptUnit.getX(),		ptUnit.getY(),
		   -ptUnit.getY(),		ptUnit.getX(),
			pt2.getX(),			pt2.getY() ) ;

	Shape s1 = at.createTransformedShape( p1 );
	return s1 ;
	}

	//## Wϊ #####################################################
	/**
	 * e`Ɏq`܂悤ȍWϊvZ܂
	 * (V[OῗȂƂO)
	 *
	 * `Ȃ̂ō폜\
	 *
	 * @param pa e`
	 * @param ch q`
	 */
	static public PTransform getNormalizeTransform(ZRectangle pa,ZRectangle ch) {
	// q`̍オe`̍
	// q`̉Ee`̉EɂȂ悤ȍWϊvZ܂B

	// ̕ϊ
	// chTL.x * d00 + chTL.y * d01 + d02 = paTL.x	@
	// chTL.y * d10 + chTL.x * d11 + d12 = paTL.y	A
	// E̕ϊ
	// chBR.x * d00 + chBR.y * d01 + d02 = paBR.x	B
	// chBR.y * d10 + chBR.x * d11 + d12 = paBR.y	C

	// B-@(d01=0)
	//     chTL.x * d00 - chBR.x * d00 = paTL.x - paBR.x
	//   d00 = ( paBR.x - paTL.x ) / ( chBR.x - chTL.x )
	//       =   pa.getWidth()     /   ch.getWidth()
	double d00 = pa.getWidth()/(ch.getWidth());

	// l C-A(d10=0)
	double d11 = pa.getHeight()/(ch.getHeight());

	// d00,d11̏lKꂽ{
	double dz = Math.min( d00, d11 );
	// 傫͂Ȃ
	if ( dz > 1 ) {
		dz = 1;
	}

	// ̍WϊAd01,d12߂
	ZPoint paCenter = pa.getCenter();
	ZPoint chCenter = ch.getCenter();
	double d02 = paCenter.getX()-chCenter.getX()*dz;
	double d12 = paCenter.getY()-chCenter.getY()*dz;

	return new PTransform(dz,0,0,dz,d02,d12) ;
	}

	//## COLOR ########################################################
	/**
	 * ԐFԂ܂
	 * @param col1 F1
	 * @param col2 F2
	 */
	static public Color harfColor(Color col1, Color col2) {
	return new Color(
		(col1.getRed()  +col2.getRed())/2,
		(col1.getGreen()+col2.getGreen())/2,
		(col1.getBlue() +col2.getBlue())/2);
	}

	/**
	 * F̒l擾ł邩ۂ܂B
	 *
	 * @param szStr Fw蕶
	 */
	static public boolean isValidColor(String szStr) {
	Color col = stringToColor(szStr);
	return ( col != null );
	}

	/**
	 * L[ɑΉF擾܂B
	 * l擾łȂꍇnullԂ܂
	 *
	 * @param szStr Fw蕶
	 */
	static public Color stringToColor(String szStr) {
	Color  cCol  = null;
	if ( szStr == null ) {
		//
	} else if ( szStr.startsWith("#") &&
	     (szStr.length()==7 || szStr.length()==4) ) {
		int nRed   = 0;
		int nGreen = 0;
		int nBlue  = 0;
		int nXXX   = 1;	// 1Ŏw肵Ăꍇ16{
		try {
			szStr = szStr.substring(1);
			int nSize = szStr.length() / 3;
			nRed  = Integer.parseInt(szStr.substring(0,nSize),16);
			szStr = szStr.substring(nSize);
			nGreen= Integer.parseInt(szStr.substring(0,nSize),16);
			szStr = szStr.substring(nSize);
			nBlue = Integer.parseInt(szStr.substring(0,nSize),16);
			if ( nSize == 1 ) {
				nXXX = 16;
			}
//			ZDebug.trace("szStr="+szStr+" R="+nRed+" G="+nGreen+" B="+nBlue);
			cCol = new Color(nRed*nXXX,nGreen*nXXX,nBlue*nXXX);
		} catch ( NumberFormatException nf ) {
			ZDebug.trace("stringToColor:parse error");
		}
	}
	return cCol;
	}

	/**
	 * nȂtureԂ܂B
	 * @param col 肷F
	 */
	static public boolean isBlackFamily(String szCol) {
	return isBlackFamily( stringToColor(szCol) );
	}

	/**
	 * nȂtureԂ܂B
	 * Color  null ̏ꍇ́AfalseԂ܂
	 * @param col 肷F
	 */
	static public boolean isBlackFamily(Color col) {
	int nAve = 255*3;
	if ( col != null ) {
		nAve = col.getRed()+col.getGreen()+col.getBlue();
	} 
	return (nAve<(128*3));
	}

	/**
	 * ΐFԂ܂B
	 * @param col 肷F
	 */
	static public Color inverseColor(Color col) {
	if ( col != null ) {
		return new Color(255-col.getRed(),255-col.getGreen(),255-col.getBlue());
	}
	return null;
	}

	/**
	 * J[𕶎ɕϊ܂
	 *
	 * Color.decode(),Color.getColor()͂ĂɂȂȂ̂ŏC
	 *
	 * @param szStr Fw蕶
	 */
	static public String colorToString(Color c) {
	String szColor = null;
	if ( c != null ) {
		szColor = "#";

		String szRed   = Integer.toHexString(c.getRed());
		if ( szRed.length() == 1 ) {
			szColor += "0" + szRed.toUpperCase();
		} else {
			szColor += szRed.toUpperCase();
		}

		String szGreen = Integer.toHexString(c.getGreen());
		if ( szGreen.length() == 1 ) {
			szColor += "0" + szGreen.toUpperCase();
		} else {
			szColor += szGreen.toUpperCase();
		}

		String szBlue = Integer.toHexString(c.getBlue());
		if ( szBlue.length() == 1 ) {
			szColor += "0" + szBlue.toUpperCase();
		} else {
			szColor += szBlue.toUpperCase();
		}
	}
	return szColor;
	}

	/**
	 * J[VXeJ[ɕϊ܂
	 *
	 * @param szStr Fw蕶
	 */
	static public String stringToSystemColor(String szColor) {
	return szColor;
	}

	//## (o[W)gYꂽ... ################
	/**
	 * LineBreakMeasurer̍쐬
	 * @param szText     \
	 * @param font       tHg
	 * @param bgColor    wiF
	 * @param fgColor    F
	 * @param at         Wϊ
	 */
	static public LineBreakMeasurer createLineBreakMeasurer(
		String szText, Font font, Color bgColor, Color fgColor, AffineTransform at) {
	//
	int nLen = szText.length();

	// teLXg
	AttributedString as = new AttributedString(szText);

	// teLXgFtHg̐ݒ
	if ( font != null ) {
		as.addAttribute(TextAttribute.FONT,font,0,nLen);
	}

	// teLXgFwiF̐ݒ
	if ( bgColor!=null ) {
		as.addAttribute(TextAttribute.BACKGROUND, bgColor, 0, nLen);
	}

	// teLXgFF̐ݒ
	if ( fgColor!=null ) {
		as.addAttribute(TextAttribute.FOREGROUND, fgColor, 0, nLen);
	} else {
		as.addAttribute(TextAttribute.FOREGROUND, Color.black, 0, nLen);
	}
	
	// teLXgFCe[^̎擾
	AttributedCharacterIterator aci = as.getIterator();

	// ̂ő傫[NĂ悤Ȋ...
//	FontRenderContext frc = new FontRenderContext(at,true,true);
//	FontRenderContext frc = new FontRenderContext(at,false,true);
	FontRenderContext frc = new FontRenderContext(at,false,false);

	LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
	return lbm;
	}

	//## (o[W)gYꂽ... ################
	/**
	 * LineBreakMeasurer̍쐬
	 * @param szText     \
	 * @param font       tHg
	 * @param bgColor    wiF
	 * @param fgColor    F
	 * @param at         Wϊ
	 */
	static public LineBreakMeasurer createLineBreakMeasurer(
		String szText, String family, Float size, Color bgColor, Color fgColor, FontRenderContext frc) {
	// teLXg
	AttributedString as = new AttributedString(szText);

	// teLXgFtHg̐ݒ
	if ( family != null )	as.addAttribute(TextAttribute.FAMILY, family);
	if ( size != null )		as.addAttribute(TextAttribute.SIZE, size);
	
	// teLXgFwiF̐ݒ
	if ( bgColor!=null ) {
		as.addAttribute(TextAttribute.BACKGROUND, bgColor);
	}

	// teLXgFF̐ݒ
	if ( fgColor!=null ) {
		as.addAttribute(TextAttribute.FOREGROUND, fgColor);
	} else {
		as.addAttribute(TextAttribute.FOREGROUND, Color.black);
	}
	
	return new LineBreakMeasurer(as.getIterator(), frc);
	}
	
	/**
	 * K؂ȃTCY̎擾
	 * @param szText     LineBreakMeasurer
	 * @param at         Wϊ
	 * @param nLen       ̒
	 * @param dWidth     ő啝i1s̏ꍇ0j
	 */
	static public ZDimension getTextPreferredSize(
		LineBreakMeasurer lbm, AffineTransform at, int nLen, double dWidth) {

	boolean bSingle = false;
	if ( dWidth == 0 ) {
		bSingle = true;
		dWidth = 10000;
	}

	// ʒu̕ۑ
	int pos = lbm.getPosition();

	// `Jnʒu擾邪AƂ肠ォ
	float fx = 0;
	float fy = 0;
	while ( lbm.getPosition() < nLen ) {
		TextLayout tl = lbm.nextLayout((float)dWidth);
		float plus = tl.getAscent() + tl.getDescent() + tl.getLeading();
		if ( at == null ) {
			fy += plus;
		} else {
			ZPoint pttrans = new ZPoint(0,(double)plus);
			Point2D pt2D = at.transform(pttrans,null);
			fy += pt2D.getY() ;
		}
		if ( fx < tl.getVisibleAdvance() ) {
			fx = tl.getVisibleAdvance();
		}

		if ( bSingle ) {
			break;
		}
	}

	lbm.setPosition( pos ) ;

//System.out.println(fx+","+fy);
	return new ZDimension( (double)fx, (double)fy );
	}

}
