/**
 * @(#)SVGStype.java
 * Copyright 2001 
 * @author  Intelligent Technology Inc.
 * @version 0.00 2001/08/14
 */
package jp.co.iti.fagot.xml;

/**
 * SVGStyle
 */
public class SVGStyle	implements	ISVGStyle{
	public	SVGStrokeStyle	stroke	=	null;
	public	SVGFillStyle	fill	=	null;
	public	SVGTextStyle	text	=	null;
	public	SVGMiscStyle	misc	=	null;
	
	/**
	 * RXgN^
	 * @param	none
	 * @return	none
//	 * @exception
//	 * @see
	 * @since	0.00
//	 * @deprecated SVG Style Class
	 */
	public SVGStyle(){
		super();
		
		stroke	= new SVGStrokeStyle();
		fill	= new SVGFillStyle();
		text	= new SVGTextStyle();
		misc	= new SVGMiscStyle();
	}
	
	public SVGStyle(SVGStyle s){
		super();
		
		if(null==s)	return;
		
		stroke	= new SVGStrokeStyle(s.stroke);
		fill	= new SVGFillStyle(s.fill);
		text	= new SVGTextStyle(s.text);
		misc	= new SVGMiscStyle(s.misc);
	}
	
	public	String toString(){
		SVGStyleParam s = new SVGStyleParam();
		s.add(stroke.toString());
		s.add(fill.toString());
		s.add(text.toString());
		s.add(misc.toString());
		return(s.toString());
	}
	
	public	Object clone(){
		SVGStyle clone = new SVGStyle();
		clone.stroke	=	(SVGStrokeStyle)stroke.clone();
		clone.fill		=	(SVGFillStyle)fill.clone();
		clone.text		=	(SVGTextStyle)text.clone();
		clone.misc		=	(SVGMiscStyle)misc.clone();
		
		return(clone);
	}
}