/**
 * @(#)SVGTextStyle.java
 * Copyright 2001 
 * @author  Intelligent Technology Inc.
 * @version 0.00 2001/08/16
 */
package jp.co.iti.fagot.xml;

/**
 * SVGTextStyle
 */
public class SVGTextStyle	extends	SVGStyles{
	public	String	baselineShift		= null;
	public	String	direction			= null;
	public	String	display				= null;
	public	String	dominantBaseline	= null;
	public	String	letterSpacing		= null;
	public	String	wordSpacing			= null;
	public	String	anchor				= null;
	public	String	decoration			= null;
	public	String	rendering			= null;
	public	String	mode				= null;
	public	SVGFontStyle	font		= null;
	
	/**
	 * RXgN^
	 * @param	none
	 * @return	none
//	 * @exception
//	 * @see
	 * @since	0.00
//	 * @deprecated SVG Style Class
	 */
	public	SVGTextStyle(){
		super();
		font	=	new SVGFontStyle();
	}
	public	SVGTextStyle(SVGTextStyle s){
	 	this();
		
		if(null==s)	return;
		
		if(null!=s.baselineShift)		baselineShift		= new String(s.baselineShift);
		if(null!=s.direction)			direction			= new String(s.direction);
		if(null!=s.display)				display				= new String(s.display);
		if(null!=s.dominantBaseline)	dominantBaseline	= new String(s.dominantBaseline);
		if(null!=s.letterSpacing)		letterSpacing		= new String(s.letterSpacing);
		if(null!=s.wordSpacing)			wordSpacing			= new String(s.wordSpacing);
		if(null!=s.anchor)				anchor				= new String(s.anchor);
		if(null!=s.decoration)			decoration			= new String(s.decoration);
		if(null!=s.rendering)			rendering			= new String(s.rendering);
		if(null!=s.mode)				mode				= new String(s.mode);
		if(null!=s.font)				font				= new SVGFontStyle(s.font);
	}
	
	public	String toString(){
		SVGStyleParam	s = new SVGStyleParam();
		
		s.add(BASELINE_SHIFT	,baselineShift);
		s.add(DIRECTION			,direction);
		s.add(DISPLAY			,display);
		s.add(DOMINANT_BASELINE	,dominantBaseline);
		s.add(LETTER_SPACING	,letterSpacing);
		s.add(WORD_SPACING		,wordSpacing);
		s.add(TEXT_ANCHOR		,anchor);
		s.add(TEXT_DECORATION	,decoration);
		s.add(TEXT_RENDERING	,rendering);
		s.add(WRITING_MODE		,mode);
		s.add(font.toString());
		
		return(s.toString());
	}
	
	public	Object clone(){
		SVGTextStyle clone = new SVGTextStyle();
		
		if(null!=baselineShift)		clone.baselineShift		= new String(baselineShift);
		if(null!=direction)			clone.direction			= new String(direction);
		if(null!=display)			clone.display			= new String(display);
		if(null!=dominantBaseline)	clone.dominantBaseline	= new String(dominantBaseline);
		if(null!=letterSpacing)		clone.letterSpacing		= new String(letterSpacing);
		if(null!=wordSpacing)		clone.wordSpacing		= new String(wordSpacing);
		if(null!=anchor)			clone.anchor			= new String(anchor);
		if(null!=decoration)		clone.decoration		= new String(decoration);
		if(null!=rendering)			clone.rendering			= new String(rendering);
		if(null!=mode)				clone.mode				= new String(mode);
		if(null!=font)				clone.font				= (SVGFontStyle)font.clone();
		
		return(clone);
	}
	
}