/**
 * @(#)SVGDocument.java
 * Copyright 2001 
 * @author  Intelligent Technology Inc.
 * @version 0.00 2001/08/14
 */
package jp.co.iti.fagot.xml;

/* java */

/* W3C DOM */
import	org.w3c.dom.Element;
//import	org.w3c.dom.Document;
//import	org.w3c.dom.Node;
//import	org.w3c.dom.NodeList;

/* fagot */
import	jp.co.iti.fagot.xml.SVGElement;
import	jp.co.iti.fagot.xml.SVGRect;

/* RID */
//import	jp.co.nri.rid.gob.GUnit;
import	jp.co.nri.rid.xml.XercesXML;

/**
 * SVGDocument
 */
public class SVGWorker	extends	XercesXML implements ISVG{
	protected	static	final	String	RootElementName	=	"svg";
//	WD
//	protected	static	final	String	PublicID		=	"-//W3C//DTD SVG 20001102//EN";
//	protected	static	final	String	SystemID		=	"http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd";

//	SVG1.0
	protected	static	final	String	PublicID		=	"-//W3C//DTD SVG 1.0//EN";
	protected	static	final	String	SystemID		=	"http://www.w3.org/TR/SVG/DTD/svg10.dtd";

//	SVG1.1
//	protected	static	final	String	PublicID		=	"-//W3C//DTD SVG 1.1//EN";
//	protected	static	final	String	SystemID		=	"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd";
	
	/**
	 * RXgN^
	 * @param	String RootElementName [gGg("ProjrctUnit")
	 * @param	String SystemID        VXeID("site.dtd")
	 * @return	none
//	 * @exception
//	 * @see
	 * @since	0.00
//	 * @deprecated 
	 * DOMc[VKɍ쐬
	 *   EdoctB[hɐVKɍ쐬DOMc[Documentݒ
	 *   EroottB[hɐVKɍ쐬DOMc[Document
	 *     [gGgݒ
	 */
	public SVGWorker(String x ,String y ,String width ,String height
	 ,String viewBox ,String preserveAspectRatio ,String zoomAndPan)
		throws
			 javax.xml.parsers.ParserConfigurationException
	{
		super(RootElementName ,PublicID ,SystemID);
		if(null!=x)						rootelement.setAttribute(X						,x);
		if(null!=y)						rootelement.setAttribute(Y						,y);
		if(null!=width)					rootelement.setAttribute(WIDTH					,width);
		if(null!=height)				rootelement.setAttribute(HEIGHT					,height);
		if(null!=viewBox)				rootelement.setAttribute(VIEWBOX				,viewBox);
		if(null!=preserveAspectRatio)	rootelement.setAttribute(PRESERVEASPECTRATIO	,preserveAspectRatio);
		if(null!=zoomAndPan)			rootelement.setAttribute(ZOOMANDPAN				,zoomAndPan);
	}
	
	public	void	setWidth(double width){
		rootelement.setAttribute(WIDTH	,String.valueOf(width));
	}
	
	public	void	setHeight(double height){
		rootelement.setAttribute(HEIGHT	,String.valueOf(height));
	}
	
	public	void	setXY(double x ,double y){
		rootelement.setAttribute(X	,String.valueOf(x));
		rootelement.setAttribute(Y	,String.valueOf(y));
	}
	
	public	void	setViewBox(double x ,double y ,double w ,double h){
		String viewbox = String.valueOf(x) + SEPARATOR
					   + String.valueOf(y) + SEPARATOR
					   + String.valueOf(w) + SEPARATOR
					   + String.valueOf(h);
		rootelement.setAttribute(VIEWBOX ,viewbox);
	}
	
	public	SVGRect	createRect(String x ,String y ,String width ,String height ,String rx ,String ry ,SVGStyle style){
		return(new SVGRect(doc ,x ,y ,width ,height ,rx ,ry ,style));
	}
	
	public	void	addRect(String x ,String y ,String width ,String height ,String rx ,String ry ,SVGStyle style){
		rootelement.appendChild(createRect(x ,y ,width ,height ,rx ,ry ,style));
	}
	
	public	SVGEllipse	createEllipse(String x ,String y ,String rx ,String ry ,SVGStyle style){
		return(new SVGEllipse(doc ,x ,y ,rx ,ry ,style));
	}
	
	public	void	addEllipse(String x ,String y ,String rx ,String ry ,SVGStyle style){
		rootelement.appendChild(createEllipse(x ,y ,rx ,ry ,style));
	}
	
	public	SVGLine	createLine(String x1 ,String y1 ,String x2 ,String y2 ,SVGStyle style){
		return(new SVGLine(doc ,x1 ,y1 ,x2 ,y2 ,style));
	}
	
	public	void	addLine(String x1 ,String y1 ,String x2 ,String y2 ,SVGStyle style){
		rootelement.appendChild(createLine(x1 ,y1 ,x2 ,y2 ,style));
	}
	
	public	SVGText	createText(String x ,String y ,String text ,SVGStyle style){
		return(new SVGText(doc ,x ,y ,text ,style));
	}
	
	public	void	addText(String x ,String y ,String text ,SVGStyle style){
		rootelement.appendChild(createText(x ,y ,text ,style));
	}
	
	public	SVGPolyline	createPolyline(SVGPolyPoints points ,SVGStyle style){
		return(new SVGPolyline(doc ,points ,style));
	}
	
	public	void	addPolyline(SVGPolyPoints points ,SVGStyle style){
		rootelement.appendChild(createPolyline(points ,style));
	}
	
	public	SVGPolygon	createPolygon(SVGPolyPoints points ,SVGStyle style){
		return(new SVGPolygon(doc ,points ,style));
	}
	
	public	void	addPolygon(SVGPolyPoints points ,SVGStyle style){
		rootelement.appendChild(createPolygon(points ,style));
	}
	
	public	SVGPath	createPath(SVGPathdata pathdata ,SVGStyle style){
		return(new SVGPath(doc ,pathdata ,style));
	}
	
	public	void	addPath(SVGPathdata pathdata ,SVGStyle style){
		rootelement.appendChild(createPath(pathdata ,style));
	}
}