/**
 * @(#)RLMEncoder.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * Ridual : Ridual License Module Encoder
 *
 * @author  Intelligent Technology Inc.
 * @version 1.00 2003/04/21
 */
package jp.co.nri.rid.rhedgehog;

import	java.io.*;
import	jp.co.iti.hedgehog.Hog;

/**
 */
public class RHog{
	public String	name	= null;
	public String	mail	= null;
	public String	pages	= null;
	public String	target	= null;
	public String	limit	= null;
	
	public boolean load(File file) throws IOException {
		FileInputStream fis = new FileInputStream(file);
		
		try{
			int len = fis.read();
			len += fis.read() * 0x100;
			
			byte[] bytes = new byte[len];
			
			
			if(fis.read(bytes) != len)	return false;
			if(0 <= fis.read())			return false;
			
			BufferedReader br = new BufferedReader(new StringReader(new String(new Hog().act(bytes))));
			
			try{
				name	= br.readLine();
				mail	= br.readLine();
				pages	= br.readLine();
				target	= br.readLine();
				limit	= br.readLine();
				if(!br.readLine().equals(name))		return false;
				if(!br.readLine().equals(mail))		return false;
				if(!br.readLine().equals(pages))	return false;
				if(!br.readLine().equals(target))	return false;
				if(!br.readLine().equals(limit))	return false;
				if(0 <= br.read())					return false;
			} finally{ br.close(); }
		}
		catch(Exception e){ return false; }
		finally { fis.close(); }
		
		return true;
	}
}
