/**
 * @(#)RLM.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * Ridual : Ridual License Module Encoder
 *
 * @author  Intelligent Technology Inc.
 * @version 1.00 2003/04/21
 */
package jp.co.nri.rid.rhedgehog;

import	java.io.*;
import	java.awt.*;
import	java.awt.event.*;
import	javax.swing.*;
import	javax.swing.border.TitledBorder;

import	jp.co.nri.rid.rhedgehog.panel.*;

/**
 */
public class RLMCraft extends JFrame {
	private static final String FILENAME = "rlm";
	private	JTextField	name	= new JTextField();
	private	JTextField	mail	= new JTextField();
	private	JTextField	page	= new JTextField();
	private	JTextField	target	= new JTextField();
	private	JTextField	limit	= new JTextField();
	private	JTextArea	mess	= new JTextArea(10, 22);
	private	File		file	= new File(System.getProperty("user.dir"), FILENAME);
	
	public RLMCraft(){
		super("RLM Craft 1.1.0");
		addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent evt){ System.exit(0); }
		});
		
		GridPanel panel = new GridPanel();
		
		JToolBar tool = new JToolBar();
		tool.add(new SaveAction());
//		tool.setBorder(BorderFactory.createEtchedBorder());
		panel.addComponent(tool);
		
		panel.addCaptionedComponent(" file", new JButton(new FileAction()));
		panel.addCaptionedComponent(" name", name);
		panel.addCaptionedComponent(" mail", mail);
		panel.addCaptionedComponent(" page", page);
		
		GridPanel child = new GridPanel();
		TitledBorder title = BorderFactory.createTitledBorder("option");
//		title.setTitlePosition(TitledBorder.BOTTOM);
		title.setTitleJustification(TitledBorder.RIGHT);
		child.setBorder(title);
		
		child.addCaptionedComponent(" target build ", target);
		child.addCaptionedComponent("time limit", limit);
		
		panel.addComponent(child);
		
		getContentPane().add(panel, BorderLayout.NORTH);
		
		mess.setEditable(false);
		getContentPane().add(new JScrollPane(mess), BorderLayout.CENTER);
		message("-\"Ridual License Module\" Craft-\n");
		message("name, mail, page͕K{(󗓂͕s).");
		message("option͋󗓉.");
		message("page0ɐݒ肷Ɩ(󗓂͕s).");
		message("target build̓rhԍ𐔎.");
		message("(ȊO͕s. #tȂ.)");
		message("time limityyyy/mm/dd`.");
	}
	
	public void show(){
		super.show();
		pack();
	}
	
	public static void main(String[] arg){ new RLMCraft().show(); }
	
	private class SaveAction extends AbstractAction{
		private RHedge encoder = new RHedge();
		
		public SaveAction(){ super("save"); }
		public void actionPerformed(ActionEvent evt){
			encoder.name	= name.getText();
			encoder.mail	= mail.getText();
			encoder.pages	= page.getText();
			encoder.target	= target.getText();
			encoder.limit	= limit.getText();
			
			try{ file.getParentFile().mkdirs(); }
			catch(NullPointerException e){}
			
			message("save " + file.getAbsolutePath());
			try{ encoder.save(file); }
			catch(IOException e){ message(e.toString()); }
		}
	}
	
	private class FileAction extends AbstractAction{
		private JFileChooser chooser = null;
		private RHog decoder = new RHog();
		
		public FileAction(){ super(file.getAbsolutePath()); }
		public void actionPerformed(ActionEvent evt){
	    	if (chooser == null) {
				chooser = new JFileChooser();
//				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			}
			
			chooser.setSelectedFile(file);
			File parent	= file.getParentFile();
			chooser.setCurrentDirectory( (null == parent) ? file : parent );
			if (chooser.showOpenDialog((Component)evt.getSource()) != JFileChooser.APPROVE_OPTION) return;
			
			File choose = chooser.getSelectedFile();
			
			if(choose.exists()){
				if(choose.isDirectory())	setFile(new File(choose, FILENAME));	// fBNg
				else{						// t@C
					setFile(choose);
					message("load " + file.getAbsolutePath());
					try{
						if(decoder.load(file)){
							message("`FbN:");
							name.setText(decoder.name);
							mail.setText(decoder.mail);
							page.setText(decoder.pages);
							target.setText(decoder.target);
							limit.setText(decoder.limit);
						} else	message("`FbN:ُ");
					} catch(IOException e){ message(e.toString()); }
				}
			} else	setFile(choose);		// t@CȂ
		}
		
		private void setFile(File fl){
			file = fl;
			putValue(NAME , file.getAbsolutePath());
		}
	}
	private void message(String msg){ mess.append(msg+"\n"); }
}
