/*
 * @(#)RidPane.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Draw Pane
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid;

import java.awt.Dimension;
import java.awt.Event;

import java.awt.event.MouseEvent;

import java.util.Vector;

import javax.swing.JViewport;

import javax.swing.KeyStroke;

import jp.co.iti.fagot.IZApp;

import jp.co.iti.fagot.action.ZFileAction;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;

import jp.co.iti.fagot.util.ZKeyMap;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.RUpdateManager;

import jp.co.nri.rid.doc.RidDocument;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElement;

import jp.co.nri.rid.action.RidClipAction;
import jp.co.nri.rid.action.RidUndoAction;

/**
 * Rid `pl
 */
public class RidPane extends DocPane {

	/**
	 * RXgN^
	 * @param panel plʎq
	 */
	public RidPane(String panelId){
	super(panelId);
	setToolTipText(panelId);
	}

	//## I[oCh #################################################
	/**
	 * `Gg̍XV
	 */
	public void createGobs() {
	String szPanelId = getPanelId();
	// Mapʂ̏ꍇAČvZĂ邩`FbNAČvZĂȂΎs
	if ( szPanelId.startsWith(Rid.PANEL_MAP) ) {
		RidDocumentSite doc = (RidDocumentSite)getDocument();
		if ( doc != null ) {
			DocElement root = (DocElement)doc.getRootElement(szPanelId);
			if ( root == null ) {
				return;
			}
			DocElement elm  = (DocElement)root.getChildElement(".ViewInfo."+szPanelId,null);
			String szCalc  = elm.getAttribute("Calc");
//			ZDebug.trace("Recalc:"+root.getAttribute("File")+"...szCalc:"+szCalc);
			if ( szCalc.length()==0 || szCalc.equals("none") ) {
				boolean isZoneBase = true;
				if ( szPanelId.endsWith("Circle") ) {
					isZoneBase = false;
				}
				ZRectangle rect = doc.recalcMap(szPanelId,isZoneBase);
				elm.setAttribute("Calc","done");

				// g嗦̕ύX
				if ( rect != null ) {
					updateLayout();
					repaint();
					return;
				}
			}
		}
	}

	super.createGobs();

	RUpdateManager.update(RUpdateManager.CREATE_GOBS);
	}

	/**
	 * plʎq̎擾
	 */
	public String getPanelId() {
	String szPanelId = super.getPanelId();
	if ( szPanelId.equals(Rid.PANEL_MAP) ) {
		DocDocument doc = getDocument();
		if ( doc != null ) {
			// ANeBupl̎擾
			DocElement top = ((RidDocument)doc).getTopZone();
			String szMapId = top.getChildElementAttribute(".ViewInfo.Map",null,"Active");
			if ( szMapId.length()>0 ) {
				szPanelId += "." + szMapId;
			} else {
				szPanelId += "." + "Site";
			}
		}
	}
	return szPanelId;
	}

	/**
	 * ftHgL[}bv𐶐܂
	 * @param app AvP[V
	 */
	public Vector createDefaultKeyMap(IZApp app) {
	Vector keyMap = new Vector();
	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke(Event.DELETE,0,false),
				app.getAction(RidClipAction.CUT) ) );
	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('X',Event.CTRL_MASK),
				app.getAction(RidClipAction.CUT) ) );

//	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('C',Event.CTRL_MASK),
//				app.getAction(ZClipAction.COPY) ) );
//	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('V',Event.CTRL_MASK),
//				app.getAction(ZClipAction.PASTE) ) );
	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('N',Event.CTRL_MASK),
				app.getAction(ZFileAction.NEW) ) );
	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('S',Event.CTRL_MASK),
				app.getAction(ZFileAction.SAVE) ) );
	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('O',Event.CTRL_MASK),
				app.getAction(ZFileAction.OPEN) ) );
	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('Z',Event.CTRL_MASK),
				app.getAction(RidUndoAction.UNDO) ) );
//	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('Y',Event.CTRL_MASK),
//				app.getAction(RidUndoAction.REDO) ) );
	keyMap.add( new ZKeyMap( KeyStroke.getKeyStroke('Z',Event.SHIFT_MASK + Event.CTRL_MASK),
				app.getAction(RidUndoAction.REDO) ) );
	return keyMap ;
	}

	/**
	 * c[`bv̎擾
	 * UI^̏ꍇAMetalToolTipUI.javaɂAL[Xg[N̐擪
	 * c[`bvEBhEɒǉ
	 */
	public String getToolTipText(MouseEvent evt) {
	ZPoint pt = new ZPoint(evt.getPoint());
	GElement gob = GobManager.getCurrentHitElement(this,pt);
	if ( gob == null ) {
		gob = GobManager.getHitElement(this,pt);
	}
	if ( gob != null && gob.getContainer() != null ) {
		DocElement dob = (DocElement)gob.getContainer();
		String text = dob.getAttribute("Key");
		if ( text.length() == 0 ) {
			text = dob.getTagName();
		}
//		ZDebug.trace("Tips:"+text);
//		ZDebug.printStack();
		return text;
	}
	return null;
	}

	//## Agr[g################################################
}
