/**
 * @(#)RidualScript.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-3 : Script GW
  *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/08/01
 */
package jp.co.nri;

import java.util.Vector;

import java.io.File;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.xml.GRootSVG;

import jp.co.iti.fagot.doc.DocDocument;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidDocumentSite;

import jp.co.nri.rid.action.RidToolAction;

import jp.co.nri.rid.table.RTable;

import jp.co.nri.rid.generator.GenerateCSV2;
/**
 * Ridual XNvg
 * T[oŃob`NɁAjavascriptƃC^[tFCXƂȂNXB
 * javascriptridualւ̃ANZX́AׂẴNXʂčsB
 */
public class RidualScript {

	/**
	 * RXgN^
	 */
	public RidualScript() {
	mApp = (Ridual)ZApp.getTheApp();
	mRes = mApp.getResource();
	}

	//## JnEI ###################################################
	/**
	 * Jn
	 * @param szLog Ot@C
	 * @return {|ُ}
	 */
	public boolean start( String szLog ) {
	// AvP[VOt@C̐ݒ
	String szDateTime = ZString.getDateTime();
	String[] szDts    = ZString.tokenize( ZString.replace(szDateTime," ","_"),"/:" );
	String szFile = ZFile.getParent(szLog) + File.separator + "log" + File.separator;
	String szTrcFile = "";
	for ( int nAt=0 ; nAt<szDts.length ; nAt++ ) {
		szTrcFile += szDts[nAt];
	}
	szTrcFile += ".log" ;
	ZDebug.trace( szFile + szTrcFile );
	ZDebug.setTraceFile( szFile + szTrcFile );

	ZDebug.trace("rid-x dir:"+mRes.getString("app.install.path"));
	ZDebug.trace("version  :"+mApp.getVersionInfo());

	mLog = new RidualLog( szLog, szTrcFile, szDateTime );
	return true;
	}

	/**
	 * I
	 * @param bRet {|ُ}
	 */
	public void end( boolean bRet ) {
	if ( mLog != null ) {
		mLog.end( bRet );
	}
	}

	//## t@Cn@\ ###############################################
	/**
	 * J
	 * @param szFile JovWFNgt@C|vWFNgfBNgp
	 * @return {|ُ}
	 */
	public boolean open( String szFile ) {
	boolean bRet = true;
	if ( mLog != null ) {
		String szPfx = mRes.getString("app.install.path") + File.separator + 
					   mRes.getString("app.project.dir")  + File.separator ;
		String szPrj = szFile.substring( szPfx.length() );

		bRet = mLog.start( szPrj );
	}
	if ( bRet ) {
		bRet = mApp.open( szFile );
	}
	return bRet;
	}

	/**
	 * ۑ
	 * @return {|ُ}
	 */
	public boolean save() {
	boolean bRet = false;
	if ( mLog != null ) {
		if ( mLog.check() ) {
			bRet = mApp.save();
		}
	}
	return bRet;
	}

	//## c[n@\ #################################################
	/**
	 * C|[g
	 * @return {|ُ}
	 */
	public boolean execImport() {
	RidToolAction act = new RidToolAction(mApp,RidToolAction.IMPORT);
	return execToolAction( act );
	}

	/**
	 * AiCY
	 * @return {|ُ}
	 */
	public boolean execAnalyze() {
	RidToolAction act = new RidToolAction(mApp,RidToolAction.ANALYZE_HTML);
	return execToolAction( act );
	}

	/**
	 * 
	 * @return {|ُ}
	 */
	public boolean execGenerate() {
	RidToolAction act = new RidToolAction(mApp,RidToolAction.GENERATE);
	return execToolAction( act );
	}

	/**
	 * ANZXO
	 * @return {|ُ}
	 */
	public boolean execAccessLog() {
	RidToolAction act = new RidToolAction(mApp,RidToolAction.ACCESSLOG);
	return execToolAction( act );
	}

	/**
	 * c[n
	 * @param act sANV
	 * @return {|ُ}
	 */
	protected boolean execToolAction( RidToolAction act ) {
	ZDebug.trace("--- "+act.getActionName()+" start");
	mThrowable = act.execTool();
	if ( mThrowable!=null ) {
		ZDebug.trace("Error:"+mThrowable);
	}
	ZDebug.trace("--- "+act.getActionName()+" end");
	return ( mThrowable==null );
	}

	//## SVGo͌n@\ ################################################
	/**
	 * SVGo(Zone)
	 * @param szFile    o̓t@C
	 * @return {|ُ}
	 */
	public boolean outputZoneSvg( String szFile ) {
	return outputSvg(Rid.PANEL_ZONE, szFile);
	}

	/**
	 * SVGo(Map)
	 * @param szMap     Mapʎq
	 * @param bRecalc   ČvZL
	 * @param szFile    o̓t@C
	 * @return {|ُ}
	 */
	public boolean outputMapSvg( String szMapId, boolean bRecalc, String szFile ) {
	String szPanelId = Rid.PANEL_MAP + "." + szMapId ;
	if ( bRecalc ) {
		RidDocumentSite doc   = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
		boolean isZoneBase = true;
		if ( szMapId.endsWith("Circle") ) {
			isZoneBase = false;
		}
		doc.recalcMap(szPanelId,isZoneBase);
	}
	return outputSvg(szPanelId, szFile);
	}

	/**
	 * SVGo
	 * @param szPanelId plʎq
	 * @param szFile    o̓t@C
	 * @return {|ُ}
	 */
	protected boolean outputSvg( String szPanelId, String szFile ) {
	boolean bRet = true;

	RidDocumentSite doc   = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
	Vector gobs = doc.createGobs(szPanelId);
	try {
		ZDebug.trace("--- OutputSvg:"+szPanelId+" -> "+szFile);
		GRootSVG svg = new GRootSVG(gobs);
		svg.writeto(szFile ,null);
	} catch ( Exception evt ) {
		bRet = false;
	}
	return bRet;
	}

	//## CSVo͌n@\ ################################################
	/**
	 * CSVo
	 * @param szPanelId plʎq
	 * @param szFile    o̓t@C
	 * @return {|ُ}
	 */
	public boolean outputCsv( String szPanelId, String szFile ) {
	boolean bRet = true;

	String szPanel  = null ;
	DocDocument doc = null ;
	if ( szPanelId.equals("List") ) {
		szPanel = "table.pages";
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
	} else if (szPanelId.equals("Resource") ) {
		szPanel = "table.resources";
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
	} else if (szPanelId.equals("Document") ) {
		szPanel = "table.documents";
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
	} else if (szPanelId.equals("PageResource") ) {
		szPanel = "table.linkedpages";
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
	} else {
		ZDebug.trace("unknown panelId:"+szPanelId);
		return false;
	}

	RTable table = new RTable(szPanel);
	table.reload( doc );
	try {
		// csvo͌Ăяo
		ZDebug.trace("--- OutputCsv:"+szPanelId+" -> "+szFile);
		GenerateCSV2 csv = new GenerateCSV2();
		csv.generateCSV(table, szFile);
	} catch ( Exception evt ) {
		bRet = false;
	}
	return bRet;
	}


	//## vpeB ###################################################
	/**
	 * vpeB̐ݒ
	 * @param szKey \[Xl
	 * @param bVal  ^l
	 */
	public void setProperty( String szKey, boolean bVal ) {
	mRes.putBoolean( szKey, bVal );
	}

	/**
	 * vpeB̐ݒ
	 * @param szKey \[Xl
	 * @param szVal l
	 */
	public void setProperty( String szKey, String szVal ) {
	mRes.putString( szKey, szVal );
	}

	//## Agr[g ###############################################
	/**
	 * AvP[V
	 */
	protected Ridual mApp = null;

	/**
	 * AvP[V
	 */
	protected ZResource mRes = null;

	/**
	 * G[̗O
	 */
	protected Throwable mThrowable = null;

	/**
	 * O
	 */
	protected RidualLog mLog = null;
}
