/*
 * @(#)RidClipAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid clip action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid.action;

import java.awt.event.ActionEvent;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;
/**
 * RidNbv{[hnANV`
 */
public class RidClipAction extends ZAction {
	/**
	 * B̃RXgN^łB
	 * @param app AvP[V
	 * @param szAction ANV
	 */
	public RidClipAction(IZApp app,String szAction) {
    super(app,szAction);
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {

	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͂Ƃ肠삵Ȃ
		return;
	}
	DocPane editor = (DocPane)active;
	editor.getDocument().beginTransaction();

	// ][pl̑IĂGOB擾
	if ( getActionName().equals( CUT ) || getActionName().equals( COPY  ) ) {
		Vector gobs = GobManager.getSelectedElement(editor.getPanelId());
		Enumeration elm = gobs.elements();
		while ( elm.hasMoreElements() ) {
			GElement   gob = (GElement)elm.nextElement();
			gob.removeContainer();
//			DocElement dob = (DocElement)gob.getContainer();
//			dob.removeFromDocTree();
		}
	}
	
	editor.getDocument().commit();
	editor.updateGobs();
	editor.repaint();
	}

	/**
	 * UIXV
	 */
	public void update() {
	boolean bState = false;
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͓삵Ȃ
		firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
		return;
	}
	DocPane editor = (DocPane)active;
	Vector gobs = GobManager.getSelectedElement(editor.getPanelId());
	if ( gobs.size() > 0 ) {
		bState = true;
	}
	firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
	}

	//## Agr[g ###############################################
    /**
     * ANVFJbg
     */
	static final public String CUT		= "cut" ;

    /**
     * ANVFRs[
     */
	static final public String COPY		= "copy" ;

    /**
     * ANVFy[Xg
     */
	static final public String PASTE	= "paste" ;
}
