/*
 * @(#)RidListAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid gob action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid.action;

import java.awt.event.ActionEvent;

import java.io.File;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JFileChooser;

import javax.swing.JTable;
import javax.swing.table.TableModel;

import org.w3c.dom.Node;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.xml.GRootSVG;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocDocument;

import jp.co.iti.fagot.util.ZFileFilter;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZReverseEnumeration;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.doc.RidElementPage;

import jp.co.nri.rid.export.ExportCsvDialog;

import jp.co.nri.rid.generator.GenerateCSV;
import jp.co.nri.rid.generator.GenerateCSV2;
import jp.co.nri.rid.search.SearchPanel;
/**
 * Rid ListnANV`
 */
public class RidListAction extends RidGobAction {
    /**
     * B̃RXgN^łB
     * @param app AvP[V
     * @param szAction ANV
     */
    public RidListAction(IZApp app,String szAction) {
    super(app,szAction);
    }

    /**
     * ANVs
     */
    public void doAction(ActionEvent e) {
    ZResource res = getApp().getResource();

    if ( getActionName().equals(CSV_PANEL) ) {
        String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
        JComponent active = (JComponent)ZInstance.map().get(szTitle);
        if ( !(active instanceof JTable) ) {
            if (active instanceof SearchPanel) {
                active = ((SearchPanel)active).getTable();
            } else {
                /* ANeBuplXgplłȂꍇ
                 * Ƃ肠삵Ȃ
                 */
                return;
            }
        }

        JTable table = (JTable)active;

        String szFile = openFileDialog("csv","CSV File","rid.csv.dir");
        if ( szFile != null ) {
            try {
                // csvo͌Ăяo
                GenerateCSV2 csv2 = new GenerateCSV2();
                csv2.generateCSV(table, szFile);

            } catch ( Exception evt ) {
                ZDebug.err("Write csv failed:");
                evt.printStackTrace();
            }

            // o̓fBNg̊mF
            String szDocsDir = null;
            String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
            if ( szPjDir != null ) {
                szDocsDir = szPjDir + File.separator + res.getString("rid.docs.dir");
                String szCompare = szFile.substring(0,Math.min(szFile.length(),szDocsDir.length()));
                if ( szCompare.equalsIgnoreCase(szDocsDir) ) {
                    // Rg
                    ExportCsvDialog csvd = new ExportCsvDialog();
                    csvd.show(szFile);
                }
            }
        }

    // ÓICSVo
    } else if ( getActionName().equals( CSV_SITE )      ||
                getActionName().equals( CSV_RESOURCE )  ||
                getActionName().equals( CSV_DOCUMENT )  ) {

        String szFile = openFileDialog("csv","CSV File","rid.csv.dir");
        if ( szFile != null ) {
            try {
                // __shirono edit start

                GenerateCSV csv = new GenerateCSV();

                DocDocument doc = null;
                if ( getActionName().equals( CSV_SITE ) ) {
                    doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
                    csv.csvSite(doc,szFile);

                } else if ( getActionName().equals( CSV_RESOURCE ) ) {
                    doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
                    csv.csvResource(doc,szFile);

                } else if ( getActionName().equals( CSV_DOCUMENT ) ) {
                    doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
                    csv.csvDocument(doc,szFile);

                }
                // __shirono edit end

            } catch ( Exception evt ) {
                ZDebug.err("Write csv failed:");
                evt.printStackTrace();
            }

            // o̓fBNg̊mF
            String szDocsDir = null;
            String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
            if ( szPjDir != null ) {
                szDocsDir = szPjDir + File.separator + res.getString("rid.docs.dir");
                String szCompare = szFile.substring(0,Math.min(szFile.length(),szDocsDir.length()));
                if ( szCompare.equalsIgnoreCase(szDocsDir) ) {
                    // Rg
                    ExportCsvDialog csvd = new ExportCsvDialog();
                    csvd.show(szFile);
                }
            }
        }
    }
    }

    /**
     * UIXV
     */
    public void update() {
    boolean bState = true;

    if ( getActionName().equals(CSV_PANEL) ) {
        String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
        JComponent active = (JComponent)ZInstance.map().get(szTitle);
        if ( !(active instanceof JTable) && !(active instanceof SearchPanel) ) {
            // ANeBuplXgplłȂꍇ͂Ƃ肠삵Ȃ
            bState = false;
        }
    }

    firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
    }

    //## Agr[g ###############################################
    /**
     * ANVFcsvóFANeBupl
     */
    static final public String CSV_PANEL    = "csv_panel" ;

    /**
     * ANVFcsvóFsite.xml
     */
    static final public String CSV_SITE     = "csv_doc_site" ;

    /**
     * ANVFcsvóFresource.xml
     */
    static final public String CSV_RESOURCE = "csv_doc_resource" ;

    /**
     * ANVFcsvóFdocument.xml
     */
    static final public String CSV_DOCUMENT = "csv_doc_document" ;
}
