/*
 * @(#)RidUndoAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid undo action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid.action;

import java.awt.event.ActionEvent;

import javax.swing.JComponent;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocDocument;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.RUpdateManager;

import jp.co.nri.rid.doc.RidDocumentSite;

import jp.co.nri.rid.table.RTable;
/**
 * Rid UndonANV`
 */
public class RidUndoAction extends ZAction {
	/**
	 * B̃RXgN^łB
	 * @param app AvP[V
	 * @param szAction ANV
	 */
	public RidUndoAction(IZApp app,String szAction) {
    super(app,szAction);
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {

	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	DocDocument doc = null ;
	if ( szTitle.equals(Rid.PANEL_DOCUMENTS) ) {
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
	} else if ( szTitle.equals(Rid.PANEL_RESOURCES) ) {
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
	} else {
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
	}

	// do
	if ( getActionName().equals( UNDO ) ) {
		doc.doUndo();
		((RidDocumentSite)doc).requestUpdateAccessCount();
	} else if ( getActionName().equals( REDO ) ) {
		doc.doRedo();
		((RidDocumentSite)doc).requestUpdateAccessCount();
	}
	
	// ĕ`
	RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
	}

	/**
	 * UIXV
	 */
	public void update() {
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	DocDocument doc = null ;
	if ( szTitle.equals(Rid.PANEL_DOCUMENTS) ) {
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
	} else if ( szTitle.equals(Rid.PANEL_RESOURCES) ) {
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
	} else {
		doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
	}

	// ₢킹
	boolean bState = false;
	if ( getActionName().equals( UNDO ) ) {
		bState = doc.canUndo();
	} else if ( getActionName().equals( REDO ) ) {
		bState = doc.canRedo();
	}

	firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
	}

	//## Agr[g ###############################################
    /**
     * ANVFundo
     */
	static final public String UNDO		= "undo" ;

    /**
     * ANVFredo
     */
	static final public String REDO		= "redo" ;
}
