/**
 * @(#)BaseURL.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * Base URL
 * @author  Intelligent Technology Inc.
 * @version 1.00 2003/07/03
 */
package	jp.co.nri.rid.analyzer;

import	java.util.*;

// W3C DOM
import	org.w3c.dom.*;

/**
 */

public class LinkedPageList{
	private static final String	LINKEDPAGE		= "LinkedPage";
	private static final String	LINKEDPAGEUNIT	= "LinkedPageUnit";
	private static final String	PAGE			= "Page";
	private static final String	RESOURCE		= "Resource";
	
	private Hashtable	list = null;
	private String		from = null;
	private NodeList	linkedPageNodeList;
	private Document	document;
	private Element		linkedPageTag;
	
	public LinkedPageList(Element root){
		document			= root.getOwnerDocument();
		linkedPageTag		= getLinkedPageTag(root);
		linkedPageNodeList	= linkedPageTag.getElementsByTagName(LINKEDPAGEUNIT);
	}
	
	/**
	 * N悪tõNjbgԂ.
	 * 
	 * @param	to	N
	 * 
	 * @return	Njbg
	 */
	
	public Element get(String to){
		if(null == list)	buildList();
		return (Element)list.get(to.toLowerCase());
		
	}
	
	/**
	 * ÑXgZbg.
	 * <br>
	 * ̃\bhł̓Njbg̎W͂ȂȂ.<br>
	 * NjbgresetŏgetŎW.
	 * 
	 * @param	from	N
	 * 
	 */
	public void reset(String from){
		this.from	= from;
		list		= null;
	}
	
	/**
	 * Njbgǉ.
	 * <br>
	 * Njbg쐬hLgANXgoɒǉ.<br>
	 * NresetŐݒ肳ꂽ̂g.<br>
	 * 
	 * @param	to	N
	 * 
	 */
	public Element appendUnit(String to){
		Element linkedpageunit	= document.createElement(LINKEDPAGEUNIT);
		
		linkedpageunit.setAttribute(PAGE	,from);
		linkedpageunit.setAttribute(RESOURCE,to);
		
		linkedPageTag.appendChild(linkedpageunit);
		list.put(to.toLowerCase(), linkedpageunit);
		
		return linkedpageunit;
	}
	
	private Element getLinkedPageTag(Element root){
		NodeList	nl	= root.getChildNodes();
		
		Element		linkedpagetag	= null;
		Node		n;
		for(int i = nl.getLength() - 1; 0 <= i; i--){
			 n = nl.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			
			if( LINKEDPAGE.equals(n.getNodeName()) ){
				linkedpagetag = (Element)n;
				break;
			}
		}
		
		if(null==linkedpagetag){
			linkedpagetag	= document.createElement(LINKEDPAGE);
			root.appendChild(linkedpagetag);
		}
		
		return linkedpagetag;
	}
	
	private void buildList(){
		list = new Hashtable();
		
		for(int i = linkedPageNodeList.getLength() - 1; 0 <= i;i--){
			Element linkedpageunit = (Element)linkedPageNodeList.item(i);
			String page = linkedpageunit.getAttribute(PAGE);
			try{
				if( !from.equalsIgnoreCase(page) )	continue;
				String resource = linkedpageunit.getAttribute(RESOURCE);
				list.put(resource.toLowerCase(), linkedpageunit);
			}catch(NullPointerException e){}
		}
	}
}
