/**
 * @(#)SSIMappingScript.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : SSI Mapping Script
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/05/02
 * @see 
 */
package	jp.co.nri.rid.analyzer;

import	jp.co.nri.*;
import	jp.co.iti.fagot.*;
import	jp.co.iti.fagot.util.*;
import	jp.co.nri.rid.xml.*;
import	jp.co.nri.rid.importer.*;
import	java.net.*;
import	java.io.*;
import	java.util.*;
import	jp.co.nri.rid.error.*;

/**
 * SSIn̑l͂NX
 */

public class SSIMappingScript implements iMappingScript ,iExceptionCode{
	private static final String[]	names = { "comment.comment" };
	
	private	ResourceMappingScript myResourceMS;
	
//--------[[ constructor ]]----------------------------------------------------
	/**
	 * @param	root	MappingXML̃[gElement
	 * @see		elementBooster
	 */
//	public SSIMappingScript(elementBooster root, BaseURL baseURL)
//	{ myResourceMS	= new ResourceMappingScript(root, baseURL); }
	public SSIMappingScript(elementBooster root, ResourceMappingScript res)
	{ myResourceMS	= res; }
	
//--------[[ open method ]]----------------------------------------------------
	/**
	 * ScriptcatchattributeB
	 * @return	attributez
	 * @since	1.00
	 */
	public String[] names(){ return names; }
	
	/**
	 * names\bhattributehitƂɋNB
	 * @param	file	HTMLt@C
	 * @param	name	attribute
	 * @param	text	attributel
	 */
	public void hit(String file ,String name ,elementBooster element) throws RidException ,RWarningException{
		String text = element.text();
		if(null==text)	return;
		
		SSIString ssistring	= new SSIString(text);
		switch(ssistring.getCommand()){
			case SSIString.EXEC:
				elementBooster execelement = element.newElement("exec");
				execelement.attribute("cmd" ,pureURL(ssistring.getAttribute("cmd")));
				execelement.attribute("cgi" ,pureURL(ssistring.getAttribute("cgi")));
				myResourceMS.hit(file ,"exec" ,execelement);
				break;
			case SSIString.INCLUDE:
				elementBooster includeelement = element.newElement("include");
				includeelement.attribute("file" ,pureURL(ssistring.getAttribute("file")));
				includeelement.attribute("virtual" ,pureURL(ssistring.getAttribute("virtual")));
				myResourceMS.hit(file ,"include" ,includeelement);
		}
	}
	
	private String pureURL(String url){
		try{
			StringTokenizer tokenizer = new StringTokenizer(url," ?");
			return tokenizer.nextToken();
		}catch(NullPointerException e){ return null; }
	}
}
