/*
 * @(#)RidElementComment.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Element
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.Color;

import java.util.Vector;

import javax.swing.JComponent;

import org.w3c.dom.DOMException;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.fob.FColor;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.geom.ZPath;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GString;
import jp.co.iti.fagot.gob.GOperation;

import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocPane;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.RUpdateManager;
/**
 * Rid Element(Commentp)
 */
public class RidElementComment extends RidElement {

	/**
	 * ftHgRXgN^
	 */
	public RidElementComment() throws DOMException {
	}

	//## IGobContainerFqbg ########################################
	/**
	 * _uNbN̓
	 * @param gob  NGXgGob
	 * @param mode NbNʒu
	 */
	public void verbDblClick(GElement gob,ZPoint pt) {
	ZRectangle rect = gob.getTransformedBounds();

	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͕`悵Ȃ
		return;
	}

	DocPane editor = (DocPane)active;
	rect.setWidth( Math.max(300,rect.getWidth()) );
	rect.setY( rect.getY() - DIFF );
	rect.setHeight( rect.getHeight() + DIFF*2 );
	editor.setEditElement(this,rect,false);
	}

	//## IGobContainerFړ ##########################################
	/**
	 * ړPath̎擾
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPath(GElement gob,DocGridControler grid) {
	ZPath path = null;
	switch ( grid.getMoveMode() ) {
	  case GOperation.NEW:		// VK쐬
		// 傫͕ςȂ
		ZPoint pt = grid.getMoveGrid();
		ZRectangle rect = new ZRectangle( pt.getX(),pt.getY(),300,getTitleHeight()+DIFF*2);
		path = new ZPath( rect );
		break;
	  default:
		path = super.getMovingPath(gob,grid);
		break;
	}
	return path;
	}

	/**
	 * ړ̊
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveEnd(GElement gob,DocGridControler grid) {

	// Mapʂ̏ꍇ̓gbvy[Wɒǉ
	DocPane editor = grid.getEditor();
	if ( editor.getPanelId().startsWith("Map") ) {
		ZRectangle rect = new ZRectangle(getMovingPath(gob,grid).getBounds2D());
		switch ( grid.getMoveMode() ) {
		  case GOperation.NEW:		// VK쐬
			// ǉ
			RidDocumentSite doc = (RidDocumentSite)editor.getDocument();
			RidElementPage  top = doc.getTopPage(editor.getPanelId());
			if ( top == null ) {
				return;
			}
			// gbvy[WփRg̐ݒ
			setAttribute("Creator","Operator");
			setSelect(null,true);
			setDocument( doc );
			DocElement elm = (DocElement)top.getChildElement(".Comments",null);
			elm.appendChild( this );
			break;
		}
		setRect( editor.getPanelId(),rect ) ;

	} else {
		super.moveEnd(gob, grid);
	}

	switch ( grid.getMoveMode() ) {
	  case GOperation.NEW:		// VK쐬
		// getRect()̋`́A][WɕϊĂ܂Ă邩Ȃ̂
		// ēx`擾
		ZRectangle rect = new ZRectangle(getMovingPath(gob,grid).getBounds2D());
		editor.setEditElement(this,rect,false);

		break;
	}
	}

	//## ` #########################################################
	/**
	 * `Gg̎擾
	 *
	 * [g̏ꍇ́AgwiƂĕ`悷
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createGobs(String szPanelId,boolean isRoot) {
	Vector gobs = new Vector();

	// gobId̐ݒ
	String szGobId = "zone";
	if ( szPanelId.startsWith("Map") ) {
		szGobId = "map";
	} else if ( szPanelId.equals("Page") ) {
		szGobId = "page";
	}

	// g̍쐬
	String szText = getText();
//	ZDebug.trace(szText);
	if ( hasRect(szPanelId) && szText != null && szText.length()>0 ) {
//		ZDebug.trace("Name="+szText);
		GString gStr = new GString();
		gStr.setEditOption(0x0001);	// NORESIZE

		gStr.setText( szText );
		gStr.getStyle().setFillColor( new FColor( Color.black ));
		gStr.setFormat( GString.LEFT|GString.TOP );
//		gStr.setFormat( GString.MIDDLE|GString.CENTER );

		// ␳FTextFieldƂ̍
		ZRectangle rect = getRect(szPanelId);

		// ␳FTCYƓɂ
		ZDimension dim = getTextPreferredSize(null,0,szText,null,0) ;
		rect.setWidth(  dim.getWidth() );
		rect.setHeight( dim.getHeight() );

		gStr.setRect( rect );
		gStr.setSelect(isSelect());
		gStr.setContainer(this);
		gStr.setGobId(szGobId);
		setMainGob("comment",gStr);
		gobs.add(gStr);
	}
	return gobs;
	}

	/**
	 * `Gg̎擾
	 *
	 * [g̏ꍇ́AgwiƂĕ`悷
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createSkeltonGobs(String szPanelId,boolean isRoot) {
	return new Vector();
	}

	//## ҏW #########################################################
	/**
	 * Agr[g̐ݒ
	 */
	public void setAttribute(String name,String value) {
	if ( name.equals("Comment" ) ) {
		if ( value == null || value.length()==0 ) {
			// Rg̍폜
//			ZDebug.trace("remove");
			removeFromDocTree();

		// Rg폜ꂽƂɃvpeBplύX邽߂
		// IȂɐݒ肷
			GElement gob = getMainGob("comment");
			if ( gob != null ) {
				gob.setSelect(false);
			}
			RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
		}
	}
	super.setAttribute( name, value );
	}

	/**
	 * Agr[g̍폜
	 */
	public void removeAttribute(String name) {
	if ( name.equals("Comment" ) ) {
		// Rg̍폜
//		ZDebug.trace("remove");
		super.removeAttribute( name );
		removeFromDocTree();

		// Rg폜ꂽƂɃvpeBplύX邽߂
		// IȂɐݒ肷
		GElement gob = getMainGob("comment");
		if ( gob != null ) {
			gob.setSelect(false);
		}
		RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
	} else {
		super.removeAttribute( name );
	}
	}

	/**
	 * ̐ݒ
	 */
	public void setText(String szText) {
	setAttribute("Comment",szText);
	}

	/**
	 * ̎擾
	 */
	public String getText() {
//	ZDebug.trace(getAttribute("Comment"));
	return 	getAttribute("Comment");
	}

	//## Agr[g################################################
	/**
	 * ̍ƁATextField̍̍
	 *  DIFF*2;
	 */
	static protected double DIFF = 3;
}
