/*
 * @(#)RidO3WAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : O3Wn Action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.event.ActionEvent;

import java.io.File;

import java.util.Vector;

import javax.swing.JFileChooser;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZFileFilter;

import jp.co.nri.Rid;
import jp.co.nri.Ridual;

import jp.co.nri.rid.o3w.O3W_Exporter;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;
/**
 * Rid O3Wn Action
 */
public class RidO3WAction extends RidAction {

	/**
	 * ftHgRXgN^
	 */
	public RidO3WAction() {
	}

	//## Agr[g################################################
	/**
	 * ANVs
	 */
	public void doAction(ActionEvent evt) {
//	ZDebug.trace("actionName:"+getActionName());
	ZResource res = getApp().getResource();
	if ( getActionName().equals( EXPORT ) ) {
		// ][pl̑IĂGOB擾
		Vector gobs = GobManager.getSelectedElement(Rid.PANEL_ZONE);
		GElement item = (GElement)gobs.firstElement();
		RidElementZone zone = (RidElementZone)item.getContainer();
		ZDebug.trace("Zone:"+zone.getAttribute("Name"));

//		String szFile = ZInstance.prop().getProperty(Rid.PJ_DIR) + File.separator
//					  + res.getString("rid.html.dir")            + File.separator
		String szFile = Ridual.getHtmlDir() + File.separator
					  + ZString.replace( zone.getAttribute("File"), "/", "\\" ) + File.separator
					  + zone.getAttribute("ControlId") + ".xml" ;
		ZDebug.trace("XML File:"+szFile);

		try {
			O3W_Exporter o3w = new O3W_Exporter();
			o3w.Export(zone,szFile);
		} catch ( Exception e ) {
			RidMessage ridMsg = new RidMessage();
			MessageDialog.showError(ridMsg.Error("E1110",e.toString()));
		}
/*
		String szDir  = ZString.replace( zone.getAttribute("File"), "/", "\\" ) ;
		String szFile = openFileDialog("xml","XML File",szDir);
		if ( szFile != null ) {
			ZDebug.trace("XML File:"+szFile);
		}
*/
	}
	}

	/**
	 * UIXV
	 */
	public void update() {
	boolean bState = true;
	if ( getActionName().equals( EXPORT ) ) {
		// ][pl̑IĂGOB擾
		Vector gobs = GobManager.getSelectedElement(Rid.PANEL_ZONE);
		GElement item = (GElement)gobs.firstElement();
		RidElementZone zone = (RidElementZone)item.getContainer();
		if ( zone.getAttribute("ControlId").length() == 0 ) {
			bState = false;
		}
	}
	firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
	}

	//## _CAO ###################################################
	/**
	 * t@CI_CAO
	 * @param szExt
	 * @param szExtName
	 * @param szOutDir
	 */
/*
	public String openFileDialog(String szExt, String szExtName, String szOutDir) {
	ZResource res = getApp().getResource();
	JFileChooser dlg = new JFileChooser();
	// t@CtB^̐ݒ
	dlg.setFileFilter(new ZFileFilter( new String(szExt), szExtName));

	// JgfBNg̐ݒ
	String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
	String szDir = res.getString("app.install.path");
	if ( szPjDir != null ) {
		szDir = szPjDir + File.separator
			  + res.getString("rid.html.dir") + File.separator
			  + szOutDir ;
	}
	dlg.setCurrentDirectory(new File(szDir)) ;

	// _CAOJ
	int nRet = dlg.showSaveDialog(getApp().getFrame());
	String szFile = null ;
	if ( nRet == JFileChooser.APPROVE_OPTION) {
		// t@C擾
		File fFile = dlg.getSelectedFile();
		try {
			szFile = fFile.getCanonicalPath();
	    } catch ( java.io.IOException evt) {
			szFile = fFile.getAbsolutePath();
		}

		if( szFile != null ){
			if ( !szFile.endsWith("."+szExt) ) {
				szFile += "."+szExt;
			}
		}
	}

	// t@C̍XV
	// ͍XVȂAdlg.setCurrentDirectorysăfBNg
	// ύXɂȂƃj[\ŃG[ł邽߁AŃt@CXV
	getApp().updateRecent( null );

	return szFile;
	}
*/

	//## Agr[g ###############################################
    /**
     * GNX|[g
     */
	final static public String EXPORT	= "o3w_export" ;
}
