/*
 * @(#)CleanupDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X FN[Abv_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/02/14
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

/**
 * N[Abv_CAO
 */

public class CleanupDialog {

    /** cleanup.pagevpeB  **/
    final static public String CLEANUP_PAGE     = "cleanup.page";
    /** env.firscleanup.resourcetvpeB  **/
    final static public String CLEANUP_RESOURCE = "cleanup.resource";
    /** cleanup.documentvpeB  **/
    final static public String CLEANUP_DOCUMENT = "cleanup.document";
    /** msg.cleanup.titlevpeB  **/
    final static public String MSG_CLEANUP_TITLE    = "msg.cleanup.title";
    /** msg.cleanup.cleanupvpeB  **/
    final static public String MSG_CLEANUP_CLEANUP  = "msg.cleanup.cleanup";
    /** msg.cleanup.pagevpeB  **/
    final static public String MSG_CLEANUP_PAGE     = "msg.cleanup.page";
    /** msg.cleanup.resourcevpeB  **/
    final static public String MSG_CLEANUP_RESOURCE = "msg.cleanup.resource";
    /** msg.cleanup.documentvpeB  **/
    final static public String MSG_CLEANUP_DOCUMENT = "msg.cleanup.document";

    /** Cpl              **/
    protected JPanel    mPanel           = null;
    /** JCheckBox (y[Wj       **/
    protected JCheckBox mCleanUpPage     = null;
    /** JCheckBoxi\[Xj     **/
    protected JCheckBox mCleanUpResource = null;
    /** JCheckBoxihLgj **/
    protected JCheckBox mCleanUpDocument = null;

    /**
      * ftHgRXgN^
      */
      public CleanupDialog() {  }

    /**
      * N[Abv_CAO
      *
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean show() {

        ZResource res = ZApp.getTheApp().getResource();

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog gdlg = new EnvDialog(frame, res.getString(MSG_CLEANUP_TITLE));

        //CR|[lg
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill       = GridBagConstraints.BOTH;
        gbc.insets     = new Insets(10,10,10,10) ;

        //x
        gbc.gridy      = 0;
        gbc.gridx      = 0;
        gbc.gridwidth  = 1;
        gbc.gridheight = 1;
        JLabel label = new JLabel(res.getString(MSG_CLEANUP_CLEANUP));
        mLayout.setConstraints(label, gbc);
        mPanel.add( label );

        //TCg`FbN{bNX
        gbc.gridy      = 0;
        gbc.gridx      = 1;
        mCleanUpPage = createCleanUpCheckBox(res.getString(MSG_CLEANUP_PAGE), CLEANUP_PAGE);
        mLayout.setConstraints(mCleanUpPage, gbc);
        mPanel.add( mCleanUpPage );

        //\[X`FbN{bNX
        gbc.gridy      = 0;
        gbc.gridx      = 2;
        mCleanUpResource = createCleanUpCheckBox(res.getString(MSG_CLEANUP_RESOURCE), CLEANUP_RESOURCE);
        mLayout.setConstraints(mCleanUpResource, gbc);
        mPanel.add( mCleanUpResource );

        //hLg`FbN{bNX
        gbc.gridy      = 0;
        gbc.gridx      = 3;
        mCleanUpDocument = createCleanUpCheckBox(res.getString(MSG_CLEANUP_DOCUMENT), CLEANUP_DOCUMENT);
        mLayout.setConstraints(mCleanUpDocument, gbc);
        mPanel.add( mCleanUpDocument );

        // [CR|[lg][OK][CENCEL]
        gdlg.setControlPanel(mPanel);

        //_CAO\i[_j
        gdlg.doModal();

        // []{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            setCleanUpResource();
        }
        return ret;
    }

    /**
      * N[Abṽ`FbN{bNX쐬
      *
      * @param  String      label         x
      * @param  String      resource      \[X
      * @return JCheckBox
      */
    private JCheckBox createCleanUpCheckBox(String label, String resource) {
        ZResource res = ZApp.getTheApp().getResource();
        boolean selected = res.getBoolean(resource);
        JCheckBox chk = new JCheckBox(label);
        chk.setSelected(selected);
        return chk;
    }


    /**
      * N[AbvResourceݒ
      *
      * @return void
      */
    private void setCleanUpResource() {

        /* [cleanup.page]ݒ */
        ZResource res = ZApp.getTheApp().getResource();
        res.putBoolean(CLEANUP_PAGE, mCleanUpPage.isSelected());

        /* [cleanup.resource]ݒ */
        res.putBoolean(CLEANUP_RESOURCE, mCleanUpResource.isSelected());

        /* [cleanup.document]ݒ */
        res.putBoolean(CLEANUP_DOCUMENT, mCleanUpDocument.isSelected());

    }

}
